/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.suggestion;

import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.suggestion.DocumentationSuggestionProvider;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchSuggestions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class FullSuggestionFinder {
    private final DocumentationSuggestionProvider fSuggestionProvider;
    private final Collection<InformationType> fTypes;
    private final String fSearchText;
    private final int fMaxPerGroup;

    public FullSuggestionFinder(DocumentationSuggestionProvider provider, Collection<InformationType> types, String searchText, int maxPerGroup) {
        this.fSuggestionProvider = provider;
        this.fTypes = types;
        this.fSearchText = searchText;
        this.fMaxPerGroup = maxPerGroup;
    }

    public Map<InformationType, SearchResults<PageSuggestion>> getPageSuggestions() throws SearchException {
        String[] searchWords = this.fSearchText.split("\\W+");
        LinkedHashMap<InformationType, SearchResults<PageSuggestion>> pages = new LinkedHashMap<InformationType, SearchResults<PageSuggestion>>();
        for (InformationType type : this.fTypes) {
            SearchResults<PageSuggestion> typeSuggestions = this.fSuggestionProvider.findSuggestions(type, searchWords, 0, this.fMaxPerGroup);
            pages.put(type, typeSuggestions);
        }
        return pages;
    }

    public SearchSuggestions getWordSuggestions() throws SearchException {
        return this.fSuggestionProvider.findWordSuggestions(this.fSearchText, this.fMaxPerGroup);
    }
}

