/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference.map;

import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.helpsearch.reference.map.RefMappingPart;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ReferenceMapping
implements Comparable<ReferenceMapping> {
    private static final Map<RefEntityType, Integer> OVERRIDDEN_TYPE_PRIORITIES = new EnumMap<RefEntityType, Integer>(RefEntityType.class);
    private final List<RefMappingPart> fDestinationParts;
    private final RefEntityType fDestType;

    ReferenceMapping(String srcPattern, String destPattern, RefEntityType destType) {
        Map<String, Integer> srcWildcards = ReferenceMapping.resolveSrcWildcards(srcPattern);
        List<RefMappingPart> mappingParts = srcWildcards.isEmpty() ? ReferenceMapping.createSimpleMapping(destPattern) : ReferenceMapping.resolveDestWildcards(srcWildcards, destPattern);
        this.fDestinationParts = mappingParts;
        this.fDestType = destType;
    }

    private static Map<String, Integer> resolveSrcWildcards(String srcPattern) {
        HashMap<String, Integer> wildcards = new HashMap<String, Integer>();
        String[] srcPatternParts = srcPattern.split("\\.");
        for (int i = 0; i < srcPatternParts.length; ++i) {
            String part = srcPatternParts[i];
            if (!ReferenceMapping.isWildcardPart(part)) continue;
            wildcards.put(part, i);
        }
        return wildcards;
    }

    private static List<RefMappingPart> resolveDestWildcards(Map<String, Integer> srcWildcards, String destPattern) {
        String[] destPartStrings = destPattern.split("\\.");
        ArrayList<RefMappingPart> destParts = new ArrayList<RefMappingPart>(destPartStrings.length);
        for (String destPart : destPartStrings) {
            if (ReferenceMapping.isWildcardPart(destPart)) {
                destParts.add(new RefMappingPart(srcWildcards.get(destPart)));
                continue;
            }
            destParts.add(new RefMappingPart(destPart));
        }
        return destParts;
    }

    private static List<RefMappingPart> createSimpleMapping(String destPattern) {
        String[] destPartStrings = destPattern.split("\\.");
        ArrayList<RefMappingPart> destParts = new ArrayList<RefMappingPart>(destPartStrings.length);
        for (String destPart : destPartStrings) {
            destParts.add(new RefMappingPart(destPart));
        }
        return destParts;
    }

    private static boolean isWildcardPart(String part) {
        return part.startsWith("[") && part.endsWith("]");
    }

    ReferenceEntity mapSourceEntity(String[] pathParts, RefEntityType srcType) {
        StringBuilder entityName = new StringBuilder();
        for (RefMappingPart part : this.fDestinationParts) {
            entityName.append('.').append(part.getPartValue(pathParts));
        }
        return new ReferenceEntity(this.fDestType, entityName.substring(1));
    }

    @Override
    public int compareTo(ReferenceMapping o) {
        int otherNumParts;
        if (this.fDestType != o.fDestType) {
            return ReferenceMapping.compareByType(this.fDestType, o.fDestType);
        }
        int numParts = this.fDestinationParts.size();
        if (numParts != (otherNumParts = o.fDestinationParts.size())) {
            return otherNumParts - numParts;
        }
        for (int i = this.fDestinationParts.size() - 1; i >= 0; --i) {
            RefMappingPart otherPart;
            RefMappingPart thisPart = this.fDestinationParts.get(i);
            if (thisPart.equals(otherPart = o.fDestinationParts.get(i))) continue;
            return thisPart.compareTo(otherPart);
        }
        return 0;
    }

    private static int compareByType(RefEntityType type1, RefEntityType type2) {
        if (OVERRIDDEN_TYPE_PRIORITIES.containsKey((Object)type1)) {
            if (OVERRIDDEN_TYPE_PRIORITIES.containsKey((Object)type2)) {
                return OVERRIDDEN_TYPE_PRIORITIES.get((Object)type1).compareTo(OVERRIDDEN_TYPE_PRIORITIES.get((Object)type2));
            }
            return -1;
        }
        if (OVERRIDDEN_TYPE_PRIORITIES.containsKey((Object)type2)) {
            return 1;
        }
        return type1.compareTo(type2);
    }

    public int hashCode() {
        return this.fDestinationParts.hashCode() + this.fDestType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ReferenceMapping) {
            ReferenceMapping other = (ReferenceMapping)obj;
            return this.fDestType == other.fDestType && this.fDestinationParts.equals(other.fDestinationParts);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (RefMappingPart part : this.fDestinationParts) {
            sb.append('.').append(part.toString());
        }
        return "Source pattern mapped to " + sb.substring(1) + " (" + (Object)((Object)this.fDestType) + ")";
    }

    static {
        OVERRIDDEN_TYPE_PRIORITIES.put(RefEntityType.METHOD, 0);
        OVERRIDDEN_TYPE_PRIORITIES.put(RefEntityType.PROPERTY, 1);
        OVERRIDDEN_TYPE_PRIORITIES.put(RefEntityType.FUNCTION, 2);
        OVERRIDDEN_TYPE_PRIORITIES.put(RefEntityType.CLASS, 3);
    }
}

