/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.SearchExpressionFilter;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.helpsearch.reference.ReferenceRetrievalStrategy;
import com.mathworks.search.ListSearchResultCollector;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchResults;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SearchEngineReferenceStrategy
implements ReferenceRetrievalStrategy {
    private final SearchEngine fSearchEngine;
    private final SearchResultAdapter<Collection<ReferenceData>> fResultAdapter;
    private final SearchExpressionFilter fFilter;

    public SearchEngineReferenceStrategy(SearchConfig config, DocumentationSet docSet) {
        this(config, docSet, null);
    }

    public SearchEngineReferenceStrategy(SearchConfig config, DocumentationSet docSet, SearchExpressionFilter filter) {
        this(DocSearchEngineFactory.createSearchEngine(config, docSet), docSet, filter);
    }

    public SearchEngineReferenceStrategy(SearchEngine engine, DocumentationSet docSet) {
        this(engine, docSet, null);
    }

    public SearchEngineReferenceStrategy(SearchEngine engine, DocumentationSet docSet, SearchExpressionFilter filter) {
        this.fSearchEngine = engine;
        this.fResultAdapter = new ReferenceDataAdapter(docSet);
        this.fFilter = filter;
    }

    @Override
    public List<ReferenceData> getReferenceData(ReferenceRequest request) {
        try {
            SearchExpression expression = request.getFullSearchExpression();
            if (this.fFilter != null) {
                expression = this.fFilter.addFilterToExpression(expression);
            }
            SearchCriteria criteria = new SearchCriteria(expression);
            SearchResults<Collection<ReferenceData>> results = this.getReferenceData(criteria);
            return SearchEngineReferenceStrategy.toList(results);
        }
        catch (Exception ioe) {
            return Collections.emptyList();
        }
    }

    @Override
    public void close() throws IOException {
        this.fSearchEngine.closeIndex();
    }

    private SearchResults<Collection<ReferenceData>> getReferenceData(SearchCriteria criteria) throws IOException, SearchException {
        ListSearchResultCollector resultsCollector = ListSearchResultCollector.createCollector(this.fResultAdapter);
        this.fSearchEngine.search(criteria, new SearchResultCollector[]{resultsCollector});
        return resultsCollector.getResults(0, resultsCollector.getNumResults());
    }

    private static List<ReferenceData> toList(SearchResults<Collection<ReferenceData>> results) {
        ArrayList<ReferenceData> resultsList = new ArrayList<ReferenceData>(results.getNumIncluded());
        for (Collection data : results) {
            resultsList.addAll(data);
        }
        return resultsList;
    }

    private static class ReferenceDataAdapter
    implements SearchResultAdapter<Collection<ReferenceData>> {
        private final DocumentationSet iDocSet;

        private ReferenceDataAdapter(DocumentationSet docSet) {
            this.iDocSet = docSet;
        }

        public Collection<ReferenceData> adaptResult(SearchResult result) {
            return ReferenceData.fromSearchResult(this.iDocSet, result);
        }
    }
}

