/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.ProductSearchExpression;
import com.mathworks.helpsearch.reference.CompoundReferenceComparator;
import com.mathworks.helpsearch.reference.EntityTypeComparator;
import com.mathworks.helpsearch.reference.ProductOrderComparator;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SimpleSearchExpression;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;

public abstract class ReferenceRequest {
    private Collection<DocProduct> fProducts;
    private Collection<RefEntityType> fTypes;
    private Comparator<ReferenceData> fResultComparator = ReferenceRequest.buildDefaultComparator();

    protected ReferenceRequest() {
    }

    public ReferenceRequest addProducts(DocProduct ... products) {
        if (this.fProducts == null) {
            this.fProducts = new LinkedList<DocProduct>();
        }
        this.fProducts.addAll(Arrays.asList(products));
        return this;
    }

    public ReferenceRequest addReferenceTypes(RefEntityType ... types) {
        if (this.fTypes == null) {
            this.fTypes = EnumSet.noneOf(RefEntityType.class);
        }
        this.fTypes.addAll(Arrays.asList(types));
        return this;
    }

    public ReferenceRequest setResultComparator(Comparator<ReferenceData> comparator) {
        this.fResultComparator = comparator == null ? ReferenceRequest.buildDefaultComparator() : new CompoundReferenceComparator(comparator, this.fResultComparator);
        return this;
    }

    protected abstract SearchExpression getBaseExpression();

    SearchExpression getFullSearchExpression() {
        LinkedList<Object> allExpressions = new LinkedList<Object>();
        SimpleSearchExpression limitToRefPages = new SimpleSearchExpression("1", BooleanSearchOperator.MUST_OCCUR);
        limitToRefPages.addSearchField((SearchField)DocumentationSearchField.REFPAGE_FLAG);
        allExpressions.add(limitToRefPages);
        SearchExpression baseExpression = this.getBaseExpression();
        if (baseExpression != null) {
            allExpressions.add(baseExpression);
        }
        if (this.fProducts != null && !this.fProducts.isEmpty()) {
            allExpressions.add(ReferenceRequest.buildCollectionExpression(this.fProducts, new ProductExpressionBuilder()));
        }
        if (this.fTypes != null && !this.fTypes.isEmpty()) {
            allExpressions.add(ReferenceRequest.buildCollectionExpression(this.fTypes, new TypeExpressionBuilder()));
        }
        if (allExpressions.size() > 1) {
            return new CompoundSearchExpression(allExpressions);
        }
        return (SearchExpression)allExpressions.get(0);
    }

    Comparator<ReferenceData> getResultComparator() {
        return this.fResultComparator;
    }

    protected Collection<DocProduct> getProducts() {
        if (this.fProducts == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.fProducts);
    }

    private static <T> SearchExpression buildCollectionExpression(Collection<T> items, ItemExpressionBuilder<T> builder) {
        switch (items.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return builder.buildSearchExpression(items.iterator().next(), BooleanSearchOperator.MUST_OCCUR);
            }
        }
        LinkedList<SearchExpression> typeExpressions = new LinkedList<SearchExpression>();
        for (T item : items) {
            typeExpressions.add(builder.buildSearchExpression(item, BooleanSearchOperator.SHOULD_OCCUR));
        }
        CompoundSearchExpression cse = new CompoundSearchExpression(typeExpressions);
        cse.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
        return cse;
    }

    private static Comparator<ReferenceData> buildDefaultComparator() {
        return new CompoundReferenceComparator(new EntityTypeComparator(), new ProductOrderComparator());
    }

    private static class ProductExpressionBuilder
    implements ItemExpressionBuilder<DocProduct> {
        private ProductExpressionBuilder() {
        }

        @Override
        public SearchExpression buildSearchExpression(DocProduct product, BooleanSearchOperator operator) {
            ProductSearchExpression expr = new ProductSearchExpression(product.getShortName(), false);
            expr.setBooleanOperator(operator);
            return expr;
        }
    }

    private static class TypeExpressionBuilder
    implements ItemExpressionBuilder<RefEntityType> {
        private TypeExpressionBuilder() {
        }

        @Override
        public SearchExpression buildSearchExpression(RefEntityType type, BooleanSearchOperator operator) {
            SimpleSearchExpression expr = new SimpleSearchExpression(type.getIndexValue(), operator);
            expr.addSearchField((SearchField)DocumentationSearchField.REFPAGE_ENTITY_TYPE);
            return expr;
        }
    }

    private static interface ItemExpressionBuilder<T> {
        public SearchExpression buildSearchExpression(T var1, BooleanSearchOperator var2);
    }
}

