/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product.validation;

import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ValidationResponse {
    private final Map<Status, List<String>> fMessages;
    private final List<String> fTroubleshootingSteps = new LinkedList<String>();
    private final List<Throwable> fExceptions = new LinkedList<Throwable>();

    public ValidationResponse() {
        this.fMessages = new EnumMap<Status, List<String>>(Status.class);
        for (Status status : Status.values()) {
            this.fMessages.put(status, new LinkedList());
        }
    }

    public void addMessage(Status status, String message) {
        List<String> messages = this.fMessages.get((Object)status);
        messages.add(message);
    }

    public Map<Status, List<String>> getMessages() {
        return Collections.unmodifiableMap(this.fMessages);
    }

    public Status getSeverity() {
        for (Status status : Status.values()) {
            if (this.fMessages.get((Object)status).size() <= 0) continue;
            return status;
        }
        return Status.OK;
    }

    public void addTroubleshootingStep(String step) {
        this.fTroubleshootingSteps.add(step);
    }

    public List<String> getTroubleshootingSteps() {
        return Collections.unmodifiableList(this.fTroubleshootingSteps);
    }

    public void addException(Throwable t) {
        this.fExceptions.add(t);
    }

    public List<Throwable> getExceptions() {
        return Collections.unmodifiableList(this.fExceptions);
    }

    public static enum Status {
        ERROR("Error"),
        WARNING("Warning"),
        OK("OK");

        private final String fDisplay;

        private Status(String display) {
            this.fDisplay = display;
        }

        public String getDisplayName() {
            return this.fDisplay;
        }
    }
}

