/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.product.BaseCodeMapBuilder;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;

public class PropertiesBaseCodeMapBuilder
implements BaseCodeMapBuilder {
    private final Properties fBaseCodeProperties;

    public PropertiesBaseCodeMapBuilder(InputStream inputStream) throws IOException {
        this.fBaseCodeProperties = new Properties();
        this.fBaseCodeProperties.load(inputStream);
    }

    public PropertiesBaseCodeMapBuilder(Reader reader) throws IOException {
        this.fBaseCodeProperties = new Properties();
        this.fBaseCodeProperties.load(reader);
    }

    public PropertiesBaseCodeMapBuilder(File file) throws IOException {
        this(new FileReader(file));
    }

    public PropertiesBaseCodeMapBuilder(Properties props) {
        this.fBaseCodeProperties = props;
    }

    @Override
    public void populateBaseCodeMap(DocumentationSet docSet) {
        for (DocProduct product : docSet.getAllProducts()) {
            String key = product.getShortName();
            if (this.fBaseCodeProperties.containsKey(key)) {
                String baseCodeString = this.fBaseCodeProperties.getProperty(key);
                docSet.getBaseCodeMap().addProduct(product, baseCodeString == null ? "" : baseCodeString);
                continue;
            }
            docSet.getBaseCodeMap().addProduct(product, null);
        }
    }
}

