/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.report;

import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.index.DocLink;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.index.report.HeaderReportPart;
import com.mathworks.helpsearch.index.report.ListReportPart;
import com.mathworks.helpsearch.index.report.ReportPart;
import com.mathworks.helpsearch.index.report.StringReportPart;
import com.mathworks.helpsearch.index.report.TableReportPart;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.SearchField;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class IndexReportUtils {
    IndexReportUtils() {
    }

    static List<ReportPart> createMicrodataReportParts(Collection<MicrodataItem> items) {
        LinkedList<ReportPart> parts = new LinkedList<ReportPart>();
        for (MicrodataItem item : items) {
            parts.addAll(IndexReportUtils.createPartsForItem(item));
        }
        return parts;
    }

    private static Collection<ReportPart> createPartsForItem(MicrodataItem item) {
        String propertyName;
        LinkedList<ReportPart> parts = new LinkedList<ReportPart>();
        parts.add(new HeaderReportPart("Item type: " + item.getItemType(), 4));
        TableReportPart table = new TableReportPart();
        for (Map.Entry<String, List<String>> entry : item.getStringProperties().entrySet()) {
            propertyName = entry.getKey();
            List<String> values = entry.getValue();
            ReportPart valuesPart = values.size() == 1 ? new StringReportPart(values.get(0)) : ListReportPart.fromStrings(values, ListReportPart.Direction.VERTICAL);
            table.addPart(propertyName, valuesPart);
        }
        for (Map.Entry<String, List<Object>> entry : item.getItemProperties().entrySet()) {
            propertyName = entry.getKey();
            List<Object> childItems = entry.getValue();
            LinkedList<ReportPart> childParts = new LinkedList<ReportPart>();
            for (MicrodataItem microdataItem : childItems) {
                childParts.addAll(IndexReportUtils.createPartsForItem(microdataItem));
            }
            table.addPart(propertyName, new ListReportPart(childParts, ListReportPart.Direction.VERTICAL));
        }
        parts.add(table);
        return parts;
    }

    static ReportPart createDocumentationDocumentReportPart(DocumentationDocument document) {
        List<DocLink> seeAlsoLinks;
        List<String> syntaxLines;
        List<ReferenceData> nestedReferenceItems;
        TableReportPart table = new TableReportPart();
        table.addStringPart("Title", document.getTitle());
        table.addStringPart("Summary", document.getPageSummary());
        table.addStringPart("Description", document.getDescription());
        table.addStringPart("Information Type", document.getType().toString());
        LinkedList<ReportPart> breadCrumbParts = new LinkedList<ReportPart>();
        for (ResultCategory breadcrumb : document.getBreadCrumbs()) {
            breadCrumbParts.add(IndexReportUtils.getBreadCrumbReportPart(breadcrumb));
        }
        table.addPart("Breadcrumbs", new ListReportPart(breadCrumbParts, ListReportPart.Direction.VERTICAL));
        List<ReferenceEntity> refEntities = document.getReferenceEntities();
        if (refEntities != null && !refEntities.isEmpty()) {
            LinkedList<String> refEntityStrings = new LinkedList<String>();
            for (ReferenceEntity entity : refEntities) {
                refEntityStrings.add(entity.getName() + " : " + (Object)((Object)entity.getType()));
            }
            table.addPart("Reference Entities", ListReportPart.fromStrings(refEntityStrings, ListReportPart.Direction.VERTICAL));
        }
        if ((nestedReferenceItems = document.getNestedReferenceData()) != null && !nestedReferenceItems.isEmpty()) {
            LinkedList<String> refItemStrings = new LinkedList<String>();
            for (ReferenceData refData : nestedReferenceItems) {
                refItemStrings.add(refData.getTopic() + " : " + (Object)((Object)refData.getType()));
            }
            table.addPart("Nested Reference Entities", ListReportPart.fromStrings(refItemStrings, ListReportPart.Direction.VERTICAL));
        }
        if ((syntaxLines = document.getSyntaxLines()) != null && !syntaxLines.isEmpty()) {
            table.addPart("Syntax Lines", ListReportPart.fromStrings(syntaxLines, ListReportPart.Direction.VERTICAL));
        }
        if ((seeAlsoLinks = document.getSeeAlsoLinks()) != null && !seeAlsoLinks.isEmpty()) {
            LinkedList<String> seeAlsoStrings = new LinkedList<String>();
            for (DocLink seeAlsoLink : seeAlsoLinks) {
                seeAlsoStrings.add(seeAlsoLink.getLabel() + " (" + seeAlsoLink.getPath() + ") (" + (Object)((Object)seeAlsoLink.getLocation()) + ")");
            }
            table.addPart("See Also Links", ListReportPart.fromStrings(seeAlsoStrings, ListReportPart.Direction.VERTICAL));
        }
        table.addStringPart("Body", document.getBody());
        return table;
    }

    private static ReportPart getBreadCrumbReportPart(ResultCategory category) {
        List<ResultCategory> nodes = category.getNodesRootFirst();
        LinkedList<String> breadCrumbStrings = new LinkedList<String>();
        for (ResultCategory node : nodes) {
            breadCrumbStrings.add(node.getLabel() + " (" + node.getRelativePath() + ")");
        }
        return ListReportPart.fromStrings(breadCrumbStrings, ListReportPart.Direction.HORIZONTAL);
    }

    static ReportPart createIndexDocumentReportPart(IndexDocument<? extends SearchField> indexDoc) {
        TableReportPart table = new TableReportPart();
        Map values = indexDoc.getIndexValues();
        for (Map.Entry value : values.entrySet()) {
            String fieldName = ((SearchField)value.getKey()).getFieldName();
            String fieldValue = (String)value.getValue();
            table.addStringPart(fieldName, fieldValue);
        }
        return table;
    }
}

