/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.FileHelpPathBuilder;
import com.mathworks.helpsearch.index.DocLink;
import com.mathworks.helpsearch.index.LinkResolver;
import com.mathworks.helpsearch.product.DocSetItem;
import java.io.File;

public class ProductLinkResolver
implements LinkResolver {
    private final File fDocRoot;
    private final File fHelpLoc;
    private final File fFromDir;

    public ProductLinkResolver(File docRoot, DocSetItem docSetItem, String relPath) {
        this.fDocRoot = ProductLinkResolver.makeCanonical(docRoot);
        this.fHelpLoc = ProductLinkResolver.makeCanonical(docSetItem.getHelpLocation().buildHelpPath(this.fDocRoot, new FileHelpPathBuilder(), new String[0]));
        File fromDir = new File(this.fHelpLoc, relPath);
        if (!fromDir.isDirectory()) {
            fromDir = fromDir.getParentFile();
        }
        this.fFromDir = ProductLinkResolver.makeCanonical(fromDir);
    }

    @Override
    public DocLink resolveLink(String toRelPath, String label) {
        File toFile = ProductLinkResolver.makeCanonical(new File(this.fFromDir, toRelPath));
        return this.getRelativePathFromProduct(toFile, label);
    }

    private static File makeCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            return file;
        }
    }

    private DocLink getRelativePathFromProduct(File file, String label) {
        StringBuilder relPath = new StringBuilder();
        for (File current = file; current != null; current = current.getParentFile()) {
            if (current.equals(this.fHelpLoc)) {
                return new DocLink(DocLink.Location.IN_PRODUCT, relPath.toString(), label);
            }
            if (current.equals(this.fDocRoot)) {
                return new DocLink(DocLink.Location.CROSS_PRODUCT, relPath.toString(), label);
            }
            if (relPath.length() > 0) {
                relPath.insert(0, '/');
            }
            relPath.insert(0, current.getName());
        }
        return null;
    }
}

