/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.LocalizedFileLocator;
import java.io.File;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocaleFileLocator
implements LocalizedFileLocator {
    private final String fLocaleSuffix;
    private final Pattern fLocalePattern;

    public LocaleFileLocator(Locale locale) {
        this.fLocaleSuffix = LocaleFileLocator.getSuffixForLocale(locale);
        this.fLocalePattern = Pattern.compile("^(.*?)(?:" + Pattern.quote(this.fLocaleSuffix) + ")?(\\.[^\\\\/.]*)?$");
    }

    private static String getSuffixForLocale(Locale locale) {
        if (locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            return "";
        }
        return "_" + locale.getLanguage() + "_" + locale.getCountry();
    }

    @Override
    public String findLocalizedFile(File parentDir, String relPath) {
        Matcher fileMatcher = this.fLocalePattern.matcher(relPath);
        if (fileMatcher.find()) {
            File toCheck;
            String localized = LocaleFileLocator.buildFileName(fileMatcher, this.fLocaleSuffix);
            File file = toCheck = parentDir == null ? new File(localized) : new File(parentDir, localized);
            if (this.doesFileExist(toCheck)) {
                return localized;
            }
            return LocaleFileLocator.buildFileName(fileMatcher, null);
        }
        return relPath;
    }

    @Override
    public String getUnlocalizedFileName(String path) {
        Matcher pathMatcher = this.fLocalePattern.matcher(path);
        if (pathMatcher.find()) {
            return LocaleFileLocator.buildFileName(pathMatcher, null);
        }
        return path;
    }

    private static String buildFileName(Matcher matcher, String localeSuffix) {
        String extension;
        StringBuilder builder = new StringBuilder(matcher.group(1));
        if (localeSuffix != null) {
            builder.append(localeSuffix);
        }
        if ((extension = matcher.group(2)) != null) {
            builder.append(extension);
        }
        return builder.toString();
    }

    @Override
    public File findLocalizedFile(File file) {
        File parentDir = file.getParentFile();
        String correctedFileName = this.findLocalizedFile(parentDir, file.getName());
        return new File(parentDir, correctedFileName);
    }

    protected boolean doesFileExist(File file) {
        return file.exists();
    }
}

