/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.w3c.dom.Document;

public class FreemarkerToDomAdapter
implements HtmlToDomAdapter {
    private final HtmlToDomAdapter baseAdapter;

    public FreemarkerToDomAdapter(HtmlToDomAdapter baseAdapter) {
        this.baseAdapter = baseAdapter;
    }

    @Override
    public Document parseDocument(InputStream is) {
        try {
            String htmlString = FreemarkerToDomAdapter.readInputStream(is);
            htmlString = FreemarkerToDomAdapter.removeFreemarkerMarkup(htmlString);
            ByteArrayInputStream correctedIs = new ByteArrayInputStream(htmlString.getBytes(Charset.forName("UTF-8")));
            return this.baseAdapter.parseDocument(correctedIs);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String removeFreemarkerMarkup(String rawHtml) {
        String html = rawHtml.replaceAll("<#[^>]*>", "");
        html = html.replaceFirst("<@html[^>]*>", "<html itemscope itemtype=\"http://www.mathworks.com/help/schema/MathWorksDocPage\">");
        int htmlTagIndex = (html = html.replaceAll("(</?)@([^>]+>)", "$1$2")).indexOf("<html");
        if (htmlTagIndex > 0) {
            html = html.substring(htmlTagIndex);
        }
        return html;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readInputStream(InputStream inputStream) throws IOException {
        StringBuilder contents = new StringBuilder();
        char[] buffer = new char[256];
        try (InputStreamReader isr = new InputStreamReader(inputStream, "utf-8");){
            int numRead = isr.read(buffer, 0, 256);
            while (numRead > 0) {
                contents.append(buffer, 0, numRead);
                numRead = isr.read(buffer, 0, 256);
            }
            String string = contents.toString();
            return string;
        }
    }
}

