/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DocumentBody {
    private static final Map<String, TagType> TAG_TYPE_MAP = DocumentBody.buildTagTypeMap();
    private final StringBuilder fBody = new StringBuilder();
    private DocumentFragment fCurrentFragment = null;
    private String fFinalBody = null;

    private static Map<String, TagType> buildTagTypeMap() {
        HashMap<String, TagType> map = new HashMap<String, TagType>();
        for (TagType type : TagType.values()) {
            String[] tags;
            for (String tag : tags = type.getTagNames()) {
                map.put(tag.toUpperCase(Locale.ENGLISH), type);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public void appendText(String text) {
        this.fCurrentFragment = this.fCurrentFragment == null ? new TextFragment(text) : this.fCurrentFragment.handleTextAfterFragment(text);
    }

    public void appendTagReplacement(String tagName) {
        this.fCurrentFragment = this.fCurrentFragment == null ? new TagFragment(tagName) : this.fCurrentFragment.handleTagAfterFragment(tagName);
    }

    public void cleanup() {
        String body = this.fBody.toString();
        body = body.replaceAll("\\xa0", " ");
        body = body.replaceAll("\\s*\\n\\s*", "\n");
        body = body.replaceAll("\\s{2,}", " ");
        body = body.replaceAll("(?<!\\.)\\. ", ".\n");
        this.fFinalBody = body.trim();
    }

    public synchronized String getBody() {
        if (this.fFinalBody == null) {
            this.cleanup();
        }
        return this.fFinalBody;
    }

    private class TagFragment
    implements DocumentFragment {
        private TagType iDominantTagType = TagType.NO_WORD_BREAK;

        private TagFragment(String tagName) {
            this.iDominantTagType = this.getTagType(tagName);
        }

        @Override
        public DocumentFragment handleTextAfterFragment(String text) {
            DocumentBody.this.fBody.append(this.determineTagReplacement(text));
            return new TextFragment(text);
        }

        private String determineTagReplacement(String followingText) {
            switch (this.iDominantTagType) {
                case NO_WORD_BREAK: {
                    return "";
                }
                case SENTENCE_BREAK: {
                    return "\n";
                }
                case POSSIBLE_WORD_BREAK: {
                    return this.isWordBreakNeeded(followingText) ? " " : "";
                }
            }
            return " ";
        }

        private boolean isWordBreakNeeded(String followingText) {
            if (DocumentBody.this.fBody.length() == 0 || followingText == null || followingText.length() == 0) {
                return false;
            }
            char lastPreceding = DocumentBody.this.fBody.charAt(DocumentBody.this.fBody.length() - 1);
            char firstFollowing = followingText.charAt(0);
            return Character.isLetterOrDigit(lastPreceding) && Character.isLetterOrDigit(firstFollowing);
        }

        @Override
        public DocumentFragment handleTagAfterFragment(String tagName) {
            this.updateDominantTagType(tagName);
            return this;
        }

        private void updateDominantTagType(String tagName) {
            TagType type = this.getTagType(tagName);
            if (type.compareTo(this.iDominantTagType) < 0) {
                this.iDominantTagType = type;
            }
        }

        private TagType getTagType(String tagName) {
            String upper = tagName.toUpperCase(Locale.ENGLISH);
            TagType type = (TagType)((Object)TAG_TYPE_MAP.get(upper));
            return type == null ? TagType.getDefault() : type;
        }
    }

    private class TextFragment
    implements DocumentFragment {
        private TextFragment(String text) {
            DocumentBody.this.fBody.append(text);
        }

        @Override
        public DocumentFragment handleTextAfterFragment(String text) {
            DocumentBody.this.fBody.append(text);
            return this;
        }

        @Override
        public DocumentFragment handleTagAfterFragment(String tagName) {
            return new TagFragment(tagName);
        }
    }

    private static interface DocumentFragment {
        public DocumentFragment handleTextAfterFragment(String var1);

        public DocumentFragment handleTagAfterFragment(String var1);
    }

    private static enum TagType {
        SENTENCE_BREAK("H1", "H2", "H3", "H4", "BR", "P", "HR", "TABLE", "TR", "TD", "DIV", "PRE", "LI", "DL", "DT", "DD"),
        WORD_BREAK(new String[0]),
        POSSIBLE_WORD_BREAK("A"),
        NO_WORD_BREAK("TT", "B", "I", "EM", "SPAN");

        private final String[] iTagNames;

        private TagType(String ... tagNames) {
            this.iTagNames = tagNames;
        }

        private String[] getTagNames() {
            return this.iTagNames;
        }

        private static TagType getDefault() {
            return WORD_BREAK;
        }
    }
}

