/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.index.DocumentBooster;
import com.mathworks.helpsearch.index.DocumentationDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

class CompositeDocumentBooster
implements DocumentBooster {
    private final List<DocumentBooster> fSubBoosters = new ArrayList<DocumentBooster>();

    CompositeDocumentBooster(DocumentBooster ... boosters) {
        this.fSubBoosters.addAll(Arrays.asList(boosters));
    }

    @Override
    public float getDocumentBoost(DocumentationDocument doc) {
        float boost = 1.0f;
        for (DocumentBooster subBooster : this.fSubBoosters) {
            float fromBooster = subBooster.getDocumentBoost(doc);
            boost *= fromBooster;
        }
        return Math.abs(boost);
    }

    @Override
    public Map<DocumentationSearchField, Float> getFieldBoosts(DocumentationDocument doc) {
        EnumMap<DocumentationSearchField, Float> boosts = new EnumMap<DocumentationSearchField, Float>(DocumentationSearchField.class);
        for (DocumentBooster subBooster : this.fSubBoosters) {
            Map<DocumentationSearchField, Float> subBoosts = subBooster.getFieldBoosts(doc);
            for (Map.Entry<DocumentationSearchField, Float> subBoost : subBoosts.entrySet()) {
                DocumentationSearchField field = subBoost.getKey();
                float boostValue = subBoost.getValue().floatValue();
                if (boosts.containsKey((Object)field)) {
                    boosts.put(field, Float.valueOf(((Float)boosts.get((Object)field)).floatValue() * boostValue));
                    continue;
                }
                boosts.put(field, Float.valueOf(boostValue));
            }
        }
        return Collections.unmodifiableMap(boosts);
    }
}

