/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.csh;

import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.csh.CshFileBundle;
import com.mathworks.helpsearch.csh.CshIndexDocumentIterator;
import com.mathworks.helpsearch.csh.CshSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.SearchField;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TopicMapFileIndexDocumentIterator
extends CshIndexDocumentIterator {
    public TopicMapFileIndexDocumentIterator(File docRoot, DocProduct product, DocLanguage language) {
        super(docRoot, product, language);
    }

    @Override
    protected List<CshFileBundle> findCshFiles(File helpLocation) {
        File topicMapsFile = new File(helpLocation, "topicmaps.loc");
        if (topicMapsFile.exists()) {
            return Arrays.asList(new CshFileBundle(topicMapsFile, this.getLanguage()));
        }
        return Collections.emptyList();
    }

    @Override
    protected IndexDocument<CshSearchField> createIndexDocument(File cshFile, String key, String value) {
        IndexDocument indexDoc = new IndexDocument();
        indexDoc.addFieldValue((SearchField)CshSearchField.TOPIC_MAP_KEY, key);
        indexDoc.addFieldValue((SearchField)CshSearchField.CSH_TARGET, value);
        return indexDoc;
    }
}

