/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.facets.DocFacet;
import com.mathworks.helpsearch.facets.Facetable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentationQuery {
    private static final Pattern FACET_PATTERN = Pattern.compile("(\\S+):([\\S-]+)");
    private final String fFullSearchString;
    private final String fSearchText;
    private final Map<DocFacet, String> fFacets;

    public DocumentationQuery(String fullSearchString, ContentFormat format) {
        this.fFullSearchString = fullSearchString == null ? "" : fullSearchString;
        Matcher matcher = FACET_PATTERN.matcher(this.fFullSearchString);
        this.fFacets = new LinkedHashMap<DocFacet, String>();
        StringBuffer searchText = new StringBuffer();
        while (matcher.find()) {
            String field = matcher.group(1);
            DocFacet facet = DocFacet.fromFacetPrefix(field);
            if (facet != null && facet.useFacetWithFormat(format)) {
                String rawValue = matcher.group(2);
                this.fFacets.put(facet, rawValue);
                matcher.appendReplacement(searchText, "");
                continue;
            }
            matcher.appendReplacement(searchText, "$0");
        }
        matcher.appendTail(searchText);
        this.fSearchText = searchText.toString().trim().replaceAll("\\s+", " ");
    }

    public DocumentationQuery(String searchText, Map<DocFacet, String> facets) {
        this.fSearchText = searchText;
        this.fFacets = facets.isEmpty() ? Collections.emptyMap() : new EnumMap<DocFacet, String>(facets);
        this.fFullSearchString = DocumentationQuery.assembleFullSearchString(searchText, facets);
    }

    public DocumentationQuery(String searchText, Collection<Facetable> facets) {
        this.fSearchText = searchText;
        EnumMap<DocFacet, String> facetMap = new EnumMap<DocFacet, String>(DocFacet.class);
        for (Facetable facetable : facets) {
            facetMap.put(facetable.getFacetType(), facetable.getFacetId());
        }
        this.fFacets = facetMap;
        this.fFullSearchString = DocumentationQuery.assembleFullSearchString(searchText, facetMap);
    }

    public DocumentationQuery(String searchText, Facetable ... facets) {
        this(searchText, Arrays.asList(facets));
    }

    private static String assembleFullSearchString(String searchText, Map<DocFacet, String> facets) {
        StringBuilder builder = new StringBuilder(searchText);
        for (Map.Entry<DocFacet, String> facetEntry : facets.entrySet()) {
            builder.append(' ').append(facetEntry.getKey().getFacetPrefix()).append(':').append(facetEntry.getValue());
        }
        return builder.toString();
    }

    public String getFullSearchString() {
        return this.fFullSearchString;
    }

    public String getSearchText() {
        return this.fSearchText;
    }

    public Map<DocFacet, String> getFacets() {
        return Collections.unmodifiableMap(this.fFacets);
    }
}

