/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.LuceneVersion;
import com.mathworks.search.lucene.MWAnalyzer;
import java.io.Reader;
import java.util.EnumMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.lucene.util.Version;

public class DocumentationAnalyzer
extends AnalyzerWrapper {
    private final Analyzer fBaseAnalyzer;
    private static final Map<SearchLanguage, DocumentationAnalyzer> INDEX_ANALYZERS = DocumentationAnalyzer.buildIndexAnalyzers();
    private static final Map<SearchLanguage, DocumentationAnalyzer> SEARCH_ANALYZERS = DocumentationAnalyzer.buildSearchAnalyzers();

    private static Map<SearchLanguage, DocumentationAnalyzer> buildIndexAnalyzers() {
        EnumMap<SearchLanguage, DocumentationAnalyzer> analyzers = new EnumMap<SearchLanguage, DocumentationAnalyzer>(SearchLanguage.class);
        for (SearchLanguage language : SearchLanguage.values()) {
            analyzers.put(language, new DocumentationAnalyzer(new MWAnalyzer(language).getIndexAnalyzer()));
        }
        return analyzers;
    }

    private static Map<SearchLanguage, DocumentationAnalyzer> buildSearchAnalyzers() {
        EnumMap<SearchLanguage, DocumentationAnalyzer> analyzers = new EnumMap<SearchLanguage, DocumentationAnalyzer>(SearchLanguage.class);
        for (SearchLanguage language : SearchLanguage.values()) {
            analyzers.put(language, new DocumentationAnalyzer(new MWAnalyzer(language).getSearchAnalyzer()));
        }
        return analyzers;
    }

    private DocumentationAnalyzer(Analyzer baseAnalyzer) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.fBaseAnalyzer = baseAnalyzer;
    }

    public static DocumentationAnalyzer getIndexAnalyzer(SearchLanguage language) {
        return INDEX_ANALYZERS.get(language);
    }

    public static DocumentationAnalyzer getSearchAnalyzer(SearchLanguage language) {
        return SEARCH_ANALYZERS.get(language);
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        DocumentationSearchField searchField = DocumentationSearchField.fromFieldName(fieldName);
        if (searchField != null) {
            switch (searchField) {
                case REFPAGE_ENTITY_INFO: 
                case REFPAGE_ENTITY_NAME: {
                    return new LowerCaseNewLineAnalyzer(LuceneVersion.CURRENT_VERSION);
                }
                case REFPAGE_ENTITY_INFO_CASE: 
                case REFPAGE_ENTITY_NAME_CASE: 
                case REFPAGE_ENTITY_TYPE: {
                    return new NewLineAnalyzer(LuceneVersion.CURRENT_VERSION);
                }
                case ANCESTOR_ID: 
                case EXAMPLE_ID: {
                    return new WhitespaceAnalyzer(LuceneVersion.CURRENT_VERSION);
                }
            }
        }
        return this.fBaseAnalyzer;
    }

    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return components;
    }

    protected Reader wrapReader(String fieldName, Reader reader) {
        return super.wrapReader(fieldName, reader);
    }

    private static class NewLineAnalyzer
    extends Analyzer {
        private final Version matchVersion;

        public NewLineAnalyzer(Version matchVersion) {
            this.matchVersion = matchVersion;
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            NewlineTokenizer source = new NewlineTokenizer(this.matchVersion, reader);
            return new Analyzer.TokenStreamComponents((Tokenizer)source);
        }
    }

    private static class LowerCaseNewLineAnalyzer
    extends Analyzer {
        private final Version matchVersion;

        public LowerCaseNewLineAnalyzer(Version matchVersion) {
            this.matchVersion = matchVersion;
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            NewlineTokenizer source = new NewlineTokenizer(this.matchVersion, reader);
            LowerCaseFilter filter = new LowerCaseFilter(this.matchVersion, (TokenStream)source);
            return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)filter);
        }
    }

    private static class NewlineTokenizer
    extends CharTokenizer {
        public NewlineTokenizer(Version matchVersion, Reader reader) {
            super(matchVersion, reader);
        }

        protected boolean isTokenChar(int c) {
            return c != 10;
        }
    }
}

