/*
 * Decompiled with CFR 0.152.
 */
package ice.util.memory;

import ice.util.Defs;

public class MemoryManager {
    private static MemoryManager OEAB;
    protected final Runtime runtime = Runtime.getRuntime();
    protected long minMemory = 300000L;
    protected long maxMemory = 64000000L;

    public static void setInstance(MemoryManager memoryManager) {
        OEAB = memoryManager;
    }

    public static MemoryManager getInstance() {
        if (OEAB == null) {
            OEAB = new MemoryManager();
        }
        return OEAB;
    }

    protected MemoryManager() {
        try {
            int n = MemoryManager.OEAB("ice.browser.minMemory");
            if (n > 0) {
                this.minMemory = n;
            }
            if ((long)(n = MemoryManager.OEAB("ice.browser.maxMemory")) > this.minMemory) {
                this.maxMemory = n;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static final int OEAB(String string) {
        String string2 = Defs.sysProperty(string);
        if (string2 == null) {
            return -1;
        }
        int n = 1;
        char c = string2.charAt(string2.length() - 1);
        if (c == 'k' || c == 'K') {
            n = 1024;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (c == 'm' || c == 'M') {
            n = 0x100000;
            string2 = string2.substring(0, string2.length() - 1);
        }
        return n * Integer.parseInt(string2);
    }

    public void setMinMemory(long l) {
        this.minMemory = l;
    }

    public long getMinMemory() {
        return this.minMemory;
    }

    public void setMaxMemory(long l) {
        this.maxMemory = l;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public boolean canAllocate(int n) {
        long l = this.runtime.freeMemory();
        if (l - (long)n > this.minMemory) {
            return true;
        }
        long l2 = this.runtime.totalMemory();
        if (this.maxMemory > l2 && (l += this.maxMemory - l2) - (long)n > this.minMemory) {
            return true;
        }
        System.gc();
        l = this.runtime.freeMemory();
        if (l - (long)n > this.minMemory) {
            return true;
        }
        System.runFinalization();
        System.gc();
        l = this.runtime.freeMemory();
        return l - (long)n > this.minMemory;
    }

    public boolean isLowMemory() {
        return !this.canAllocate(0);
    }
}

