/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt;

import ice.debug.Debug;
import ice.util.awt.AwtQueueKit;
import ice.util.awt.QueueElem;
import java.lang.reflect.InvocationTargetException;

public class TimedAWTExecutor {
    private final AwtQueueKit J = AwtQueueKit.newInstance();
    private final Object OEAB = new Object();
    private volatile Thread Z = new Thread(this, "Timer queue for AWT thread"){
        private final TimedAWTExecutor this$0;
        {
            this.this$0 = timedAWTExecutor;
        }

        public void run() {
            this.this$0.runScheduler();
        }
    };
    private QueueElem append;
    private QueueElem code;
    private long currentTimeMillis = 0L;
    private long deliveryTime = 0L;

    public TimedAWTExecutor() {
        this.Z.setDaemon(true);
        this.Z.start();
    }

    public boolean isEventThread() {
        return this.J.isDispatchThread();
    }

    private long J() {
        long l = System.currentTimeMillis();
        if (l < this.currentTimeMillis) {
            if (Debug.trace) {
                Debug.trace("TIME BUG, diff=" + (l - this.currentTimeMillis));
            }
            long l2 = this.currentTimeMillis - l;
            this.deliveryTime += l2;
        }
        this.currentTimeMillis = l;
        return this.deliveryTime + l;
    }

    public void shutdown() {
        Object object = this.OEAB;
        synchronized (object) {
            if (this.Z != null) {
                this.Z = null;
                QueueElem queueElem = this.append;
                this.append = null;
                this.code = null;
                while (queueElem != null) {
                    QueueElem queueElem2 = queueElem.next;
                    queueElem.prev = null;
                    queueElem.next = null;
                    queueElem = queueElem2;
                }
                this.OEAB.notify();
            }
        }
    }

    public void invokeAndWait(Runnable runnable, long l) throws InterruptedException, InvocationTargetException {
        if (AwtQueueKit.trace_awt_queue) {
            AwtQueueKit.trace_add_to_stack_trace(runnable, l);
        }
        if (this.Z != null) {
            if (l == 0L) {
                this.J.invokeAndWait(runnable);
            } else {
                QueueElem queueElem = new QueueElem();
                queueElem.code = runnable;
                Object object = this.OEAB;
                synchronized (object) {
                    queueElem.deliveryTime = this.J() + l;
                    this.Z(queueElem);
                    this.OEAB.notify();
                }
            }
        }
    }

    public void invokeLater(Runnable runnable, long l) {
        if (AwtQueueKit.trace_awt_queue) {
            AwtQueueKit.trace_add_to_stack_trace(runnable, l);
        }
        if (this.Z != null) {
            if (l == 0L) {
                this.J.invokeLater(runnable);
            } else {
                QueueElem queueElem = new QueueElem();
                queueElem.code = runnable;
                Object object = this.OEAB;
                synchronized (object) {
                    queueElem.deliveryTime = this.J() + l;
                    this.Z(queueElem);
                    this.OEAB.notify();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QueueElem OEAB() {
        Object object = this.OEAB;
        synchronized (object) {
            while (this.Z != null) {
                QueueElem queueElem = this.append();
                if (queueElem == null) {
                    if (this.Z == null) break;
                    try {
                        this.OEAB.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                long l = this.J();
                long l2 = queueElem.deliveryTime - l;
                if (l2 <= 0L) {
                    queueElem = this.code();
                    return queueElem;
                }
                try {
                    this.OEAB.wait(l2);
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }
    }

    void runScheduler() {
        while (this.Z != null) {
            QueueElem queueElem = this.OEAB();
            if (queueElem == null) break;
            this.J.invokeLater(queueElem.code);
        }
    }

    private void Z(QueueElem queueElem) {
        QueueElem queueElem2 = this.code;
        if (queueElem2 == null) {
            this.code = queueElem;
            this.append = queueElem;
        } else {
            long l = queueElem.deliveryTime;
            if (queueElem2.deliveryTime <= l) {
                queueElem.prev = queueElem2;
                queueElem2.next = queueElem;
                this.code = queueElem;
            } else {
                QueueElem queueElem3 = queueElem2.prev;
                while (queueElem3 != null) {
                    if (queueElem3.deliveryTime <= l) break;
                    queueElem3 = queueElem3.prev;
                }
                if (queueElem3 != null) {
                    queueElem.next = queueElem3.next;
                    queueElem.prev = queueElem3;
                    queueElem3.next.prev = queueElem;
                    queueElem3.next = queueElem;
                } else {
                    queueElem.next = this.append;
                    this.append.prev = queueElem;
                    this.append = queueElem;
                }
            }
        }
    }

    private QueueElem append() {
        return this.append;
    }

    private QueueElem code() {
        QueueElem queueElem = this.append;
        if (queueElem != null) {
            this.append = queueElem.next;
            if (this.append == null) {
                this.code = null;
            } else {
                this.append.prev = null;
            }
            queueElem.prev = null;
            queueElem.next = null;
        }
        return queueElem;
    }
}

