/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt;

import ice.debug.Debug;
import ice.util.Defs;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public abstract class AwtQueueKit {
    public static final boolean trace_awt_queue = Debug.trace && Defs.sysPropertyBoolean("ice.util.awt.trace_awt_queue");
    protected static final Hashtable trace_java_stack = trace_awt_queue ? new Hashtable() : null;

    public static AwtQueueKit newInstance() {
        AwtQueueKit awtQueueKit = null;
        String string = Defs.sysProperty("ice.util.awt.AwtQueueKit");
        if (string != null) {
            awtQueueKit = (AwtQueueKit)Defs.newClassInstance(string);
        }
        if (awtQueueKit == null && (awtQueueKit = (AwtQueueKit)Defs.newClassInstance(string = "ice.util.awt.jdk12.AwtQueueKit_jdk12")) == null) {
            string = "ice.util.awt.jdk11.AwtQueueKit_jdk11";
            awtQueueKit = (AwtQueueKit)Defs.newClassInstance(string);
        }
        if (Debug.trace) {
            Debug.trace(awtQueueKit != null ? string : "FAILED!");
        }
        return awtQueueKit;
    }

    public static void trace_add_to_stack_trace(Runnable runnable, long l) {
        if (trace_awt_queue) {
            Hashtable hashtable = trace_java_stack;
            synchronized (hashtable) {
                if (trace_java_stack.get(runnable) == null) {
                    Throwable throwable = new Throwable("AWT thread post stack trace for " + runnable + ", delay=" + l);
                    throwable.fillInStackTrace();
                    String string = ">>>>>>> " + Debug.getStackPrintoutAsString(throwable);
                    trace_java_stack.put(runnable, string);
                }
            }
        }
    }

    public static void trace_print_java_stack(Runnable runnable) {
        if (trace_awt_queue) {
            String string;
            Hashtable hashtable = trace_java_stack;
            synchronized (hashtable) {
                string = (String)trace_java_stack.get(runnable);
                if (string != null) {
                    trace_java_stack.remove(runnable);
                }
            }
            if (string != null) {
                Debug.traceAsIs(string);
            }
        }
    }

    public abstract void invokeAndWait(Runnable var1) throws InterruptedException, InvocationTargetException;

    public abstract void invokeLater(Runnable var1);

    public abstract boolean isDispatchThread();
}

