/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.ActionUtils;
import com.mathworks.mlwidgets.workspace.IWorkspaceActionProvider;
import com.mathworks.mlwidgets.workspace.MatlabClassActionFactory;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.VariableRecordlistModel;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceDnDListener;
import com.mathworks.mlwidgets.workspace.WorkspacePrinter;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mlwidgets.workspace.WorkspaceSelectionPopupMenu;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mlwidgets.workspace.graphics.IGraphingActionListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.util.ArrayUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistTable;
import com.mathworks.widgets.recordlist.RecordlistTableModel;
import com.mathworks.widgets.spreadsheet.IReadOnlyData;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class WorkspaceTable
extends RecordlistTable
implements IWorkspaceActionProvider,
IGraphableInfoProvider,
IGraphingActionListener,
IPlotPickerDisplayTrigger {
    private static final FormatIdentifier DEFAULT_FORMAT_ID = FormatIdentifier.getDefaultInstance();
    private MJAbstractAction fSaveAsAction = null;
    private MJAbstractAction fImportClipboardAction = null;
    private MJAbstractAction fImportFileAction = null;
    private MJAbstractAction fSaveWorkspaceAction = null;
    private MJAbstractAction fPageSetupAction = null;
    private MJAbstractAction fPrintAction = null;
    protected MJAbstractAction[] fObjectActions = null;
    protected MJAbstractAction fCatalogAction = null;
    private MJAbstractAction fPlotPickerAction = null;
    private List<PlotPickerOpener> fPlotPickerOpeners = new ArrayList<PlotPickerOpener>();
    private DropTargetListener fDropTargetListener = null;
    private List<ListSelectionListener> fGraphicListener = new Vector<ListSelectionListener>();

    public WorkspaceTable(IRecordlistModel iRecordlistModel) {
        this(new RecordlistTableModel(iRecordlistModel), null);
    }

    public WorkspaceTable(IRecordlistModel iRecordlistModel, String string) {
        this(new RecordlistTableModel(iRecordlistModel), string);
        if (iRecordlistModel instanceof VariableRecordlistModel) {
            this.setColumnComparator(((VariableRecordlistModel)iRecordlistModel).SIZE(), new VariableRecordlistModel.SizeStringComparator());
            this.setColumnComparator(((VariableRecordlistModel)iRecordlistModel).NAME(), new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareToIgnoreCase(string2);
                }
            });
        }
    }

    private WorkspaceTable(RecordlistTableModel recordlistTableModel, String string) {
        super(recordlistTableModel, string);
        ActionUtils.changePreexistingActions(this.fCreationAction, this.fOpeningAction, this.fDeletionAction);
        this.createWorkspaceActions();
        this.setFormat(DEFAULT_FORMAT_ID);
        WorkspaceSelectionPopupMenu workspaceSelectionPopupMenu = new WorkspaceSelectionPopupMenu(this);
        workspaceSelectionPopupMenu.addSeparator();
        this.setSelectionPopupMenu(workspaceSelectionPopupMenu);
        this.fDropTargetListener = new WorkspaceDnDListener((Component)((Object)this), this);
        new DropTarget((Component)((Object)this), new WorkspaceDnDListener((Component)((Object)this), this));
        this.enableDragHandling(true);
    }

    private void firePlotPickerRequested() {
        for (PlotPickerOpener plotPickerOpener : this.fPlotPickerOpeners) {
            plotPickerOpener.openPlotPicker();
        }
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.add(plotPickerOpener);
        if (this.fPlotPickerAction == null) {
            this.fPlotPickerAction = new MJAbstractAction(ArrayUtils.getResource("menu.picker")){

                public void actionPerformed(ActionEvent actionEvent) {
                    WorkspaceTable.this.firePlotPickerRequested();
                }
            };
        }
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.remove(plotPickerOpener);
    }

    private void setValueColumnRenderer(ItTableCellRenderer itTableCellRenderer) {
        try {
            this.getColumn(WorkspaceResources.getBundle().getString("fieldname.value")).setCellRenderer(itTableCellRenderer);
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void refreshObjectSpecificPopup(String[] stringArray) {
        MJPopupMenu mJPopupMenu = this.getSelectionPopupMenu();
        if (mJPopupMenu == null || !(mJPopupMenu instanceof WorkspaceSelectionPopupMenu)) {
            return;
        }
        WorkspaceSelectionPopupMenu workspaceSelectionPopupMenu = (WorkspaceSelectionPopupMenu)mJPopupMenu;
        workspaceSelectionPopupMenu.reinitialize(this);
        if (stringArray != null && stringArray.length > 0) {
            MJAbstractAction[] mJAbstractActionArray = GraphingActionFactory.getGraphingActions(stringArray, true);
            if (mJAbstractActionArray.length > 0) {
                workspaceSelectionPopupMenu.addSeparator();
                MJAbstractAction[] mJAbstractActionArray2 = mJAbstractActionArray;
                int n = mJAbstractActionArray2.length;
                for (int i = 0; i < n; ++i) {
                    MJAbstractAction mJAbstractAction = mJAbstractActionArray2[i];
                    workspaceSelectionPopupMenu.add((Action)mJAbstractAction);
                }
                if (this.fPlotPickerAction != null) {
                    workspaceSelectionPopupMenu.add((Action)this.fPlotPickerAction);
                }
                workspaceSelectionPopupMenu.addSeparator();
            } else if (workspaceSelectionPopupMenu.getComponentCount() >= 1) {
                workspaceSelectionPopupMenu.addSeparator();
            }
            workspaceSelectionPopupMenu.add((Action)this.fCatalogAction);
        }
        if (this.fObjectActions != null && this.fObjectActions.length > 0) {
            workspaceSelectionPopupMenu.addSeparator();
            for (MJAbstractAction mJAbstractAction : this.fObjectActions) {
                if (mJAbstractAction.getName().equals("-")) {
                    workspaceSelectionPopupMenu.addSeparator();
                    continue;
                }
                workspaceSelectionPopupMenu.add((Action)mJAbstractAction);
            }
        }
        workspaceSelectionPopupMenu.pack();
    }

    protected void processPossiblePopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            int[] nArray = this.getSelectedRowsChron();
            this.refreshObjectSpecificPopup(this.getVariableNames(nArray));
        }
        super.processPossiblePopup(mouseEvent);
    }

    public void setDefaultAction(MJAbstractAction mJAbstractAction) {
        super.setDefaultAction(mJAbstractAction);
        WorkspaceSelectionPopupMenu workspaceSelectionPopupMenu = new WorkspaceSelectionPopupMenu(this);
        workspaceSelectionPopupMenu.addSeparator();
        this.setSelectionPopupMenu(workspaceSelectionPopupMenu);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        int[] nArray = this.getSelectedRowsChron();
        this.fObjectActions = MatlabClassActionFactory.getClassActions(this.getVariableNames(nArray), this.getVariableClasses(nArray));
        if (this.fGraphicListener != null) {
            for (ListSelectionListener listSelectionListener : this.fGraphicListener) {
                listSelectionListener.valueChanged(listSelectionEvent);
            }
        }
    }

    @Override
    public void graphingActionsChanged() {
        int[] nArray = this.getSelectedRowsChron();
        this.refreshObjectSpecificPopup(this.getVariableNames(nArray));
        for (ListSelectionListener listSelectionListener : this.fGraphicListener) {
            listSelectionListener.valueChanged(new ListSelectionEvent(this, 0, this.getRowCount() - 1, false));
        }
    }

    public MJAbstractAction getAction(int n) {
        MJAbstractAction mJAbstractAction = super.getAction(n);
        if (mJAbstractAction == null) {
            switch (n) {
                case 100: {
                    mJAbstractAction = this.fSaveAsAction;
                    break;
                }
                case 200: {
                    mJAbstractAction = this.fImportClipboardAction;
                    break;
                }
                case 110: {
                    mJAbstractAction = this.fImportFileAction;
                    break;
                }
                case 120: {
                    mJAbstractAction = this.fSaveWorkspaceAction;
                    break;
                }
                case 130: {
                    mJAbstractAction = this.fPageSetupAction;
                    break;
                }
                case 140: {
                    mJAbstractAction = this.fPrintAction;
                }
            }
        }
        return mJAbstractAction;
    }

    public final DropTargetListener getDropTargetListener() {
        return this.fDropTargetListener;
    }

    public final String[] getVariableNames(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.getModel().getValueAt(nArray[i], this.getPrimaryFieldIndex());
        }
        if (stringArray.length > 0 && stringArray[0] == null) {
            return ArrayUtils.EmptyObjects.STRING;
        }
        return stringArray;
    }

    public final int[] getIndicies(String[] stringArray) {
        int n = this.getPrimaryFieldIndex();
        int[] nArray = new int[stringArray.length];
        TableModel tableModel = this.getModel();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = -1;
            for (int j = 0; j < tableModel.getRowCount(); ++j) {
                if (!stringArray[i].equals(tableModel.getValueAt(j, n))) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    MJAbstractAction[] getAdditionalOpeningActions() {
        return new MJAbstractAction[0];
    }

    private void createWorkspaceActions() {
        WorkspaceTableActionProvider workspaceTableActionProvider = new WorkspaceTableActionProvider();
        this.fSaveAsAction = new ActionUtils.SaveAsAction(workspaceTableActionProvider);
        this.fImportClipboardAction = new ActionUtils.ImportClipboardAction(workspaceTableActionProvider);
        this.fImportFileAction = new ActionUtils.ImportFileAction(workspaceTableActionProvider);
        this.fSaveWorkspaceAction = new SaveWorkspaceAction(workspaceTableActionProvider);
        this.fPrintAction = new ActionUtils.BaseAction("print", "Print", workspaceTableActionProvider){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkspacePrinter.print(WorkspaceTable.this);
            }
        };
        this.fPageSetupAction = new ActionUtils.BaseAction("show-page-setup", "PageSetup", workspaceTableActionProvider){

            public void actionPerformed(ActionEvent actionEvent) {
                WorkspacePrinter.pageSetup();
            }
        };
        this.fCatalogAction = new ActionUtils.MorePlotsAction(workspaceTableActionProvider);
    }

    public final String[] getVariableDims(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.getModel().getValueAt(nArray[i], 2);
        }
        return stringArray;
    }

    public final String[] getVariableClasses(int[] nArray) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = (String)this.getModel().getValueAt(nArray[i], 4);
        }
        return stringArray;
    }

    @Override
    public String[] getGraphableNames() {
        return this.getVariableNames(this.getSelectedRowsChron());
    }

    @Override
    public String[] getGraphableClasses() {
        return this.getVariableClasses(this.getSelectedRowsChron());
    }

    @Override
    public String[] getGraphableSizes() {
        return this.getVariableDims(this.getSelectedRowsChron());
    }

    public MJAbstractAction getMorePlotsAction() {
        return this.fCatalogAction;
    }

    public MJAbstractAction getPlotPickerAction() {
        return this.fPlotPickerAction;
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.add(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.remove(listSelectionListener);
    }

    public void refresh() {
        MatlabWorkspaceListener.startWhosQuery();
    }

    public void setFormat(FormatIdentifier formatIdentifier) {
        this.setValueColumnRenderer(new ItTableCellRenderer(formatIdentifier));
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n == -1 || n2 == -1) {
            Log.log((String)"Invalid row or column in WorkspaceTable.getToolTipText");
            return string;
        }
        boolean bl = this.getColumnName(n2).equals(WorkspaceResources.getBundle().getString("fieldname.name"));
        boolean bl2 = this.getColumnName(n2).equals(WorkspaceResources.getBundle().getString("fieldname.value"));
        if (bl || bl2) {
            int[] nArray = new int[]{n};
            String[] stringArray = this.getVariableClasses(nArray);
            String[] stringArray2 = this.getVariableDims(nArray);
            string = stringArray2[0] + " " + stringArray[0];
        }
        return string;
    }

    private class WorkspaceTableActionProvider
    implements ActionUtils.ActionProvider {
        private WorkspaceTableActionProvider() {
        }

        @Override
        public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
            WorkspaceTable.this.registerWithInputAndActionMaps(mJAbstractAction);
        }

        @Override
        public JTable getTable() {
            return WorkspaceTable.this;
        }

        @Override
        public String[] getVariableNamesForSelectedRows() {
            return WorkspaceTable.this.getVariableNames(WorkspaceTable.this.getSelectedRowsChron());
        }
    }

    private class ItTableCellRenderer
    extends DefaultTableCellRenderer {
        private Formatter iFormatter;

        ItTableCellRenderer(FormatIdentifier formatIdentifier) {
            this.iFormatter = formatIdentifier.getFormatter();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2 = null;
            object2 = object instanceof IReadOnlyData && ((IReadOnlyData)object).isReadOnly() ? object : this.iFormatter.format(object);
            Component component = WorkspaceTable.this.getDefaultRenderer(Object.class).getTableCellRendererComponent(jTable, object2, bl, bl2, n, n2);
            if (object instanceof IReadOnlyData && ((IReadOnlyData)object).isReadOnly()) {
                Font font = component.getFont();
                if (!font.isBold()) {
                    component.setFont(font.deriveFont(2));
                } else {
                    component.setFont(font.deriveFont(3));
                }
            }
            return component;
        }
    }

    private class SaveWorkspaceAction
    extends ActionUtils.BaseAction
    implements TableModelListener {
        SaveWorkspaceAction(ActionUtils.InputMapActionProvider inputMapActionProvider) {
            super("save-workspace", "WorkspaceSaveWorkspace", inputMapActionProvider);
            this.setName(WorkspaceResources.getSaveWorkspaceLabel());
            WorkspaceTable.this.getModel().addTableModelListener(this);
            this.tableChanged(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.saveAllVariables(ActionUtils.getContainingFrame((JComponent)((Object)WorkspaceTable.this)));
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.setEnabled(WorkspaceTable.this.getRowCount() != 0);
        }
    }
}

