/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.mlwidgets.workspace.WorkspaceCommands;

public abstract class WorkspaceChange {
    private static final WorkspaceChange ADD = new WorkspaceChangeAdd();
    private static final WorkspaceChange ARRAY_ALL = new WorkspaceChangeArrayAll();
    private static final WorkspaceChange ARRAY_CHANGE = new WorkspaceChangeArrayChange();
    private static final WorkspaceChange CLEAR = new WorkspaceChangeClear();
    private static final WorkspaceChange DELETE = new WorkspaceChangeDelete();
    private static final WorkspaceChange SCOPE = new WorkspaceChangeScope();
    private boolean fIsTrigger = true;

    static WorkspaceChange getInstance(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (!(!bl || bl2 || bl3 || bl4 || bl5 || bl6)) {
            return ADD;
        }
        if (!(bl || !bl2 || bl3 || bl4 || bl5 || bl6)) {
            return ARRAY_ALL;
        }
        if (!(bl || bl2 || !bl3 || bl4 || bl5 || bl6)) {
            return ARRAY_CHANGE;
        }
        if (!(bl || bl2 || bl3 || !bl4 || bl5 || bl6)) {
            return CLEAR;
        }
        if (!(bl || bl2 || bl3 || bl4 || !bl5 || bl6)) {
            return DELETE;
        }
        if (!(bl || bl2 || bl3 || bl4 || bl5 || !bl6)) {
            return SCOPE;
        }
        return new WorkspaceChangeMulti(bl, bl2, bl3, bl4, bl5, bl6);
    }

    static WorkspaceChange getArrayAllInstance() {
        return ARRAY_ALL;
    }

    public void setUndoTrigger(boolean bl) {
        this.fIsTrigger = bl;
    }

    public boolean isUndoTrigger() {
        return this.fIsTrigger && (this.isArrayAllEvent() || this.isArrayChangeEvent());
    }

    private WorkspaceChange() {
    }

    public abstract boolean isAddEvent();

    public abstract boolean isClearEvent();

    public abstract boolean isDeleteEvent();

    public abstract boolean isArrayAllEvent();

    public abstract boolean isArrayChangeEvent();

    public abstract boolean isScopeEvent();

    public abstract int summarizeAsInt();

    protected abstract String getEventName();

    public String toString() {
        return "WorkspaceChange: " + this.getEventName();
    }

    public WorkspaceChange merge(WorkspaceChange workspaceChange) {
        if (workspaceChange == null || workspaceChange == this) {
            return this;
        }
        return new WorkspaceChangeMulti(workspaceChange.isAddEvent() || this.isAddEvent(), workspaceChange.isArrayAllEvent() || this.isArrayAllEvent(), workspaceChange.isArrayChangeEvent() || this.isArrayChangeEvent(), workspaceChange.isClearEvent() || this.isClearEvent(), workspaceChange.isDeleteEvent() || this.isDeleteEvent(), workspaceChange.isScopeEvent() || this.isScopeEvent());
    }

    private static class WorkspaceChangeScope
    extends WorkspaceChangeSingle {
        private WorkspaceChangeScope() {
        }

        @Override
        public boolean isAddEvent() {
            return false;
        }

        @Override
        public boolean isArrayAllEvent() {
            return false;
        }

        @Override
        public boolean isArrayChangeEvent() {
            return false;
        }

        @Override
        public boolean isClearEvent() {
            return false;
        }

        @Override
        public boolean isDeleteEvent() {
            return false;
        }

        @Override
        public boolean isScopeEvent() {
            return true;
        }

        @Override
        public int summarizeAsInt() {
            return Integer.MIN_VALUE;
        }
    }

    private static class WorkspaceChangeDelete
    extends WorkspaceChangeSingle {
        private WorkspaceChangeDelete() {
        }

        @Override
        public boolean isAddEvent() {
            return false;
        }

        @Override
        public boolean isArrayAllEvent() {
            return false;
        }

        @Override
        public boolean isArrayChangeEvent() {
            return false;
        }

        @Override
        public boolean isClearEvent() {
            return false;
        }

        @Override
        public boolean isDeleteEvent() {
            return true;
        }

        @Override
        public boolean isScopeEvent() {
            return false;
        }

        @Override
        public int summarizeAsInt() {
            return 0x10000000;
        }
    }

    private static class WorkspaceChangeClear
    extends WorkspaceChangeSingle {
        private WorkspaceChangeClear() {
        }

        @Override
        public boolean isAddEvent() {
            return false;
        }

        @Override
        public boolean isArrayAllEvent() {
            return false;
        }

        @Override
        public boolean isArrayChangeEvent() {
            return false;
        }

        @Override
        public boolean isClearEvent() {
            return true;
        }

        @Override
        public boolean isDeleteEvent() {
            return false;
        }

        @Override
        public boolean isScopeEvent() {
            return false;
        }

        @Override
        public int summarizeAsInt() {
            return 0x20000000;
        }
    }

    private static class WorkspaceChangeArrayChange
    extends WorkspaceChangeSingle {
        private WorkspaceChangeArrayChange() {
        }

        @Override
        public boolean isAddEvent() {
            return false;
        }

        @Override
        public boolean isArrayAllEvent() {
            return false;
        }

        @Override
        public boolean isArrayChangeEvent() {
            return true;
        }

        @Override
        public boolean isClearEvent() {
            return false;
        }

        @Override
        public boolean isDeleteEvent() {
            return false;
        }

        @Override
        public boolean isScopeEvent() {
            return false;
        }

        @Override
        public int summarizeAsInt() {
            return 0x8000000;
        }
    }

    private static class WorkspaceChangeArrayAll
    extends WorkspaceChangeSingle {
        private WorkspaceChangeArrayAll() {
        }

        @Override
        public boolean isAddEvent() {
            return false;
        }

        @Override
        public boolean isArrayAllEvent() {
            return true;
        }

        @Override
        public boolean isArrayChangeEvent() {
            return false;
        }

        @Override
        public boolean isClearEvent() {
            return false;
        }

        @Override
        public boolean isDeleteEvent() {
            return false;
        }

        @Override
        public boolean isScopeEvent() {
            return false;
        }

        @Override
        public int summarizeAsInt() {
            return 1;
        }
    }

    private static class WorkspaceChangeAdd
    extends WorkspaceChangeSingle {
        private WorkspaceChangeAdd() {
        }

        @Override
        public boolean isAddEvent() {
            return true;
        }

        @Override
        public boolean isArrayAllEvent() {
            return false;
        }

        @Override
        public boolean isArrayChangeEvent() {
            return false;
        }

        @Override
        public boolean isClearEvent() {
            return false;
        }

        @Override
        public boolean isDeleteEvent() {
            return false;
        }

        @Override
        public boolean isScopeEvent() {
            return false;
        }

        @Override
        public int summarizeAsInt() {
            return 0x40000000;
        }
    }

    private static abstract class WorkspaceChangeSingle
    extends WorkspaceChange {
        private WorkspaceChangeSingle() {
        }

        @Override
        protected String getEventName() {
            return WorkspaceCommands.getEventNameFromCode(this.summarizeAsInt());
        }
    }

    private static class WorkspaceChangeMulti
    extends WorkspaceChange {
        private boolean fAdd;
        private boolean fArrayAll;
        private boolean fArrayChange;
        private boolean fClear;
        private boolean fDelete;
        private boolean fScope;

        private WorkspaceChangeMulti(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
            this.fScope = bl6;
            this.fAdd = bl;
            this.fClear = bl4;
            this.fDelete = bl5;
            this.fArrayChange = bl3;
            this.fArrayAll = bl2;
        }

        @Override
        public boolean isAddEvent() {
            return this.fAdd;
        }

        @Override
        public boolean isClearEvent() {
            return this.fClear;
        }

        @Override
        public boolean isDeleteEvent() {
            return this.fDelete;
        }

        @Override
        public boolean isArrayAllEvent() {
            return this.fArrayAll;
        }

        @Override
        public boolean isArrayChangeEvent() {
            return this.fArrayChange;
        }

        @Override
        public boolean isScopeEvent() {
            return this.fScope;
        }

        @Override
        public int summarizeAsInt() {
            return 1;
        }

        @Override
        protected String getEventName() {
            StringBuilder stringBuilder = new StringBuilder("");
            if (this.fAdd) {
                stringBuilder.append(WorkspaceCommands.getEventNameFromCode(0x40000000)).append(' ');
            }
            if (this.fArrayAll) {
                stringBuilder.append(WorkspaceCommands.getEventNameFromCode(1)).append(' ');
            }
            if (this.fArrayChange) {
                stringBuilder.append(WorkspaceCommands.getEventNameFromCode(0x8000000)).append(' ');
            }
            if (this.fClear) {
                stringBuilder.append(WorkspaceCommands.getEventNameFromCode(0x20000000)).append(' ');
            }
            if (this.fDelete) {
                stringBuilder.append(WorkspaceCommands.getEventNameFromCode(0x10000000)).append(' ');
            }
            if (this.fScope) {
                stringBuilder.append(WorkspaceCommands.getEventNameFromCode(Integer.MIN_VALUE)).append(' ');
            }
            return stringBuilder.toString();
        }
    }
}

