/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.common.icons.ApplicationIcon;
import com.mathworks.common.icons.VariableIcon;
import com.mathworks.mlwidgets.graphics.PlotCatalog;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mlwidgets.workspace.WorkspaceResources;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.action.AbstractPasteAction;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActionUtils {
    private ActionUtils() {
    }

    public static Frame getContainingFrame(JComponent jComponent) {
        Container container = jComponent.getTopLevelAncestor();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return null;
    }

    public static void changePreexistingActions(MJAbstractAction mJAbstractAction, MJAbstractAction mJAbstractAction2, MJAbstractAction mJAbstractAction3) {
        if (mJAbstractAction != null) {
            mJAbstractAction.setTip(WorkspaceResources.getBundle().getString("tip.newVariable"));
            mJAbstractAction.setButtonOnlyIcon((Icon)VariableIcon.NEW.getIcon());
        }
        if (mJAbstractAction2 != null) {
            mJAbstractAction2.setButtonOnlyIcon((Icon)ApplicationIcon.VARIABLE_EDITOR_16x16.getIcon());
        }
        if (mJAbstractAction3 != null) {
            mJAbstractAction3.setButtonOnlyIcon((Icon)VariableIcon.DELETE.getIcon());
        }
    }

    static abstract class BaseAction
    extends MJAbstractAction {
        BaseAction(String string, String string2, InputMapActionProvider inputMapActionProvider) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("WorkspaceBrowser", string, (ExtendedAction)this);
            this.setComponentName(string2);
            inputMapActionProvider.registerWithInputAndActionMaps(this);
        }
    }

    public static interface InputMapActionProvider {
        public void registerWithInputAndActionMaps(MJAbstractAction var1);
    }

    public static interface ActionProvider
    extends InputMapActionProvider {
        public JTable getTable();

        public String[] getVariableNamesForSelectedRows();
    }

    public static class MorePlotsAction
    extends BaseAction {
        private final ActionProvider fProvider;
        private PlotCatalog fMorePlotsDlg;

        public MorePlotsAction(ActionProvider actionProvider) {
            super("show-plot-catalog", "show-plot-catalog", actionProvider);
            this.fProvider = actionProvider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.fMorePlotsDlg == null) {
                this.fMorePlotsDlg = PlotCatalog.getInstance();
            }
            this.fMorePlotsDlg.setPlottedVars(this.fProvider.getVariableNamesForSelectedRows());
            this.fMorePlotsDlg.show();
        }
    }

    public static class ImportFileAction
    extends BaseAction {
        private final ActionProvider fProvider;

        public ImportFileAction(ActionProvider actionProvider) {
            super("import-data", "WorkspaceImportFile", actionProvider);
            this.fProvider = actionProvider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WorkspaceCommands.importDataWithDialog((Action)((Object)this));
        }
    }

    public static class ImportClipboardAction
    extends AbstractPasteAction {
        public ImportClipboardAction(ActionProvider actionProvider) {
            this.clearKeyBinding();
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("WorkspaceBrowser", "paste-to-workspace", (ExtendedAction)this);
            this.setName(WorkspaceResources.getBundle().getString("Action.paste-to-workspace.Label"));
            this.setComponentName("WorkspaceImportClipboard");
            actionProvider.registerWithInputAndActionMaps((MJAbstractAction)this);
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(MLDataFlavor.serializedVariableListFlavor)) {
                WorkspaceCommands.pasteDataFromClipboard();
            } else {
                WorkspaceCommands.importDataFromClipboard();
            }
        }
    }

    public static class SaveAsAction
    extends BaseAction
    implements ListSelectionListener {
        private ActionProvider fProvider;

        public SaveAsAction(ActionProvider actionProvider) {
            super("save-as", "WorkspaceSaveAs", actionProvider);
            this.fProvider = actionProvider;
            this.fProvider.getTable().getSelectionModel().addListSelectionListener(this);
            this.valueChanged(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String[] stringArray = this.fProvider.getVariableNamesForSelectedRows();
            WorkspaceCommands.saveVariables(stringArray, ActionUtils.getContainingFrame(this.fProvider.getTable()));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(this.fProvider.getTable().getSelectionModel().getMinSelectionIndex() != -1);
        }
    }
}

