/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.text.mcode;

import com.mathworks.html.HtmlSourceReader;
import com.mathworks.matlab.api.editor.EditorTipDocHelper;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.widgets.text.mcode.MLint;
import java.io.File;

public class MatlabDocUtils {
    private static final String PRODUCT = "matlab";
    private static final String DOC_MAP = "matlab_mlint_csh";
    private static final String MLINT_TAG_PREFIX = "mlint_";
    private static final CodeAnalyzerDocHelper CODE_ANALYZER_DOC_HELPER = new CodeAnalyzerDocHelper();
    private static final NonLocalDocHelper NONLOCAL_VAR_DOC_HELPER = new NonLocalDocHelper();

    private MatlabDocUtils() {
    }

    static EditorTipDocHelper getCodeAnalyzerDocHelper() {
        return CODE_ANALYZER_DOC_HELPER;
    }

    static EditorTipDocHelper getNonlocalVariableDocHelper() {
        return NONLOCAL_VAR_DOC_HELPER;
    }

    public static String getDocURL(MLint.MessageDefinition messageDefinition) {
        return MatlabDocUtils.getDocURL(messageDefinition.getTag());
    }

    private static String getDocURL(String string) {
        String string2 = MatlabDocUtils.getMapID(string);
        if (string2 == null) {
            throw new IllegalStateException("Null topic map, should not ask for extend help if no help available.");
        }
        string2 = HelpPrefs.replacePathWithInstalledDocPath(string2);
        return string2;
    }

    private static String getExtendedHelpForId(String string) {
        String string2 = MatlabDocUtils.getDocURL(string);
        if (string2 == null) {
            throw new IllegalStateException("Null path, but valid map");
        }
        String string3 = HtmlSourceReader.getSource((String)string2);
        if (string3 == null) {
            throw new IllegalStateException("Null source html, but valid map");
        }
        return string3;
    }

    private static boolean idHasExtendedHelp(String string) {
        return MatlabDocUtils.getMapID(string) != null;
    }

    private static String getMapID(String string) {
        if (MatlabDocUtils.getTopicMap() == null) {
            return null;
        }
        return MatlabDocUtils.getTopicMap().mapID(string);
    }

    private static String getExtendedHelpForMLintTag(String string) {
        return MatlabDocUtils.getExtendedHelpForId(MatlabDocUtils.makeIdForMLintTag(string));
    }

    private static boolean mlintTagHasExtendedHelp(String string) {
        return MatlabDocUtils.idHasExtendedHelp(MatlabDocUtils.makeIdForMLintTag(string));
    }

    private static String makeIdForMLintTag(String string) {
        return (MLINT_TAG_PREFIX + string).toLowerCase();
    }

    public static boolean hasExtendedHelp(MLint.MessageDefinition messageDefinition) {
        return MatlabDocUtils.mlintTagHasExtendedHelp(messageDefinition.getTag());
    }

    public static String getExtendedHelp(MLint.MessageDefinition messageDefinition) {
        return MatlabDocUtils.getExtendedHelpForMLintTag(messageDefinition.getTag());
    }

    private static CSHelpTopicMap getTopicMap() {
        CSHelpTopicMap cSHelpTopicMap = null;
        String string = MLHelpServices.getMapfileName((String)PRODUCT, (String)DOC_MAP);
        if (string != null && new File(string).exists()) {
            cSHelpTopicMap = new CSHelpTopicMap(string);
        }
        return cSHelpTopicMap;
    }

    private static class NonLocalDocHelper
    implements EditorTipDocHelper {
        private NonLocalDocHelper() {
        }

        public boolean hasExtendedHelp(String string) {
            return MatlabDocUtils.idHasExtendedHelp(string);
        }

        public String getExtendedHelp(String string) {
            return MatlabDocUtils.getExtendedHelpForId(string);
        }
    }

    private static class CodeAnalyzerDocHelper
    implements EditorTipDocHelper {
        private CodeAnalyzerDocHelper() {
        }

        public boolean hasExtendedHelp(String string) {
            return MatlabDocUtils.mlintTagHasExtendedHelp(string);
        }

        public String getExtendedHelp(String string) {
            return MatlabDocUtils.getExtendedHelpForMLintTag(string);
        }
    }
}

