/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.text.mcode;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLLicenseChecker;
import com.mathworks.mlwidgets.text.mcode.MLintTableRow;
import com.mathworks.mlwidgets.text.mcode.MatlabDocUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.BusyAffordance;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

public final class MLintPrefsHelper {
    private static final Collator COLLATOR = Collator.getInstance();
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.text.mcode.resources.RES_mcode");
    private static final Comparator<MLint.Category> CATEGORY_COMPARATOR = new Comparator<MLint.Category>(){

        @Override
        public int compare(MLint.Category category, MLint.Category category2) {
            return COLLATOR.compare(category.getName(), category2.getName());
        }
    };
    private MLintConfiguration fConfig;
    private String fOriginalConfigString;
    private boolean fDefaultsModified;
    private Map<String, String> fCategoryTagToName;
    private final EventList<MLintTableRow> fMessageList = new BasicEventList();
    private final MLintMessageDefinitions fDefinitions;
    private final List<MessagesUpdatedListener> fMessageListeners = new Vector<MessagesUpdatedListener>();
    private BusyAffordance fBusyAffordance;

    private Boolean isEnabled(MLint.MessageDefinition messageDefinition) {
        return this.getConfiguration().isEnabled(messageDefinition.getTag(), CodeAnalyzerUtils.defaultSelectionValue((MLint.MessageDefinition)messageDefinition));
    }

    private static String getExtendedHelp(MLint.MessageDefinition messageDefinition) {
        String string = "";
        if (MatlabDocUtils.hasExtendedHelp(messageDefinition)) {
            string = MatlabDocUtils.getExtendedHelp(messageDefinition);
            assert (string != null) : "MLint Pref panel looking for extended help that is not there.";
        }
        return string;
    }

    private boolean isChangedFromDefault(MLint.MessageDefinition messageDefinition) {
        return CodeAnalyzerUtils.defaultSelectionValue((MLint.MessageDefinition)messageDefinition) != this.isEnabled(messageDefinition);
    }

    String getCategoryName(MLint.MessageDefinition messageDefinition) {
        return this.getCategories().get(messageDefinition.getCategoryTag());
    }

    String getCategoryName(MLintTableRow mLintTableRow) {
        return this.getCategories().get(mLintTableRow.getCategoryTag());
    }

    boolean isCategoryEnabled(MLintTableRow mLintTableRow) {
        boolean bl = MLintPrefsUtils.isEnabledByDefault((String)mLintTableRow.getCategoryTag());
        return this.fConfig.isCategoryEnabled(mLintTableRow.getCategoryTag(), bl);
    }

    void setCategoryEnabled(MLintTableRow mLintTableRow, boolean bl) {
        this.fConfig.setCategoryEnabled(mLintTableRow.getCategoryTag(), bl, MLintPrefsUtils.isEnabledByDefault((String)mLintTableRow.getCategoryTag()));
    }

    private Map<String, String> getCategories() {
        if (this.fCategoryTagToName == null) {
            this.fCategoryTagToName = new Hashtable<String, String>(this.fDefinitions.getCategories().size());
            for (MLint.Category category : this.fDefinitions.getCategories()) {
                this.fCategoryTagToName.put(category.getTag(), category.getName());
            }
        }
        return Collections.unmodifiableMap(this.fCategoryTagToName);
    }

    private void checkForCompilerLicense() {
        if (Matlab.isMatlabAvailable()) {
            new MatlabWorker(){

                public Object runOnMatlabThread() throws Exception {
                    Boolean bl = Matlab.isMatlabAvailable() && MLLicenseChecker.hasLicense((String)"Compiler");
                    return bl != null && bl != false;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    boolean bl = (Boolean)object;
                    if (!bl) {
                        MLintPrefsHelper.this.removeDeploymentMessages();
                    }
                }
            }.start();
        }
    }

    public MLintPrefsHelper() {
        this(new RealMLintMessageDefinitions());
    }

    public MLintPrefsHelper(MLintMessageDefinitions mLintMessageDefinitions) {
        if (mLintMessageDefinitions == null) {
            throw new IllegalArgumentException("'definitions' cannot be null");
        }
        this.fDefinitions = mLintMessageDefinitions;
        this.fMessageList.addListEventListener((ListEventListener)new ListEventListener<MLintTableRow>(){

            public void listChanged(ListEvent<MLintTableRow> listEvent) {
                if (listEvent.hasNext() && listEvent.next() && listEvent.getType() != 1) {
                    MLintPrefsHelper.this.fireMessagesUpdated();
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                Vector<RealMLintDefinitionRow> vector = new Vector<RealMLintDefinitionRow>();
                double d = 0.0;
                int n = MLintPrefsHelper.this.fDefinitions.getMessageDefinitions().size();
                for (MLint.MessageDefinition messageDefinition : MLintPrefsHelper.this.fDefinitions.getMessageDefinitions()) {
                    if (MLintPrefsHelper.this.fBusyAffordance != null) {
                        MLintPrefsHelper.this.fBusyAffordance.setBusyText(MessageFormat.format(BUNDLE.getString("mlint.loadingMessages"), Math.round((d += 1.0) / (double)n * 100.0)));
                    }
                    vector.add(new RealMLintDefinitionRow(messageDefinition));
                }
                MLintPrefsHelper.this.fMessageList.getReadWriteLock().writeLock().lock();
                MLintPrefsHelper.this.fMessageList.addAll(vector);
                MLintPrefsHelper.this.fMessageList.getReadWriteLock().writeLock().unlock();
            }
        }, "MLintLoaderThread").start();
        this.fConfig = MLintPrefsUtils.getActiveConfiguration().copy();
        this.resetConfigurationString();
        this.checkForCompilerLicense();
    }

    public void restoreDefaults() {
        this.fConfig = MLintConfiguration.createEmpty((File)MLintPrefsUtils.DEFAULT_SETTINGS_FILE);
        this.fDefaultsModified = false;
    }

    public boolean areDefaultsChanged() {
        return this.fDefaultsModified || MLintPrefsUtils.DEFAULT_SETTINGS_FILE.equals(this.fConfig.getFile()) && !this.fConfig.isEmpty();
    }

    public void commitDefault() throws IOException {
        this.commitFile(MLintPrefsUtils.DEFAULT_SETTINGS_FILE);
    }

    public void commitFile(File file) throws IOException {
        assert (file != null);
        if (this.isModified()) {
            this.doSaveAs(file);
        }
        MLintPrefsUtils.useConfiguration((File)file);
        this.resetConfigurationString();
    }

    public boolean isModified() {
        return !this.fConfig.getMessagesAsString().equals(this.fOriginalConfigString);
    }

    public MLintConfiguration getConfiguration() {
        return this.fConfig;
    }

    public void setConfiguration(MLintConfiguration mLintConfiguration) {
        if (mLintConfiguration == null) {
            throw new IllegalArgumentException("'config' cannot be null");
        }
        this.fConfig = mLintConfiguration;
        this.resetConfigurationString();
    }

    public EventList<MLintTableRow> getMessageDefinitions() {
        return this.fMessageList;
    }

    private void removeDeploymentMessages() {
        Vector<MLintTableRow> vector = new Vector<MLintTableRow>();
        for (MLintTableRow mLintTableRow : this.fMessageList) {
            if (!mLintTableRow.getCategoryTag().equals("MCC")) continue;
            vector.add(mLintTableRow);
        }
        this.fMessageList.removeAll(vector);
    }

    void doSave() throws IOException {
        this.doSaveAs(this.fConfig.getFile());
    }

    void doSaveAs(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("'file' cannot be null");
        }
        this.fConfig.saveTo(file);
    }

    private void resetConfigurationString() {
        this.fOriginalConfigString = this.fConfig.getMessagesAsString();
        this.computeDefaultSettingsModifiedFlag();
    }

    private void computeDefaultSettingsModifiedFlag() {
        try {
            MLintPrefsUtils.ensureDefaultSettingsFileExists();
            MLintConfiguration mLintConfiguration = MLintConfiguration.read((File)MLintPrefsUtils.DEFAULT_SETTINGS_FILE, (boolean)true);
            this.fDefaultsModified = !mLintConfiguration.isEmpty();
        }
        catch (IOException iOException) {
            Log.logException((Exception)iOException);
        }
        catch (MLintConfiguration.FormatException formatException) {
            Log.logException((Exception)((Object)formatException));
        }
    }

    List<MLint.Category> getCategoryList() {
        ArrayList<MLint.Category> arrayList = new ArrayList<MLint.Category>(this.fDefinitions.getCategories());
        Collections.sort(arrayList, CATEGORY_COMPARATOR);
        return arrayList;
    }

    static Comparator<MLintTableRow> getMessageComparator() {
        return new Comparator<MLintTableRow>(){

            @Override
            public int compare(MLintTableRow mLintTableRow, MLintTableRow mLintTableRow2) {
                return COLLATOR.compare(mLintTableRow.getMessage(), mLintTableRow2.getMessage());
            }
        };
    }

    public void addMessagesUpdatedListeners(MessagesUpdatedListener messagesUpdatedListener) {
        this.fMessageList.getReadWriteLock().writeLock().lock();
        if (!this.fMessageList.isEmpty()) {
            messagesUpdatedListener.messagesUpdated();
        }
        this.fMessageList.getReadWriteLock().writeLock().unlock();
        this.fMessageListeners.add(messagesUpdatedListener);
    }

    public void removeMessageUpdatedListeners(MessagesUpdatedListener messagesUpdatedListener) {
        this.fMessageListeners.remove(messagesUpdatedListener);
    }

    private void fireMessagesUpdated() {
        for (MessagesUpdatedListener messagesUpdatedListener : this.fMessageListeners) {
            messagesUpdatedListener.messagesUpdated();
        }
    }

    void setBusyAffordance(BusyAffordance busyAffordance) {
        this.fBusyAffordance = busyAffordance;
    }

    static ResourceBundle getBundle() {
        return BUNDLE;
    }

    private class RealMLintDefinitionRow
    implements MLintTableRow {
        private final MLint.MessageDefinition iDefinition;
        private final String iHelp;

        private RealMLintDefinitionRow(MLint.MessageDefinition messageDefinition) {
            this.iDefinition = messageDefinition;
            this.iHelp = MatlabDocUtils.hasExtendedHelp(this.iDefinition) ? MLintPrefsHelper.getExtendedHelp(this.iDefinition) : null;
        }

        @Override
        public String getCategoryTag() {
            return this.iDefinition.getCategoryTag();
        }

        @Override
        public Boolean isEnabled() {
            return MLintPrefsHelper.this.fConfig.isEnabled(this.iDefinition.getTag(), CodeAnalyzerUtils.defaultSelectionValue((MLint.MessageDefinition)this.iDefinition));
        }

        @Override
        public Integer getSeverity() {
            return this.iDefinition.getSeverity();
        }

        @Override
        public String getMessage() {
            return this.iDefinition.getMessage();
        }

        @Override
        public Boolean hasExtendedHelp() {
            return this.iHelp != null;
        }

        @Override
        public String getCategoryName() {
            return MLintPrefsHelper.this.getCategoryName(this.iDefinition);
        }

        @Override
        public Boolean isChangedFromDefault() {
            return MLintPrefsHelper.this.isChangedFromDefault(this.iDefinition);
        }

        @Override
        public String getExtendedHelp() {
            return this.iHelp;
        }

        @Override
        public String getTag() {
            return this.iDefinition.getTag();
        }

        @Override
        public void setEnabled(boolean bl) {
            if (bl) {
                MLintPrefsHelper.this.getConfiguration().enableMessage(this.getTag(), this.getSeverity().intValue(), CodeAnalyzerUtils.defaultSelectionValue((MLint.MessageDefinition)this.iDefinition));
            } else {
                MLintPrefsHelper.this.getConfiguration().disableMessage(this.getTag(), CodeAnalyzerUtils.defaultSelectionValue((MLint.MessageDefinition)this.iDefinition));
            }
        }

        @Override
        public String getURL() {
            return MatlabDocUtils.getDocURL(this.iDefinition);
        }

        @Override
        public boolean isCategory() {
            return false;
        }
    }

    private static class RealMLintMessageDefinitions
    implements MLintMessageDefinitions {
        private RealMLintMessageDefinitions() {
        }

        @Override
        public List<MLint.Category> getCategories() {
            return MLint.getCategories();
        }

        @Override
        public List<MLint.MessageDefinition> getMessageDefinitions() {
            return MLint.getMessageDefinitions();
        }
    }

    public static interface MLintMessageDefinitions {
        public List<MLint.Category> getCategories();

        public List<MLint.MessageDefinition> getMessageDefinitions();
    }

    public static interface MessagesUpdatedListener {
        public void messagesUpdated();
    }
}

