/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.tex;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public final class TexDraw {
    private byte[] fDVI = null;
    private int fXOffset = 0;
    private int fYOffset = 0;
    private int fMag = 1;
    private int fWidth = 0;
    private int fHeight = 0;
    private boolean fSmoothFont = true;
    private boolean fIsDebug = false;
    private double fPixelsPerPt;
    private final int[] fStack = new int[1024];
    private final Font[] fFont = new Font[64];
    private Component fComponent = null;
    private static boolean sDoLoadFonts = true;
    private static Hashtable sFontTable = new Hashtable();
    private static final String FONTDIR = "/sys/fonts/ttf/cm";
    private static final String FONTEXT = ".ttf";

    public TexDraw(Component component) {
        this.fComponent = component;
        if (sDoLoadFonts) {
            this.loadFonts();
            sDoLoadFonts = false;
        }
    }

    public void setDebug(boolean bl) {
        this.fIsDebug = bl;
    }

    public void requestFontSmoothing(boolean bl) {
        this.fSmoothFont = bl;
    }

    public void setFontSize(int n) {
        this.fMag = (int)((double)n / 10.0);
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeight;
    }

    public void setDVI(byte[] byArray) {
        this.fDVI = byArray;
    }

    public byte[] getDVI() {
        return this.fDVI;
    }

    public void setXOffset(int n) {
        this.fXOffset = n;
    }

    public void setYOffset(int n) {
        this.fYOffset = n;
    }

    public void drawEventThread(Graphics graphics) {
        this.drawDVIEventThread(graphics, false);
    }

    public String setTexStringMatlabThread(String string) {
        assert (NativeMatlab.nativeIsMatlabThread());
        Object object = null;
        try {
            Object object2;
            Object object3 = Matlab.mtFeval((String)"tex", (Object[])new Object[]{string}, (int)2);
            Object[] objectArray = (Object[])object3;
            if (objectArray[0] instanceof byte[]) {
                object2 = (byte[])objectArray[0];
                this.fDVI = object2;
            } else {
                this.fDVI = null;
            }
            if (objectArray[1] instanceof String && ((String)(object2 = (Object)((String)objectArray[1]))).length() > 1) {
                object = object2;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return object;
    }

    private void drawDVIEventThread(Graphics graphics, boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fDVI == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = this.fStack;
        int n7 = 0;
        Font[] fontArray = this.fFont;
        Font font = null;
        ByteArrayInputStream byteArrayInputStream = null;
        int n8 = 0;
        this.fPixelsPerPt = (float)this.fMag * (float)this.fComponent.getToolkit().getScreenResolution() / 72.0f;
        double d = this.fPixelsPerPt / Math.pow(2.0, 16.0);
        if (bl) {
            this.fWidth = 0;
            this.fHeight = 0;
        }
        if (this.fSmoothFont && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        byteArrayInputStream = new ByteArrayInputStream(this.fDVI);
        if (this.fIsDebug) {
            System.out.println("**** FullTex Draw DVI Start ****\n");
            System.out.println("pixels_per_pt: " + d);
        }
        block25: while (byteArrayInputStream.available() > 0) {
            String n14;
            Object n13;
            int n9;
            int n10 = byteArrayInputStream.read();
            if (n10 < 128) {
                n3 = (int)((double)n6 * d);
                n2 = (int)((double)n5 * d);
                char c = n10;
                n9 = c;
                n13 = new Character(c);
                n14 = ((Character)n13).toString();
                if (this.fIsDebug) {
                    System.out.println("**** Draw String ****");
                    System.out.println("Code:" + n10 + " Draw String: " + n9 + " Position x: " + n3 + " y: " + n2);
                }
                if (graphics == null) continue;
                graphics.drawString(n14, n3, n2);
                FontMetrics n15 = graphics.getFontMetrics(font);
                n6 += (int)((double)n15.charWidth(c) / d);
                continue;
            }
            if (n10 > 170 && n10 < 235) {
                n8 = n10 - 171;
                if (this.fIsDebug) {
                    System.out.println("**** Set Font ****");
                    System.out.println("Code:" + n10 + " setFont: " + fontArray[n8].getName());
                }
                if (graphics == null) continue;
                graphics.setFont(fontArray[n8]);
                continue;
            }
            switch (n10) {
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    int n11 = this.readUnsignedNum(byteArrayInputStream, n10 - 127);
                    System.out.println("Error: DVI code " + n10 + " not implemented");
                    if (!this.fIsDebug) break;
                    System.out.println("**** Draw String ****");
                    System.out.println("Code:" + n10 + " ...to be implemented");
                    break;
                }
                case 132: 
                case 137: {
                    int n12;
                    if (this.fIsDebug) {
                        System.out.println("Code:" + n10);
                    }
                    int n122 = (int)(d * (double)this.readNum(byteArrayInputStream, 4));
                    n9 = (int)(d * (double)this.readNum(byteArrayInputStream, 4));
                    if (n122 == 0) {
                        n12 = 1;
                    }
                    if (n9 == 0) {
                        n9 = 1;
                    }
                    n3 = (int)((double)n6 * d);
                    n2 = (int)((double)n5 * d);
                    if (this.fIsDebug) {
                        System.out.println("**** Draw Rectangle ****");
                        System.out.println("Code:" + n10 + " x:" + n3 + " y:" + n2 + " width:" + n9 + " height:" + n12);
                    }
                    if (graphics != null) {
                        graphics.fillRect(n3, n2, n9, n12);
                    }
                    if (n10 != 132) break;
                    n6 += n9;
                    break;
                }
                case 133: 
                case 134: 
                case 135: 
                case 136: {
                    int n11 = this.readUnsignedNum(byteArrayInputStream, n10 - 132);
                    System.out.println("Error: DVI code " + n10 + " not implemented");
                    if (!this.fIsDebug) break;
                    System.out.println("**** Draw String ****");
                    System.out.println("Code:" + n10 + " ...to be implemented");
                    break;
                }
                case 138: {
                    break;
                }
                case 139: {
                    if (this.fIsDebug) {
                        System.out.println("Code:" + n10);
                    }
                    n2 = 0;
                    n3 = 0;
                    n4 = 0;
                    n5 = 0;
                    n6 = 0;
                    n6 = (int)((double)this.fXOffset / d);
                    n5 = (int)((double)this.fYOffset / d);
                    n7 = 0;
                    byteArrayInputStream.skip(44L);
                    break;
                }
                case 140: {
                    break;
                }
                case 141: {
                    if (this.fIsDebug) {
                        System.out.println("Code:" + n10);
                    }
                    nArray[n7++] = n6;
                    nArray[n7++] = n5;
                    nArray[n7++] = n4;
                    nArray[n7++] = n3;
                    nArray[n7++] = n2;
                    nArray[n7++] = n;
                    break;
                }
                case 142: {
                    if (this.fIsDebug) {
                        System.out.println("Code:" + n10);
                    }
                    n = nArray[--n7];
                    n2 = nArray[--n7];
                    n3 = nArray[--n7];
                    n4 = nArray[--n7];
                    n5 = nArray[--n7];
                    n6 = nArray[--n7];
                    break;
                }
                case 143: 
                case 144: 
                case 145: 
                case 146: {
                    int n11 = this.readNum(byteArrayInputStream, n10 - 142);
                    n6 += n11;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " h+=" + n11);
                    break;
                }
                case 147: {
                    n6 += n4;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " h+=" + n4);
                    break;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: {
                    n4 = this.readNum(byteArrayInputStream, n10 - 147);
                    n6 += n4;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " h+=" + n4);
                    break;
                }
                case 152: {
                    n6 += n3;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " h+=" + n3);
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: {
                    n3 = this.readNum(byteArrayInputStream, n10 - 152);
                    n6 += n3;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " h+=" + n3);
                    break;
                }
                case 157: 
                case 158: 
                case 159: 
                case 160: {
                    int n11 = this.readNum(byteArrayInputStream, n10 - 156);
                    n5 += n11;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " v+=" + n11);
                    break;
                }
                case 161: {
                    n5 += n2;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " v+=" + n2);
                    break;
                }
                case 162: 
                case 163: 
                case 164: 
                case 165: {
                    n2 = this.readNum(byteArrayInputStream, n10 - 161);
                    n5 += n2;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " v+=" + n2);
                    break;
                }
                case 166: {
                    n5 += n;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " v+=" + n);
                    break;
                }
                case 167: 
                case 168: 
                case 169: 
                case 170: {
                    n = this.readNum(byteArrayInputStream, n10 - 166);
                    n5 += n;
                    if (!this.fIsDebug) break;
                    System.out.println("Code:" + n10 + " v+=" + n);
                    break;
                }
                case 235: 
                case 236: 
                case 237: 
                case 238: {
                    if (this.fIsDebug) {
                        System.out.println("**** SetFont **** ");
                        System.out.println("Code:" + n10);
                    }
                    n8 = this.readUnsignedNum(byteArrayInputStream, n10 - 234);
                    graphics.setFont(fontArray[n8]);
                    break;
                }
                case 239: 
                case 240: 
                case 241: 
                case 242: {
                    if (this.fIsDebug) {
                        System.out.println("Code:" + n10);
                    }
                    int n11 = this.readUnsignedNum(byteArrayInputStream, n10 - 238);
                    if (bl) {
                        n13 = new byte[n11];
                        byteArrayInputStream.read((byte[])n13, 0, n11);
                        n14 = new String((byte[])n13);
                        if (!n14.startsWith("bounds:")) continue block25;
                        this.getBounds(n14);
                        break;
                    }
                    byteArrayInputStream.skip(n11);
                    break;
                }
                case 243: 
                case 244: 
                case 245: 
                case 246: {
                    if (this.fIsDebug) {
                        System.out.println("Code:" + n10);
                    }
                    n8 = this.readNum(byteArrayInputStream, n10 - 242);
                    this.readNum(byteArrayInputStream, 4);
                    int n15 = this.readUnsignedNum(byteArrayInputStream, 4);
                    int n16 = this.readUnsignedNum(byteArrayInputStream, 4);
                    int n17 = this.readUnsignedNum(byteArrayInputStream, 1);
                    int n18 = this.readUnsignedNum(byteArrayInputStream, 1);
                    byte[] byArray = new byte[n17 + n18];
                    byteArrayInputStream.read(byArray, 0, n17 + n18);
                    String string = new String(byArray);
                    int n19 = this.fMag * 10;
                    Object v = sFontTable.get(string);
                    if (v instanceof Font) {
                        font = ((Font)v).deriveFont(0, n19);
                    } else {
                        System.out.println("Error in TexDraw.java, could not find font: " + string);
                        font = new Font(string, 0, n19);
                    }
                    fontArray[n8] = font;
                    break;
                }
                case 247: {
                    this.readNum(byteArrayInputStream, 1);
                    this.readNum(byteArrayInputStream, 4);
                    this.readNum(byteArrayInputStream, 4);
                    this.readNum(byteArrayInputStream, 4);
                    n8 = this.readNum(byteArrayInputStream, 1);
                    byteArrayInputStream.skip(n8);
                    break;
                }
                case 248: 
                case 249: {
                    return;
                }
            }
        }
    }

    private void getBounds(String string) {
        string = string.substring(7);
        int n = string.indexOf("pt");
        String string2 = string.substring(0, n);
        string = string.substring(n + 2);
        double d = Double.parseDouble(string2);
        int n2 = string.indexOf("pt");
        String string3 = string.substring(0, n2);
        string = string.substring(n2 + 2);
        double d2 = Double.parseDouble(string3);
        int n3 = string.indexOf("pt");
        String string4 = string.substring(0, n3);
        double d3 = Double.parseDouble(string4);
        this.fWidth = (int)(d * this.fPixelsPerPt);
        this.fHeight = (int)((d2 + d3) * this.fPixelsPerPt);
    }

    private int readUnsignedNum(ByteArrayInputStream byteArrayInputStream, int n) {
        int n2 = this.utilReadNum(byteArrayInputStream, n);
        int n3 = (int)(256.0 * Math.pow(2.0, 8 * (n - 1)));
        if (n2 < 0) {
            n2 = n3 - n2;
        }
        if (this.fIsDebug) {
            System.out.println("readUnsignedNum: " + n2 + " nbytes: " + n);
        }
        return n2;
    }

    private int readNum(ByteArrayInputStream byteArrayInputStream, int n) {
        int n2 = this.utilReadNum(byteArrayInputStream, n);
        if (this.fIsDebug) {
            System.out.println("readNum: " + n2 + " nbytes: " + n);
        }
        return n2;
    }

    private int utilReadNum(ByteArrayInputStream byteArrayInputStream, int n) {
        byte[] byArray = null;
        double d = 0.0;
        int n2 = n - 1;
        double d2 = (int)(128.0 * Math.pow(2.0, 8 * (n - 1)));
        if (byteArrayInputStream != null && n > 0) {
            byArray = new byte[n];
            byteArrayInputStream.read(byArray, 0, n);
            for (int i = 0; i < n; ++i) {
                double d3 = byArray[i];
                if (d3 < 0.0) {
                    d3 = 256.0 + d3;
                }
                d += d3 * Math.pow(2.0, 8 * (n - i - 1));
            }
            if (d > d2) {
                d -= d2 * 2.0;
            }
        }
        return (int)d;
    }

    private void loadFonts() {
        String string = Matlab.matlabRoot() + FONTDIR;
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().endsWith(FONTEXT)) continue;
                try {
                    String string2 = fileArray[i].getName();
                    String string3 = string2.substring(0, string2.length() - FONTEXT.length());
                    FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                    Font font = Font.createFont(0, fileInputStream);
                    sFontTable.put(string3, font);
                    fileInputStream.close();
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            System.out.println("Could not find fonts: " + string);
        }
    }
}

