/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.stack;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.editor.actions.DebuggerActions;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlwidgets.stack.StackInfoRegistry;
import com.mathworks.mwswing.ComboBoxItem;
import com.mathworks.toolstrip.components.TSComboBox;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.debug.DebuggerManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class StackComboBox
extends TSComboBox {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.stack.resources.RES_Stack");
    private static final String BASE_STRING = sRes.getString("stack.base.label");
    private static Matlab sMatlab = null;
    private StackCallback fStackCallback;
    private String[] fFullFilenames = null;
    private int fLastDeselectedIndex;
    private boolean fIgnoreActionPerformed = false;
    private DebuggerManager.DebuggerManagerStateListener fDebuggerManagerStateListener = this.createDebuggerManagerStateListener();

    public StackComboBox() {
        this.setName("StackComboBox");
        this.fStackCallback = new StackCallback();
        StackInfoRegistry.addListener(this.fStackCallback);
        this.addItem(new ComboBoxItem(BASE_STRING));
        this.setEnabled(false);
        this.getAccessibleContext().setAccessibleName(sRes.getString("stack.acc.combo"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (StackComboBox.this.fIgnoreActionPerformed) {
                    return;
                }
                if (!StackComboBox.this.isPopupVisible()) {
                    StackComboBox.this.setPopupVisible(true);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!StackComboBox.this.isPopupVisible()) {
                                StackComboBox.this.runUserSelection();
                            }
                        }
                    });
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    StackComboBox.this.runUserSelection();
                    StackComboBox.this.setPopupVisible(false);
                }
            }
        });
    }

    private DebuggerManager.DebuggerManagerStateListener createDebuggerManagerStateListener() {
        return new DebuggerManager.DebuggerManagerStateListener(){

            public void stateUpdated(DebuggerManager.DebuggerTransition debuggerTransition, Class<? extends DebuggerActions> clazz) {
                if (StackComboBox.this.fStackCallback != null) {
                    StackComboBox.this.fStackCallback.stackChanged(StackInfoRegistry.getLastStackInfo());
                }
            }
        };
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void removeNotify() {
        super.removeNotify();
        this.dispose();
    }

    public void dispose() {
        DebuggerManager.removeDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
        if (this.fStackCallback != null) {
            StackInfoRegistry.removeListener(this.fStackCallback);
            this.fStackCallback = null;
        }
    }

    public void addNotify() {
        if (this.fStackCallback == null) {
            this.fStackCallback = new StackCallback();
            StackInfoRegistry.addListener(this.fStackCallback);
        }
        DebuggerManager.addDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
        if (Matlab.isMatlabAvailable()) {
            this.fStackCallback.stackChanged(StackInfoRegistry.getLastStackInfo());
        }
        super.addNotify();
    }

    public static String getStackLabel(boolean bl) {
        String string = ResourceBundle.getBundle("com.mathworks.mlwidgets.stack.resources.RES_Stack").getString("stack.label");
        return string.endsWith(":") && !bl ? string.substring(0, string.length() - 1) : string;
    }

    private void runUserSelection() {
        int n = this.getSelectedIndex() - this.fLastDeselectedIndex;
        if (n != 0) {
            String string = MatlabDebugServices.getStackLevelChangeCommand((int)n);
            sMatlab.evalNoOutput(string);
        }
        this.fLastDeselectedIndex = this.getSelectedIndex();
    }

    public boolean isFunctionOnStack(String string) {
        if (this.fFullFilenames == null || this.fFullFilenames.length == 0) {
            return false;
        }
        File file = new File(string);
        for (int i = 0; i != this.fFullFilenames.length; ++i) {
            String string2 = MLFileUtils.mapPFileToMFile((String)FileUtils.absolutePathname((String)this.fFullFilenames[i]));
            if (!file.equals(new File(string2))) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ String[] access$402(StackComboBox stackComboBox, String[] stringArray) {
        stackComboBox.fFullFilenames = stringArray;
        return stringArray;
    }

    static {
        if (Matlab.isMatlabAvailable()) {
            sMatlab = new Matlab();
        }
    }

    private class Builder
    implements Runnable {
        private MatlabDebugServices.StackInfo fSS;

        Builder(MatlabDebugServices.StackInfo stackInfo) {
            this.fSS = stackInfo;
        }

        @Override
        public void run() {
            StackComboBox.this.fIgnoreActionPerformed = true;
            StackComboBox.this.removeAllItems();
            StackComboBox.access$402(StackComboBox.this, null);
            if (this.fSS == null || !DebuggerManager.getInstance().supportsStackComboBox()) {
                StackComboBox.this.setEnabled(false);
                StackComboBox.this.addItem(new ComboBoxItem(BASE_STRING));
                StackComboBox.this.fLastDeselectedIndex = 0;
            } else {
                int n = this.fSS.getCurrentEntryIndex();
                StackComboBox.access$402(StackComboBox.this, this.fSS.getFullFilenames());
                for (int i = 0; i < this.fSS.getWorkspaceNames().length - 1; ++i) {
                    StackComboBox.this.addItem(new ComboBoxItem(this.fSS.getWorkspaceNames()[i]));
                }
                StackComboBox.this.addItem(new ComboBoxItem(BASE_STRING));
                StackComboBox.this.setEnabled(true);
                StackComboBox.this.setSelectedIndex(n);
                StackComboBox.this.fLastDeselectedIndex = n;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StackComboBox.this.revalidate();
                }
            });
            StackComboBox.this.fIgnoreActionPerformed = false;
        }
    }

    private class StackCallback
    implements StackInfoRegistry.StackInfoChange {
        private StackCallback() {
        }

        @Override
        public void stackChanged(MatlabDebugServices.StackInfo stackInfo) {
            Builder builder = new Builder(stackInfo);
            if (SwingUtilities.isEventDispatchThread()) {
                builder.run();
            } else {
                SwingUtilities.invokeLater(builder);
            }
        }
    }
}

