/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutIconUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutsToolstripTabFactory;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.SyntaxTextPaneBase;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.EditorKit;

public class ShortcutEditor
extends MJFrame {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.shortcuts.resources.RES_Shortcuts");
    private static final String sTitle = sRes.getString("fav.FavoritesGUI");
    private static final String SHORTCUTPREF = "ShortcutEditor";
    private static final String WIDTHKEY = "Width";
    private static final String HEIGHTKEY = "Height";
    private static final String[] ICON_EXTENSIONS = new String[]{"jpg", "gif"};
    private static String sLastLabel;
    private static ShortcutEditor sAddDialog;
    private static Component sInvoker;
    private static Vector sItems;
    private static Point sLocation;
    private static boolean sAdding;
    private MJComboBox fIconBox;
    private MJComboBox fCatBox;
    private MJTextField fLabelBox;
    private SyntaxTextPane fCallbackBox;
    private MJCheckBox fQuickAccessCheckBox;
    private MJCheckBox fShowLabelCheckBox;
    private String fOldLabel;
    private String fOldCategory;
    private String fOldIcon;
    private String fOldCallback;
    private MJButton fDotButton;

    private ShortcutEditor(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        Object object;
        boolean bl3 = MatlabDesktopServices.getDesktop().useToolstrip();
        this.fOldLabel = string2;
        this.fOldCategory = string5;
        this.fOldIcon = string4;
        this.fOldCallback = string3;
        sAdding = bl;
        this.setCloseOnEscapeEnabled(true);
        String[] stringArray = ShortcutIconUtils.getStandardIconNames();
        Object[] objectArray = new Object[stringArray.length];
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = new Item(new Object[]{stringArray[i], ShortcutIconUtils.getStandardIcon(stringArray[i])});
            if (!stringArray[i].equals(string4)) continue;
            n = i;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        sAddDialog = this;
        if (string == null) {
            sAddDialog.setTitle(sTitle);
        } else {
            sAddDialog.setTitle(string);
        }
        this.setName("ShortcutEditorDialog");
        this.getAccessibleContext().setAccessibleName("Shortcut Dialog");
        sAddDialog.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        MJLabel mJLabel = new MJLabel(sRes.getString("gui.Label"));
        mJLabel.setOpaque(false);
        MJLabel mJLabel2 = new MJLabel(sRes.getString("gui.Callback"));
        mJLabel2.setOpaque(false);
        MJLabel mJLabel3 = new MJLabel(sRes.getString("gui.Category"));
        mJLabel3.setOpaque(false);
        MJLabel mJLabel4 = new MJLabel(sRes.getString("gui.Icon"));
        mJLabel4.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints((Component)mJLabel, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)mJLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints((Component)mJLabel2, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)mJLabel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints((Component)mJLabel3, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)mJLabel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints((Component)mJLabel4, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)mJLabel4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = bl3 ? 6 : 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(3, 15, 3, 15);
        if (!bl3) {
            object = new MJMultilineLabel(sRes.getString("gui.HelpfulText"), true);
            object.setName("HelpfulLabel");
            gridBagLayout.setConstraints((Component)object, gridBagConstraints);
            sAddDialog.getContentPane().add((Component)object);
        }
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        object = new AddAction();
        MJButton mJButton = new MJButton((Action)object);
        mJButton.setName("saveButton");
        mJButton.getAccessibleContext().setAccessibleName(sRes.getString("acc.Save"));
        MJButton mJButton2 = new MJButton((Action)new CancelAction());
        mJButton2.setName("CancelButton");
        mJButton2.getAccessibleContext().setAccessibleName(sRes.getString("action.Cancel"));
        MJButton mJButton3 = new MJButton((Action)((Object)new HelpAction()));
        mJButton3.setName("helpButton");
        mJButton3.getAccessibleContext().setAccessibleName(sRes.getString("acc.Help"));
        mJButton3.setToolTipText(null);
        int n2 = mJButton2.getWidth();
        mJButton.setSize(n2, mJButton.getHeight());
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout());
        mJPanel.add((Component)mJButton);
        mJPanel.add((Component)mJButton2);
        mJPanel.add((Component)mJButton3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = bl3 ? 7 : 6;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints((Component)mJPanel, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)mJPanel);
        gridBagConstraints.anchor = 17;
        this.fLabelBox = new MJTextField();
        if (string2 != null) {
            this.fLabelBox.setText(string2);
        }
        this.fLabelBox.setEditable(true);
        this.fLabelBox.setSize(200, 5);
        this.fLabelBox.setName("LabelTextField");
        this.fLabelBox.getAccessibleContext().setAccessibleName(sRes.getString("acc.Label"));
        this.fLabelBox.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.fLabelBox.getActionMap().put("enter", (Action)object);
        this.fCallbackBox = new SyntaxTextPane();
        this.fCallbackBox.registerEditorKit(MLanguage.INSTANCE.getMimeType(), (EditorKit)((Object)new SyntaxKitClass()));
        this.fCallbackBox.setContentType(MLanguage.INSTANCE.getMimeType());
        this.fCallbackBox.setShowLineNumbers(false, false);
        this.fCallbackBox.setContextMenuEnabled(true, false);
        this.fCallbackBox.setSyntaxHighlightingEnabled(MLanguage.INSTANCE, true);
        this.fCallbackBox.setPreferredSize(new Dimension(100, 100));
        this.fCallbackBox.setShowRightMargin(false, false);
        if (string3 != null) {
            this.fCallbackBox.setText(string3);
        }
        this.fCallbackBox.setEditable(true);
        this.fCallbackBox.setName("CallbackTextField");
        this.fCallbackBox.getAccessibleContext().setAccessibleName(sRes.getString("acc.Callback"));
        this.fCallbackBox.discardAllUndoEdits();
        Object[] objectArray2 = ShortcutUtils.getShortcutCategories();
        this.fCatBox = new MJComboBox(objectArray2);
        boolean bl4 = false;
        for (Object n3 : objectArray2) {
            if (!((String)n3).equals(string5)) continue;
            bl4 = true;
            break;
        }
        if (!bl4 && string5 != null && string5.length() > 0) {
            this.fCatBox.addItem((Object)string5);
        }
        if (string5 != null) {
            this.fCatBox.setSelectedItem((Object)string5);
        } else {
            this.fCatBox.setSelectedItem((Object)sRes.getString("node.category.None"));
        }
        this.fCatBox.setEditable(true);
        if (PlatformInfo.isMacintosh()) {
            this.fCatBox.setPreferredSize(new Dimension(200, 15));
        } else {
            this.fCatBox.setSize(200, 5);
        }
        this.fCatBox.getAccessibleContext().setAccessibleName(sRes.getString("acc.Category"));
        this.fCatBox.getEditor().getEditorComponent().getAccessibleContext().setAccessibleName(sRes.getString("acc.Category"));
        this.fCatBox.setName("CategoryTextField");
        ((JTextField)this.fCatBox.getEditor().getEditorComponent()).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ShortcutEditor.this.fCatBox.setSelectedItem(ShortcutEditor.this.fCatBox.getEditor().getItem());
                }
            }
        });
        ComboBoxRenderer comboBoxRenderer = new ComboBoxRenderer();
        this.fIconBox = new MJComboBox(objectArray);
        this.fIconBox.setName("IconTextField");
        this.fIconBox.getAccessibleContext().setAccessibleName(sRes.getString("acc.Icon"));
        if (!PlatformInfo.isMacintosh()) {
            this.fIconBox.setPreferredSize(this.fCatBox.getPreferredSize());
        }
        Enumeration enumeration = sItems.elements();
        while (enumeration.hasMoreElements()) {
            Item jComponent = (Item)enumeration.nextElement();
            this.fIconBox.addItem((Object)jComponent);
            if (!jComponent.getDescription().equals(string4)) continue;
            n = this.fIconBox.getItemCount() - 1;
        }
        if (n == -1 && string4 != null) {
            this.addIconInCombobox(string4);
        } else if (string4 != null) {
            this.fIconBox.setSelectedIndex(n);
        }
        this.fIconBox.setRenderer((ListCellRenderer)comboBoxRenderer);
        this.fIconBox.setSelectedItem((Object)ShortcutIconUtils.GENERAL_ICON_NAME);
        this.fIconBox.setSize(200, 5);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints((Component)this.fLabelBox, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)this.fLabelBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        JComponent jComponent = SyntaxTextPane.getDisplayComponent((SyntaxTextPaneBase)this.fCallbackBox);
        if (PlatformInfo.isXWindows()) {
            jComponent.setBorder(BorderFactory.createCompoundBorder(jComponent.getBorder(), BorderFactory.createEtchedBorder(1)));
        }
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        sAddDialog.getContentPane().add(jComponent);
        if (PlatformInfo.isMacintosh()) {
            gridBagConstraints.ipady = 6;
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints((Component)this.fCatBox, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)this.fCatBox);
        this.fDotButton = new MyDirBrowseButton((Action)((Object)new IconBrowseAction()));
        this.fDotButton.setName("...");
        this.fDotButton.getAccessibleContext().setAccessibleName(sRes.getString("BrowseforIcon"));
        this.fDotButton.setDefaultCapable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints((Component)this.fIconBox, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)this.fIconBox);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints((Component)this.fDotButton, gridBagConstraints);
        sAddDialog.getContentPane().add((Component)this.fDotButton);
        if (ShortcutEditor.displayQuickAccessOptions(string5)) {
            this.fQuickAccessCheckBox = new MJCheckBox(sRes.getString("gui.AddToQuickAccess"), bl && bl2 || ShortcutsToolstripTabFactory.isOnQuickAccessToolBar(string2, string5));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 0, 0, 3);
            gridBagLayout.setConstraints((Component)this.fQuickAccessCheckBox, gridBagConstraints);
            sAddDialog.getContentPane().add((Component)this.fQuickAccessCheckBox);
            this.fShowLabelCheckBox = new MJCheckBox(sRes.getString("gui.ShowLabel"), ShortcutsToolstripTabFactory.isLabelVisible(string2, string5));
            this.fShowLabelCheckBox.setEnabled(this.fQuickAccessCheckBox.isSelected());
            this.fQuickAccessCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ShortcutEditor.this.fShowLabelCheckBox.setEnabled(ShortcutEditor.this.fQuickAccessCheckBox.isSelected());
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 3, 3);
            gridBagLayout.setConstraints((Component)this.fShowLabelCheckBox, gridBagConstraints);
            sAddDialog.getContentPane().add((Component)this.fShowLabelCheckBox);
            this.fCatBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    String string = itemEvent.getItem().toString();
                    if (ShortcutUtils.getDefaultHelpCategoryName().equals(string)) {
                        ShortcutEditor.this.fQuickAccessCheckBox.setEnabled(false);
                        ShortcutEditor.this.fShowLabelCheckBox.setEnabled(false);
                    } else {
                        ShortcutEditor.this.fQuickAccessCheckBox.setEnabled(true);
                        ShortcutEditor.this.fShowLabelCheckBox.setEnabled(ShortcutEditor.this.fQuickAccessCheckBox.isSelected());
                    }
                }
            });
        }
        sAddDialog.addWindowListener(new WindowEventHandler());
        int n3 = Prefs.getIntegerPref((String)"ShortcutEditorWidth", (int)450);
        int n4 = Prefs.getIntegerPref((String)"ShortcutEditorHeight", (int)350);
        sAddDialog.setSize(n3, n4);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = sAddDialog.getBounds();
        sLocation = new Point((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        sAddDialog.setLocation(sLocation);
        sAddDialog.setVisible(true);
    }

    private static boolean displayQuickAccessOptions(String string) {
        return MatlabDesktopServices.getDesktop().useToolstrip() && ShortcutsToolstripTabFactory.isQuickAccessToolBarPresent() && !ShortcutUtils.getDefaultHelpCategoryName().equals(string);
    }

    private static boolean checkForOpenDialog(String string) {
        if (sAddDialog == null || sLastLabel != null && sLastLabel.equals(string)) {
            return false;
        }
        boolean bl = false;
        if (sAddDialog != null && sAddDialog.isVisible()) {
            int n = MJOptionPane.showConfirmDialog((Component)((Object)sAddDialog), (Object)sRes.getString("alert.closeDialog"));
            if (n == 0) {
                ShortcutEditor.saveDialog();
            } else if (n == 2) {
                bl = true;
            } else {
                sAddDialog.dispose();
            }
        }
        return bl;
    }

    public static void invoke() {
        ShortcutEditor.invoke(null, null, null, null, sRes.getString("node.category.None"), true, false);
    }

    public static void invoke(String string, String string2) {
        ShortcutEditor.invoke(string, string2, null, ShortcutUtils.getTopLevelNodeName(), true);
    }

    public static void invoke(String string, String string2, String string3) {
        ShortcutEditor.invoke(string, string2, null, string3, true);
    }

    public static void invoke(String string, String string2, String string3, String string4, String string5) {
        ShortcutEditor.invoke(string2, string3, string4, string5, true);
    }

    public static void invoke(String string, String string2, String string3, String string4, boolean bl) {
        ShortcutEditor.invoke(null, string, string2, string3, string4, bl);
    }

    public static void invoke(String string, String string2, String string3, String string4, String string5, boolean bl) {
        ShortcutEditor.invoke(string, string2, string3, string4, string5, bl, false);
    }

    public static void invoke(final String string, final String string2, String string3, final String string4, final String string5, final boolean bl, final boolean bl2) {
        final String string6 = bl && (string3 == null || string3.length() == 0) ? "% " + sRes.getString("callback.default") : string3;
        boolean bl3 = ShortcutEditor.checkForOpenDialog(string2);
        if (bl3) {
            return;
        }
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (sAddDialog == null || sLastLabel == null || !sLastLabel.equals(string2)) {
                    sAddDialog = new ShortcutEditor(string, string2, string6, string4, string5, bl, bl2);
                    sLastLabel = string2;
                } else {
                    sAddDialog.show();
                }
            }
        });
    }

    static void setInvoker(Component component) {
        sInvoker = component;
    }

    static Component getInvoker() {
        return sInvoker;
    }

    private static void saveDialog() {
        String string = ShortcutEditor.sAddDialog.fLabelBox.getText();
        Item item = (Item)ShortcutEditor.sAddDialog.fIconBox.getSelectedItem();
        String string2 = item.getDescription();
        String string3 = ShortcutEditor.sAddDialog.fCallbackBox.getText();
        String string4 = (String)ShortcutEditor.sAddDialog.fCatBox.getSelectedItem();
        while ((string == null || string.equals("")) && (string = MJOptionPane.showInputDialog(null, (Object)sRes.getString("alert.NewShortcutMsg"), (String)sRes.getString("alert.NewShortcutTitle"), (int)0)) != null) {
        }
        boolean bl = string == null || string.equals("") ? false : (sAdding ? ShortcutUtils.addShortcutToBottom(string, string3, string2, string4, "true") == 0 : (!string.equals(ShortcutEditor.sAddDialog.fOldLabel) || !string4.equals(ShortcutEditor.sAddDialog.fOldCategory) || !string2.equals(ShortcutEditor.sAddDialog.fOldIcon) || !string3.equals(ShortcutEditor.sAddDialog.fOldCallback) ? ShortcutUtils.editShortcut(ShortcutEditor.sAddDialog.fOldLabel, ShortcutEditor.sAddDialog.fOldCategory, string, string4, string3, string2, "junk") == 0 : true));
        if (bl) {
            if (ShortcutEditor.sAddDialog.fQuickAccessCheckBox != null) {
                ShortcutsToolstripTabFactory.updateQuickAccessToolBar(string, string4, ShortcutEditor.sAddDialog.fQuickAccessCheckBox.isSelected(), ShortcutEditor.sAddDialog.fShowLabelCheckBox.isSelected());
            }
            sAddDialog.closeWindow();
        }
    }

    private void addIconInCombobox(String string) {
        ImageIcon imageIcon = new ImageIcon(string);
        this.addIconInCombobox(imageIcon, string);
    }

    private void addIconInCombobox(ImageIcon imageIcon, String string) {
        for (int i = 0; i < this.fIconBox.getItemCount(); ++i) {
            if (!((Item)this.fIconBox.getItemAt(i)).getDescription().equals(string)) continue;
            this.fIconBox.setSelectedIndex(i);
            return;
        }
        Image image = imageIcon.getImage().getScaledInstance(16, 16, 1);
        Item item = new Item(new Object[]{string, new ImageIcon(image)});
        this.fIconBox.addItem((Object)item);
        this.fIconBox.setSelectedItem((Object)item);
        sItems.addElement(item);
    }

    private void closeWindow() {
        sLocation = sAddDialog.getLocation();
        Dimension dimension = sAddDialog.getSize();
        Prefs.setIntegerPref((String)"ShortcutEditorWidth", (int)dimension.width);
        Prefs.setIntegerPref((String)"ShortcutEditorHeight", (int)dimension.height);
        this.fCallbackBox.cleanup();
        sAddDialog.dispose();
        sLastLabel = null;
        sAddDialog = null;
        sInvoker = null;
    }

    public static void main(String[] stringArray) {
        ShortcutEditor.invoke();
    }

    static {
        sItems = new Vector();
    }

    public static class SyntaxKitClass
    extends MKit {
        public String getContentType() {
            return MLanguage.INSTANCE.getMimeType();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ShortcutEditor.this.closeWindow();
        }
    }

    private class MyDirBrowseButton
    extends MJButton {
        public MyDirBrowseButton(Action action) {
            super(action);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = this.getMinimumSize();
            dimension.height = ((ShortcutEditor)ShortcutEditor.this).fIconBox.getPreferredSize().height;
            dimension.width = this.getFontMetrics(this.getFont()).stringWidth(" ...  ");
            return dimension;
        }
    }

    class IconBrowseAction
    extends MJAbstractAction
    implements ChangeListener {
        MJFileChooserPerPlatform iChooser;

        public IconBrowseAction() {
            super("...");
            this.setTip(sRes.getString("BrowseforIcon"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.iChooser = new MJFileChooserPerPlatform();
            this.iChooser.addChoosableFileFilter((FilePatternFilter)new FileExtensionFilter(sRes.getString("FilterDescription"), ICON_EXTENSIONS, true));
            this.iChooser.showOpenDialog((Component)ShortcutEditor.this.fDotButton, (ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.iChooser.getState() == 0) {
                final ImageIcon imageIcon = new ImageIcon(this.iChooser.getSelectedFile().getAbsolutePath());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (imageIcon.getImageLoadStatus() == 4) {
                            MJOptionPane.showMessageDialog(null, (Object)sRes.getString("alert.InvalidIconType"), (String)sRes.getString("alert.InvalidIconTitle"), (int)0);
                            IconBrowseAction.this.iChooser.showOpenDialog((Component)ShortcutEditor.this.fDotButton, (ChangeListener)IconBrowseAction.this);
                        } else {
                            ShortcutEditor.this.addIconInCombobox(imageIcon, IconBrowseAction.this.iChooser.getSelectedFile().getAbsolutePath());
                        }
                    }
                });
            }
        }
    }

    class HelpAction
    extends MJAbstractAction {
        public HelpAction() {
            super(sRes.getString("button.Help"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = HelpUtils.getMapfileName("matlab", "env_csh");
            MLHelpServices.cshDisplayTopic((String)string, (String)"shortcuts_creating");
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(sRes.getString("action.Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutEditor.this.closeWindow();
        }
    }

    class AddAction
    extends AbstractAction {
        public AddAction() {
            super(sRes.getString("button.Save"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ShortcutEditor.saveDialog();
        }
    }

    class ComboBoxRenderer
    extends MJLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            Item item = (Item)object;
            if (item.getDescription() != null) {
                this.setText(item.getDescription());
            }
            this.setIcon(item.getIcon());
            return this;
        }
    }

    class Item {
        private ImageIcon fImageIcon;
        private String fDesc;

        public Item(Object[] objectArray) {
            this.fImageIcon = (ImageIcon)objectArray[1];
            this.fDesc = (String)objectArray[0];
        }

        public ImageIcon getIcon() {
            return this.fImageIcon;
        }

        public String getDescription() {
            return this.fDesc;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

