/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs.binding;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTable;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.ActionDataID;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import com.mathworks.mwswing.binding.MetaBindingUtils;
import com.mathworks.mwswing.binding.NavigationalBindingUtils;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.WidgetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class KeyBindingPanelUtils {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.binding.resources.RES_BindingPrefs");
    static final boolean SPACING_IS_TIGHT = PlatformInfo.isMacintosh();
    private static final String TAB = "\t";

    private KeyBindingPanelUtils() {
    }

    public static String lookup(String string) {
        return sRes.getString(string);
    }

    static String makeContextList(List<Context> list) {
        String string = "";
        String string2 = ", ";
        for (Context context : list) {
            string = string + context.getName() + string2;
        }
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - string2.length());
        }
        return string.length() > 0 ? string : KeyBindingPanelUtils.lookup("contextList.noContexts");
    }

    static JPanel layoutTablePanel(MJLabel mJLabel, MJTable mJTable, JComponent jComponent, boolean bl) {
        MJScrollPane mJScrollPane = KeyBindingPanelUtils.setupTable(mJTable, bl);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p, 0dlu:grow", "p, 1dlu, fill:p:grow, 1dlu, p"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJLabel, cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)mJScrollPane, cellConstraints.xyw(1, 3, 2));
        panelBuilder.add((Component)jComponent, cellConstraints.xy(1, 5));
        return panelBuilder.getPanel();
    }

    static MJScrollPane setupTable(final MJTable mJTable, boolean bl) {
        mJTable.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (mJTable.getRowCount() > 0 && mJTable.getSelectedRowCount() == 0) {
                    mJTable.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        });
        mJTable.setSelectionMode(0);
        mJTable.getTableHeader().setReorderingAllowed(false);
        mJTable.setCellViewerEnabled(true);
        if (bl) {
            ListColorUtils.setupForList((JTable)mJTable);
            ListColorUtils.installListRenderer((JTable)mJTable);
        } else {
            mJTable.setShowGrid(false);
            mJTable.setIntercellSpacing(new Dimension(0, 0));
        }
        MJScrollPane mJScrollPane = new MJScrollPane((Component)mJTable);
        mJScrollPane.getViewport().setBackground(mJTable.getBackground());
        mJScrollPane.setHorizontalScrollBarPolicy(31);
        return mJScrollPane;
    }

    static String getActionDescription(ActionData actionData) {
        return actionData.getDescription();
    }

    static String markAsModified(String string) {
        return MessageFormat.format(KeyBindingPanelUtils.lookup("shortcutSet.Modified"), string);
    }

    public static List<KeyStrokeList> removeHiddenEntries(List<KeyStrokeList> list) {
        ArrayList<KeyStrokeList> arrayList = new ArrayList<KeyStrokeList>(list);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            KeyStrokeList keyStrokeList = (KeyStrokeList)iterator.next();
            if (!NavigationalBindingUtils.hasKeypadNavigationalStrokes((KeyStrokeList)keyStrokeList) && !MetaBindingUtils.hasMeta((KeyStrokeList)keyStrokeList)) continue;
            iterator.remove();
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static ConflictType getConflictType(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, ActionData actionData) {
        ArrayList<ConflictData> arrayList = new ArrayList<ConflictData>();
        ArrayList<ConflictData> arrayList2 = new ArrayList<ConflictData>();
        KeyBindingPanelUtils.getConflictsForAction(keyBindingManager, keyBindingSet, actionData, arrayList, arrayList2);
        return KeyBindingPanelUtils.getConflictResults(arrayList, arrayList2);
    }

    public static ConflictType getConflictType(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, ActionData actionData, KeyStrokeList keyStrokeList, List<Context> list) {
        ArrayList<ConflictData> arrayList = new ArrayList<ConflictData>();
        ArrayList<ConflictData> arrayList2 = new ArrayList<ConflictData>();
        KeyBindingPanelUtils.getConflictsForActionAndBinding(keyBindingManager, keyBindingSet, actionData, keyStrokeList, list, arrayList, arrayList2);
        return KeyBindingPanelUtils.getConflictResults(arrayList, arrayList2);
    }

    public static String getConflictDescription(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, ActionData actionData) {
        ArrayList<ConflictData> arrayList = new ArrayList<ConflictData>();
        ArrayList<ConflictData> arrayList2 = new ArrayList<ConflictData>();
        KeyBindingPanelUtils.getConflictsForAction(keyBindingManager, keyBindingSet, actionData, arrayList, arrayList2);
        return KeyBindingPanelUtils.formatConflicts(arrayList, arrayList2);
    }

    public static String getConflictDescription(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, ActionData actionData, KeyStrokeList keyStrokeList, List<Context> list) {
        ArrayList<ConflictData> arrayList = new ArrayList<ConflictData>();
        ArrayList<ConflictData> arrayList2 = new ArrayList<ConflictData>();
        KeyBindingPanelUtils.getConflictsForActionAndBinding(keyBindingManager, keyBindingSet, actionData, keyStrokeList, list, arrayList, arrayList2);
        return KeyBindingPanelUtils.formatConflicts(arrayList, arrayList2);
    }

    static Color getTableBackgroundColor(JTable jTable, int n, boolean bl) {
        return ListColorUtils.getListAlternatingBackgroundColor((JTable)jTable, (int)n, (boolean)bl, (boolean)jTable.hasFocus());
    }

    static Color getTableForegroundColor(JTable jTable, boolean bl) {
        return ListColorUtils.getListForegroundColor((JTable)jTable, (boolean)bl, (boolean)jTable.hasFocus());
    }

    private static Icon getIconForConflictType(ConflictType conflictType) {
        return conflictType == ConflictType.WARNING ? CommonIcon.INFO_12.getIcon() : (conflictType == ConflictType.ERROR ? DialogIcon.ERROR_12x12.getIcon() : null);
    }

    static int getConflictColumnWidth() {
        int n = WidgetUtils.getEmSize().width;
        return KeyBindingPanelUtils.getIconForConflictType(ConflictType.ERROR).getIconWidth() + n;
    }

    private static ConflictType getConflictResults(List<ConflictData> list, List<ConflictData> list2) {
        return !list.isEmpty() ? ConflictType.ERROR : (!list2.isEmpty() ? ConflictType.WARNING : ConflictType.NONE);
    }

    private static String formatConflicts(List<ConflictData> list, List<ConflictData> list2) {
        if (list.isEmpty() && list2.isEmpty()) {
            return null;
        }
        String string = "<html>";
        for (ConflictData conflictData : list) {
            string = string + conflictData.getErrorString() + "<br>";
        }
        for (ConflictData conflictData : list2) {
            string = string + conflictData.getWarningString() + "<br>";
        }
        string = string + "</html>";
        return string;
    }

    private static void getConflictsForAction(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, ActionData actionData, List<ConflictData> list, List<ConflictData> list2) {
        List<KeyStrokeList> list3 = KeyBindingPanelUtils.removeHiddenEntries(keyBindingSet.getActionGlobalKeyBindings(actionData));
        for (KeyStrokeList object2 : list3) {
            KeyBindingPanelUtils.getConflictsForActionBindingAllContexts(keyBindingManager, keyBindingSet, actionData, object2, list, list2);
        }
        Collection collection = keyBindingManager.getContextsWithAction((ActionDataID)actionData);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            List<KeyStrokeList> list4 = KeyBindingPanelUtils.removeHiddenEntries(keyBindingSet.getNonGlobalKeyBindings(context, (ActionDataID)actionData));
            for (KeyStrokeList keyStrokeList : list4) {
                KeyBindingPanelUtils.getConflictsForActionBindingAndContext(keyBindingManager, keyBindingSet, actionData, keyStrokeList, context, list, list2);
            }
        }
    }

    private static void getConflictsForActionAndBinding(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, ActionData actionData, KeyStrokeList keyStrokeList, List<Context> list, List<ConflictData> list2, List<ConflictData> list3) {
        for (Context context : list) {
            KeyBindingPanelUtils.getConflictsForActionBindingAndContext(keyBindingManager, keyBindingSet, actionData, keyStrokeList, context, list2, list3);
        }
    }

    private static void getConflictsForActionBindingAndContext(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, ActionData actionData, KeyStrokeList keyStrokeList, Context context, List<ConflictData> list, List<ConflictData> list2) {
        KeyBindingPanelUtils.addWarningsAndErrors(keyBindingManager, keyBindingSet, Arrays.asList(context), actionData, keyStrokeList, list, list2);
    }

    private static void getConflictsForActionBindingAllContexts(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, ActionData actionData, KeyStrokeList keyStrokeList, List<ConflictData> list, List<ConflictData> list2) {
        Collection<Context> collection = KeyBindingPanelUtils.getContextsWithBindingForAction(keyBindingManager.getContextsWithAction((ActionDataID)actionData), keyBindingSet, actionData, keyStrokeList);
        KeyBindingPanelUtils.addWarningsAndErrors(keyBindingManager, keyBindingSet, collection, actionData, keyStrokeList, list, list2);
    }

    static Collection<Context> getContextsWithBindingForAction(Collection<Context> collection, KeyBindingSet keyBindingSet, ActionData actionData, KeyStrokeList keyStrokeList) {
        ArrayList<Context> arrayList = new ArrayList<Context>(collection);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            if (keyBindingSet.getKeyBindings(context, actionData).contains(keyStrokeList)) continue;
            iterator.remove();
        }
        return arrayList;
    }

    private static void addWarningsAndErrors(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, Collection<Context> collection, ActionData actionData, KeyStrokeList keyStrokeList, List<ConflictData> list, List<ConflictData> list2) {
        List<KeyBindingManager.Conflict> list3 = KeyBindingPanelUtils.getConflictsIfBindingIsActive(keyBindingSet, keyBindingManager, keyStrokeList, actionData);
        for (KeyBindingManager.Conflict conflict : list3) {
            if (conflict.getAction().equals((Object)actionData)) continue;
            if (collection.contains(conflict.getContext())) {
                KeyBindingPanelUtils.addErrorConflictIfNecessary(conflict, list, list2);
                continue;
            }
            if (!keyStrokeList.equals((Object)conflict.getBinding())) continue;
            KeyBindingPanelUtils.addWarningConflictIfNecessary(conflict, list, list2);
        }
    }

    private static void addErrorConflictIfNecessary(KeyBindingManager.Conflict conflict, List<ConflictData> list, List<ConflictData> list2) {
        ConflictData conflictData = KeyBindingPanelUtils.createConflictDataForError(conflict.getAction(), conflict.getBinding(), conflict.getContext());
        if (!list.contains(conflictData)) {
            list.add(conflictData);
        }
        Iterator<ConflictData> iterator = list2.iterator();
        while (iterator.hasNext()) {
            ConflictData conflictData2 = iterator.next();
            if (!conflictData2.getAction().equals((Object)conflict.getAction()) || !conflictData2.getBinding().equals((Object)conflict.getBinding())) continue;
            iterator.remove();
        }
    }

    private static void addWarningConflictIfNecessary(KeyBindingManager.Conflict conflict, List<ConflictData> list, List<ConflictData> list2) {
        ConflictData conflictData = KeyBindingPanelUtils.createConflictDataForWarning(conflict.getAction(), conflict.getBinding());
        if (!list2.contains(conflictData)) {
            boolean bl = true;
            for (ConflictData conflictData2 : list) {
                if (!conflictData2.getAction().equals((Object)conflict.getAction()) || !conflictData2.getBinding().equals((Object)conflict.getBinding())) continue;
                bl = false;
                break;
            }
            if (bl) {
                list2.add(conflictData);
            }
        }
    }

    private static ConflictData createConflictDataForWarning(ActionData actionData, KeyStrokeList keyStrokeList) {
        return new ConflictData(actionData, keyStrokeList, null);
    }

    private static ConflictData createConflictDataForError(ActionData actionData, KeyStrokeList keyStrokeList, Context context) {
        return new ConflictData(actionData, keyStrokeList, Arrays.asList(context));
    }

    public static String getWarningText(ActionData actionData, KeyStrokeList keyStrokeList) {
        return MessageFormat.format(KeyBindingPanelUtils.lookup("conflictMessage.warning"), actionData.getPreferencePanelLabel(), KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)keyStrokeList));
    }

    public static String getErrorText(ActionData actionData, KeyStrokeList keyStrokeList, Context context) {
        return MessageFormat.format(KeyBindingPanelUtils.lookup("conflictMessage.error"), actionData.getPreferencePanelLabel(), context.getName(), KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)keyStrokeList));
    }

    static List<KeyBindingManager.Conflict> getConflictsIfBindingIsActive(KeyBindingSet keyBindingSet, KeyBindingManager keyBindingManager, KeyStrokeList keyStrokeList, ActionData actionData) {
        Object object2;
        boolean bl = false;
        for (Object object2 : keyBindingManager.getContextsWithAction((ActionDataID)actionData)) {
            if (!keyBindingSet.getKeyBindings((Context)object2, actionData).contains(keyStrokeList) || keyBindingSet.getFollowsComponentContext((Context)object2, (ActionDataID)actionData)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return new ArrayList<KeyBindingManager.Conflict>();
        }
        List list = keyBindingManager.getAllKeyBindingConflicts(keyBindingSet, keyStrokeList);
        object2 = list.iterator();
        while (object2.hasNext()) {
            KeyBindingManager.Conflict conflict = (KeyBindingManager.Conflict)object2.next();
            if (!keyBindingSet.getFollowsComponentContext(conflict.getContext(), (ActionDataID)conflict.getAction())) continue;
            object2.remove();
        }
        return list;
    }

    public static String getStringRepresentation(KeyBindingManager keyBindingManager, KeyBindingSet keyBindingSet, String string, ActionData ... actionDataArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(KeyBindingPanelUtils.lookup("conflictPanel.table.actionHeader") + TAB + KeyBindingPanelUtils.lookup("conflictPanel.table.componentsHeaderSingular") + TAB + MessageFormat.format(KeyBindingPanelUtils.lookup("conflictPanel.table.shortcutSetName"), string) + TAB + KeyBindingPanelUtils.lookup("conflictPanel.table.description") + "\n");
        KeyBindingPanelUtils.insertBlankLine(stringBuffer);
        for (ActionData actionData : actionDataArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Context context : keyBindingManager.getContextsWithAction((ActionDataID)actionData)) {
                KeyBindingPanelUtils.writeLineForEachBinding(arrayList, actionData, context, keyBindingSet.getKeyBindings(context, actionData));
            }
            Collections.sort(arrayList);
            for (String string2 : arrayList) {
                stringBuffer.append(string2);
            }
            KeyBindingPanelUtils.insertBlankLine(stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static void insertBlankLine(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
    }

    private static void writeLineForEachBinding(List<String> list, ActionData actionData, Context context, List<KeyStrokeList> list2) {
        if ((list2 = KeyBindingPanelUtils.removeHiddenEntries(list2)).isEmpty()) {
            KeyBindingPanelUtils.writeLine(list, actionData, context, null);
        } else {
            for (KeyStrokeList keyStrokeList : list2) {
                KeyBindingPanelUtils.writeLine(list, actionData, context, keyStrokeList);
            }
        }
    }

    private static void writeLine(List<String> list, ActionData actionData, Context context, KeyStrokeList keyStrokeList) {
        String string = keyStrokeList == null ? "" : (PlatformInfo.isMacintosh() ? KeyStrokeUtils.translateKeyStrokesToAscii((KeyStrokeList)keyStrokeList) : KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)keyStrokeList));
        list.add(actionData.getPreferencePanelLabel() + TAB + context.getName() + TAB + string + TAB + actionData.getDescription() + "\n");
    }

    static class ConflictData {
        private final ActionData fAction;
        private final KeyStrokeList fBinding;
        private final List<Context> fContexts;

        protected ConflictData(ActionData actionData, KeyStrokeList keyStrokeList, List<Context> list) {
            assert (actionData != null) : " supplied action cannot be null";
            assert (keyStrokeList != null) : " supplied binding cannot be null";
            this.fAction = actionData;
            this.fBinding = keyStrokeList;
            this.fContexts = list != null ? Collections.unmodifiableList(list) : null;
        }

        public boolean equals(Object object) {
            if (object instanceof ConflictData) {
                ConflictData conflictData = (ConflictData)object;
                return conflictData.fAction.equals((Object)this.fAction) && conflictData.fBinding.equals((Object)this.fBinding) && (conflictData.fContexts == null && this.fContexts == null || conflictData.fContexts != null && this.fContexts != null && conflictData.fContexts.equals(this.fContexts));
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 31 * n + this.fAction.hashCode();
            n = 31 * n + this.fBinding.hashCode();
            n = 31 * n + (null == this.fContexts ? 0 : this.fContexts.hashCode());
            return n;
        }

        private String getErrorString() {
            assert (this.fContexts != null) : "No context information was stored, so it is not valid to ask for an error description.";
            assert (this.fContexts.size() == 1) : "This method should only be called when there is a single error conflict";
            return KeyBindingPanelUtils.getErrorText(this.fAction, this.fBinding, this.fContexts.get(0));
        }

        private String getWarningString() {
            assert (this.fContexts == null) : "The warning message should only be asked for if no contexts are present";
            return KeyBindingPanelUtils.getWarningText(this.fAction, this.fBinding);
        }

        List<Context> getContexts() {
            return this.fContexts;
        }

        KeyStrokeList getBinding() {
            return this.fBinding;
        }

        ActionData getAction() {
            return this.fAction;
        }
    }

    public static abstract class ConflictRenderer
    extends DefaultTableCellRenderer {
        public ConflictRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setIcon(KeyBindingPanelUtils.getIconForConflictType(this.getConflictType(n)));
            this.setBackground(KeyBindingPanelUtils.getTableBackgroundColor(jTable, n, bl));
            this.setForeground(KeyBindingPanelUtils.getTableForegroundColor(jTable, bl));
            this.setText("");
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder());
            return this;
        }

        public abstract ConflictType getConflictType(int var1);
    }

    public static enum ConflictType {
        ERROR,
        WARNING,
        NONE;

    }
}

