/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.prefs.JavaMemPrefs;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSlider;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.util.PlatformInfo;
import com.sun.management.OperatingSystemMXBean;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JavaMemoryPrefsPanel
extends MJPanel {
    private static final int MB_IN_GB = 1024;
    private static final int KB_IN_MB = 1024;
    private static final long MB = 0x100000L;
    private static final Object[] EMPTY = new Object[0];
    private static final int HEAP_MIN_ALLOWED = JavaMemPrefs.getHeapMin();
    private int fHeapMaxAllowed;
    private static int sMemMaxMB = 0;
    private static final int INCR_MB = 16;
    private static JavaMemoryPrefsPanel sPrefsPanel = null;
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private MJSlider fHeapSlider;
    private MJSpinner fHeapSpinner;
    private final int fInitHeapMax;
    private static final int HEAP_MAX_CUR = JavaMemPrefs.getHeapMaxCur();
    private JLabel fWarnMsg;

    private boolean initSliderSpinner(int n) {
        this.fHeapMaxAllowed = n == 0 ? Math.max(2 * JavaMemPrefs.getHeapMaxCur(), 250) : n / 4;
        this.setWarnMsg();
        int n2 = Math.min(HEAP_MIN_ALLOWED, Math.min(HEAP_MAX_CUR, this.fInitHeapMax));
        int n3 = Math.max(this.fHeapMaxAllowed, Math.max(HEAP_MIN_ALLOWED, this.fInitHeapMax));
        this.fHeapSlider.setMinimum(n2);
        this.fHeapSlider.setMaximum(n3);
        Hashtable<Integer, MJLabel> hashtable = new Hashtable<Integer, MJLabel>();
        int n4 = HEAP_MIN_ALLOWED - n2 > 30 ? HEAP_MIN_ALLOWED - n2 : (this.fHeapMaxAllowed - HEAP_MIN_ALLOWED) / 2;
        this.fHeapSlider.setMinorTickSpacing(n4);
        ((Dictionary)hashtable).put(HEAP_MIN_ALLOWED, new MJLabel(Integer.toString(HEAP_MIN_ALLOWED)));
        ((Dictionary)hashtable).put((this.fHeapMaxAllowed + HEAP_MIN_ALLOWED) / 2, new MJLabel(Integer.toString((this.fHeapMaxAllowed + HEAP_MIN_ALLOWED) / 2)));
        ((Dictionary)hashtable).put(this.fHeapMaxAllowed, new MJLabel(Integer.toString(this.fHeapMaxAllowed)));
        if (n3 >= this.fHeapMaxAllowed + 100) {
            ((Dictionary)hashtable).put(n3, new MJLabel(Integer.toString(n3)));
        }
        if (n2 <= HEAP_MIN_ALLOWED - 100) {
            ((Dictionary)hashtable).put(n2, new MJLabel(Integer.toString(n2)));
        }
        this.fHeapSlider.setLabelTable(hashtable);
        this.fHeapSlider.setValue(this.fInitHeapMax);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.fInitHeapMax, n2, n3, 16){

            @Override
            public Object getNextValue() {
                Comparable<?> comparable = super.getNextValue();
                return comparable == null ? this.getMaximum() : comparable;
            }

            @Override
            public Object getPreviousValue() {
                Comparable<?> comparable = super.getPreviousValue();
                return comparable == null ? this.getMinimum() : comparable;
            }
        };
        this.fHeapSpinner.setModel((SpinnerModel)spinnerNumberModel);
        return this.fInitHeapMax < HEAP_MIN_ALLOWED || this.fInitHeapMax > this.fHeapMaxAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaMemoryPrefsPanel() {
        MJPanel mJPanel;
        MJPanel mJPanel2;
        MJPanel mJPanel3;
        block14: {
            this.fHeapMaxAllowed = 1024;
            this.fInitHeapMax = JavaMemPrefs.getHeapMax();
            FormLayout formLayout = new FormLayout("pref,35dlu,175dlu,5dlu,center:pref,15dlu", "pref,5dlu,center:pref,5dlu,pref");
            CellConstraints cellConstraints = new CellConstraints();
            mJPanel3 = new MJPanel((LayoutManager)formLayout);
            mJPanel3.setBorder((Border)BorderFactory.createTitledBorder(RESOURCE.getString("jmpp.heapsize.groupbox")));
            mJPanel3.setName("HeapMemPanel");
            mJPanel3.getAccessibleContext().setAccessibleName(RESOURCE.getString("jmpp.heapsize.groupbox"));
            MJTextArea mJTextArea = new MJTextArea();
            mJTextArea.setLineWrap(true);
            mJTextArea.setWrapStyleWord(true);
            mJTextArea.setText(RESOURCE.getString("jmpp.heapsize.verbose"));
            mJTextArea.setEditable(false);
            mJTextArea.setBackground(this.getBackground());
            mJPanel3.add((Component)mJTextArea, (Object)cellConstraints.xyw(1, 1, 5));
            this.fHeapSlider = new MJSlider();
            this.fHeapSlider.setName("CurrentHeapValueSlider");
            this.fHeapSlider.setPaintLabels(true);
            this.fHeapSlider.setPaintTicks(true);
            mJPanel3.add((Component)this.fHeapSlider, (Object)cellConstraints.xyw(1, 3, 3));
            this.fHeapSpinner = new MJSpinner();
            this.fHeapSpinner.setName("CurrentHeapValueSpinner");
            mJPanel3.add((Component)this.fHeapSpinner, (Object)cellConstraints.xy(5, 3));
            mJPanel3.add((Component)new MJLabel(RESOURCE.getString("jmpp.mb.label")), (Object)cellConstraints.xy(6, 3));
            MJLabel mJLabel = new MJLabel(MessageFormat.format(RESOURCE.getString("jmpp.recommended.label"), HEAP_MAX_CUR, JavaMemPrefs.getHeapMaxDefault()));
            mJLabel.setName("HeapDefaultMessageLabel");
            mJPanel3.add((Component)mJLabel, (Object)cellConstraints.xy(3, 5));
            FormLayout formLayout2 = new FormLayout("pref, pref", "pref");
            mJPanel2 = new MJPanel((LayoutManager)formLayout2);
            CellConstraints cellConstraints2 = new CellConstraints();
            MJLabel mJLabel2 = new MJLabel(RESOURCE.getString("jmpp.info.label"), (Icon)DialogIcon.INFO_32x32.getIcon(), 0);
            mJPanel2.add((Component)mJLabel2, (Object)cellConstraints2.xy(1, 1));
            FormLayout formLayout3 = new FormLayout("pref, pref", "pref");
            mJPanel = new MJPanel((LayoutManager)formLayout3);
            CellConstraints cellConstraints3 = new CellConstraints();
            this.fWarnMsg = new MJLabel((Icon)DialogIcon.WARNING_32x32.getIcon(), 0);
            this.setWarnMsg();
            mJPanel.add((Component)this.fWarnMsg, (Object)cellConstraints3.xy(1, 1));
            if (sMemMaxMB == 0) {
                try {
                    Object object;
                    if (PlatformInfo.isLinux() || PlatformInfo.isLinux64()) {
                        object = new BufferedReader(new FileReader("/proc/meminfo"));
                        try {
                            boolean bl = false;
                            while (!bl) {
                                String string = ((BufferedReader)object).readLine();
                                if (!string.contains("MemTotal")) continue;
                                int n = string.indexOf(58);
                                string = string.substring(n + 1);
                                string = string.replace("kB", "").trim();
                                sMemMaxMB = Integer.parseInt(string) / 1024;
                                bl = true;
                            }
                            break block14;
                        }
                        finally {
                            if (object != null) {
                                ((BufferedReader)object).close();
                            }
                        }
                    }
                    if (PlatformInfo.isMacintosh()) {
                        object = ManagementFactory.getOperatingSystemMXBean();
                        if (object instanceof OperatingSystemMXBean) {
                            OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)object;
                            long l = operatingSystemMXBean.getTotalPhysicalMemorySize();
                            sMemMaxMB = Math.max((int)(l / 0x100000L), 1024);
                        } else {
                            sMemMaxMB = 1024;
                        }
                    } else if (PlatformInfo.isWindows()) {
                        object = new MatlabWorker<Double>(){

                            public Double runOnMatlabThread() throws Exception {
                                Object[] objectArray = (Object[])2.feval((String)"memory", (Object[])EMPTY, (int)2);
                                objectArray = (Object[])objectArray[1];
                                objectArray = (Object[])objectArray[1];
                                objectArray = (Object[])objectArray[0];
                                objectArray = (Object[])objectArray[2];
                                objectArray = (Object[])objectArray[1];
                                if ((objectArray = (Object[])objectArray[0])[1] instanceof double[]) {
                                    double[] dArray = (double[])objectArray[1];
                                    return dArray[0];
                                }
                                return 0.0;
                            }

                            public void runOnAWTEventDispatchThread(Double d) {
                                if (d == 0.0) {
                                    return;
                                }
                                long l = (long)d.doubleValue();
                                sMemMaxMB = (int)(l / 0x100000L);
                                boolean bl = JavaMemoryPrefsPanel.this.initSliderSpinner(sMemMaxMB);
                                mJPanel.setVisible(bl);
                            }
                        };
                        object.start();
                    }
                }
                catch (Exception exception) {
                    sMemMaxMB = 1024;
                }
            }
        }
        this.fHeapSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                int n = (Integer)jSpinner.getValue();
                mJPanel2.setVisible(n != HEAP_MAX_CUR);
                mJPanel.setVisible(n < HEAP_MIN_ALLOWED || n > JavaMemoryPrefsPanel.this.fHeapMaxAllowed);
                if (JavaMemoryPrefsPanel.this.fHeapSlider.getValue() != n) {
                    JavaMemoryPrefsPanel.this.fHeapSlider.setValue(n);
                }
            }
        });
        this.fHeapSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MJSlider mJSlider = (MJSlider)changeEvent.getSource();
                int n = mJSlider.getValue();
                JavaMemoryPrefsPanel.this.fHeapSpinner.setValue((Object)n);
            }
        });
        boolean bl = this.initSliderSpinner(sMemMaxMB);
        mJPanel2.setVisible(this.fInitHeapMax != HEAP_MAX_CUR);
        mJPanel.setVisible(bl);
        this.setLayout((LayoutManager)new MGridLayout(3, 1, 4, 4, 131072));
        this.add((Component)mJPanel3);
        this.add((Component)mJPanel2);
        this.add((Component)mJPanel);
    }

    private void setWarnMsg() {
        this.fWarnMsg.setText(MessageFormat.format(RESOURCE.getString("jmpp.warn.label"), HEAP_MIN_ALLOWED, this.fHeapMaxAllowed));
    }

    public static JavaMemoryPrefsPanel getPrefsPanel() {
        if (sPrefsPanel != null) {
            return sPrefsPanel;
        }
        return null;
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new JavaMemoryPrefsPanel();
        sPrefsPanel.setFocusable(true);
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.savePrefs();
        }
    }

    private void savePrefs() {
        JavaMemPrefs.setHeapMax(this.fHeapSlider.getValue());
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "java_heap_prefs"};
    }
}

