/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.mlservices.scc;

import com.mathworks.mlwidgets.mlservices.scc.MWSccFileListenerImpl;
import com.mathworks.mlwidgets.mlservices.scc.SccFileProvider;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.FileSystemUtils;
import com.mathworks.util.PlatformInfo;
import java.util.Hashtable;
import java.util.Map;

public class MWSccManager {
    public static final int SCC_STATUS_INVALID = -1;
    public static final int SCC_STATUS_NOTCONTROLED = 0;
    public static final int SCC_STATUS_CONTROLED = 1;
    public static final int SCC_STATUS_CHECKEDOUT = 2;
    public static final int SCC_STATUS_OUTOTHER = 4;
    public static final int SCC_STATUS_OUTEXCLUSIVE = 8;
    public static final int SCC_STATUS_OUTMUTIPLE = 16;
    public static final int SCC_STATUS_OUTOFDATE = 32;
    public static final int SCC_STATUS_DELETED = 64;
    public static final int SCC_STATUS_LOCKED = 128;
    public static final int SCC_STATUS_MERGED = 256;
    public static final int SCC_STATUS_SHARED = 512;
    public static final int SCC_STATUS_PINNED = 1024;
    public static final int SCC_STATUS_MODIFIED = 2048;
    public static final int SCC_STATUS_OUTBYUSER = 4096;
    public static final int SCC_STATUS_NOMATLABPROJECT = 36864;
    private static Map<SccFileProvider, MWSccFileListenerImpl> sSccFileProviders = new Hashtable<SccFileProvider, MWSccFileListenerImpl>();
    public static final String DEFAULT_FILE = "DEFAULT_FILE";

    private MWSccManager() {
    }

    public static MJMenu getSccMenu(SccFileProvider sccFileProvider) {
        return MWSccManager.getSccMenu(sccFileProvider, DEFAULT_FILE);
    }

    public static MJMenu getSccMenu(SccFileProvider sccFileProvider, String string) {
        MWSccFileListenerImpl mWSccFileListenerImpl = sSccFileProviders.get(sccFileProvider);
        return mWSccFileListenerImpl.getSccMenu(string);
    }

    public static void registerSccFileProvider(SccFileProvider sccFileProvider) {
        if (!sSccFileProviders.containsKey(sccFileProvider)) {
            MWSccFileListenerImpl mWSccFileListenerImpl = new MWSccFileListenerImpl(sccFileProvider);
            sSccFileProviders.put(sccFileProvider, mWSccFileListenerImpl);
            if (PlatformInfo.isWindows()) {
                sccFileProvider.installSccFileListener(mWSccFileListenerImpl);
                FileSystemUtils.getFileSystemNotifier().addFileSystemListener(mWSccFileListenerImpl.getFileSystemListener());
            }
            Prefs.addListener((PrefListener)mWSccFileListenerImpl, (String)"SourceControlSystem");
        }
    }

    public static void unregisterSccFileProvider(SccFileProvider sccFileProvider) {
        if (sSccFileProviders.containsKey(sccFileProvider)) {
            MWSccFileListenerImpl mWSccFileListenerImpl = sSccFileProviders.remove(sccFileProvider);
            if (PlatformInfo.isWindows()) {
                sccFileProvider.uinstallSccFileListener();
                FileSystemUtils.getFileSystemNotifier().removeFileSystemListener(mWSccFileListenerImpl.getFileSystemListener());
            }
            Prefs.removeListener((PrefListener)mWSccFileListenerImpl, (String)"SourceControlSystem");
        }
    }

    static void fireSccStatusChange() {
        for (SccFileProvider sccFileProvider : sSccFileProviders.keySet()) {
            sSccFileProviders.get(sccFileProvider).setStateOfSCCMenus();
        }
    }
}

