/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.colorarrayeditor;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.StyleModel;
import com.mathworks.util.DebugUtils;
import java.awt.Color;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;

final class ColorArrayTableModel
extends AbstractTableModel
implements StyleModel {
    private final List<Color> colors;
    private final Color BACKGROUND1 = UIManager.getColor("Table.background");
    private final Color BACKGROUND2 = new Color(253, 253, 244);
    private final CellStyle cellStyle = new CellStyle();

    ColorArrayTableModel(List<Color> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument colors must not be null");
        }
        this.colors = list;
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public String getColumnName(int n) {
        return Columns.values()[n].toString();
    }

    @Override
    public int getRowCount() {
        return this.colors.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        assert (n >= 0 && n < Columns.values().length) : "Column index=" + n;
        Columns columns = Columns.values()[n];
        switch (columns) {
            case COLOR: {
                return Color.class;
            }
        }
        throw new AssertionError((Object)("Column class unknown: " + n));
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        assert (this.colors != null && n >= 0 && n < this.colors.size()) : "Row index=" + n;
        assert (n2 >= 0 && n2 < Columns.values().length) : "Column index=" + n2;
        Columns columns = Columns.values()[n2];
        Color color = this.colors.get(n);
        assert (color != null);
        switch (columns) {
            case COLOR: {
                return color;
            }
        }
        assert (DebugUtils.warning((String)("Unknown value for column: " + (Object)((Object)columns))));
        return "";
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n == -1 || n2 == -1) {
            return;
        }
        assert (this.colors != null && n >= 0 && n < this.colors.size()) : "Row index=" + n;
        assert (n2 >= 0 && n2 < Columns.values().length) : "Column index=" + n2;
        Columns columns = Columns.values()[n2];
        switch (columns) {
            case COLOR: {
                Color color = (Color)object;
                this.colors.set(n, color);
                break;
            }
            default: {
                assert (DebugUtils.warning((String)("Invalid column: " + (Object)((Object)columns))));
                break;
            }
        }
    }

    public CellStyle getCellStyleAt(int n, int n2) {
        if (n % 2 == 0) {
            this.cellStyle.setBackground(this.BACKGROUND1);
        } else {
            this.cellStyle.setBackground(this.BACKGROUND2);
        }
        return this.cellStyle;
    }

    public boolean isCellStyleOn() {
        return true;
    }

    static final class Columns
    extends Enum<Columns> {
        public static final /* enum */ Columns COLOR = new Columns("Color");
        private final String name;
        private static final /* synthetic */ Columns[] $VALUES;

        public static Columns[] values() {
            return (Columns[])$VALUES.clone();
        }

        public static Columns valueOf(String string) {
            return Enum.valueOf(Columns.class, string);
        }

        private Columns(String string2) {
            assert (string2 != null);
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        static {
            $VALUES = new Columns[]{COLOR};
        }
    }
}

