/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.celleditors.color;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.ColorComboBox;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.EditingNotStoppedException;
import com.jidesoft.grid.LegacyColorCellEditor;
import com.jidesoft.validation.ValidationResult;
import com.mathworks.mlwidgets.inspector.celleditors.color.MLColorComboBox;
import com.mathworks.mlwidgets.inspector.guiutils.IMLTableCellEditor;
import com.mathworks.mlwidgets.inspector.guiutils.InvalidInput;
import com.mathworks.util.StyledColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JTable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;

public class MLColorCellEditor
extends LegacyColorCellEditor
implements IMLTableCellEditor {
    private boolean hostingComponentLostFocus;
    private MLColorComboBox comboBox;
    private final boolean allowDefaultColor;
    private final NumberFormat formatter = NumberFormat.getNumberInstance();

    public MLColorCellEditor(boolean bl) {
        this.allowDefaultColor = bl;
        this.formatter.setMaximumFractionDigits(3);
        this.formatter.setMinimumFractionDigits(3);
        this.formatter.setMinimumIntegerDigits(1);
        this.formatter.setGroupingUsed(false);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = ConverterContext.DEFAULT_CONTEXT.getName();
        ConverterContext converterContext = this.getConverterContext();
        if (converterContext != null) {
            string = converterContext.getName();
        }
        converterContext = new ConverterContext(string);
        converterContext.setUserObject(object);
        this.setConverterContext(converterContext);
        return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    public AbstractComboBox createAbstractComboBox() {
        return this.createColorComboBox();
    }

    protected ColorComboBox createColorComboBox() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MLColorCellEditor.this.colorToString(MLColorCellEditor.this.comboBox.getSelectedColor());
                if (StringUtils.isNotBlank((String)string)) {
                    MLColorCellEditor.this.comboBox.setToolTipText(string);
                } else {
                    MLColorCellEditor.this.comboBox.setToolTipText(null);
                }
            }
        };
        this.comboBox = new MLColorComboBox();
        this.comboBox.setAllowMoreColors(true);
        this.comboBox.setAllowDefaultColor(this.allowDefaultColor);
        this.comboBox.addActionListener(actionListener);
        return this.comboBox;
    }

    private String colorToString(Color color) {
        Object object;
        if (color == null) {
            return "";
        }
        if (color instanceof StyledColor && (object = (StyledColor)color).isStyle()) {
            return "";
        }
        object = color.getRGBColorComponents(null);
        assert (object != null && ((StyledColor)object).length == 3);
        StrBuilder strBuilder = new StrBuilder();
        strBuilder.append("Red=").append(this.formatter.format((double)object[0])).append(" (").append(color.getRed()).appendln(") ");
        strBuilder.append("Green=").append(this.formatter.format((double)object[1])).append(" (").append(color.getGreen()).appendln(") ");
        strBuilder.append("Blue=").append(this.formatter.format((double)object[2])).append(" (").append(color.getBlue()).appendln(") ");
        return strBuilder.toString();
    }

    public ValidationResult validate(Object object, Object object2) {
        if (object2 instanceof InvalidInput) {
            if (this.hostingComponentLostFocus) {
                return new ValidationResult(10, false, 0);
            }
            ValidationResult validationResult = new ValidationResult(10, false, this.getDefaultErrorBehavior());
            Toolkit.getDefaultToolkit().beep();
            return validationResult;
        }
        return ValidationResult.OK;
    }

    public boolean stopCellEditing() {
        boolean bl;
        assert (this.comboBox != null);
        if (this.comboBox.isPopupVisible()) {
            assert (this.comboBox.getPopupPanel() != null);
            this.comboBox.getPopupPanel().setSelectedObject(this.getComboBox().getEditor().getItem(), false);
        }
        try {
            bl = super.stopCellEditing();
        }
        catch (EditingNotStoppedException editingNotStoppedException) {
            bl = false;
        }
        if (this.hostingComponentLostFocus) {
            this.hostingComponentLostFocus = false;
            return true;
        }
        return bl;
    }

    @Override
    public void stopCellEditing(boolean bl) {
        this.hostingComponentLostFocus = bl;
        if (bl && !this.comboBox.isPopupVisible()) {
            this.stopCellEditing();
        }
    }
}

