/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.jmi.bean.UDDListener;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlwidgets.inspector.IPropertyTreeTableNode;
import com.mathworks.mlwidgets.inspector.JidePropertyTableModel;
import com.mathworks.mlwidgets.inspector.JidePropertyViewTable;
import com.mathworks.mlwidgets.inspector.NamedEditor;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mlwidgets.inspector.PropertyGroupNode;
import com.mathworks.mlwidgets.inspector.PropertyItemNode;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mlwidgets.inspector.PropertyTreeTableModel;
import com.mathworks.services.ObjectRegistry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public final class PropertyRootNode
extends PropertyItemNode {
    public static final int NO_ITEM = -1;
    private final Vector fChildrenList = new Vector();
    private ObjectRegistry fRegistry;
    private boolean fTargetHasPropertyGroups = false;
    private Timer fRefreshTimer;
    private static boolean sTestingMode = false;
    private static int REFRESHTIMERDELAY = 1000;

    public PropertyRootNode(PropertyTreeTableModel propertyTreeTableModel, JTable jTable, ObjectRegistry objectRegistry, Object[] objectArray) {
        assert (jTable != null);
        assert (objectRegistry != null);
        this.view = jTable;
        this.buildPropertyList_MatlabThread(jTable, objectRegistry, objectArray);
        this.fRegistry = objectRegistry;
        this.fRefreshTimer = new Timer(REFRESHTIMERDELAY, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PropertyRootNode.this.doRefresh();
                    }
                });
            }
        });
        this.fRefreshTimer.setRepeats(false);
        this.fRefreshTimer.setCoalesce(true);
    }

    private ObjectRegistry getRegistry() {
        return this.fRegistry;
    }

    boolean targetHasPropertyGroups() {
        return this.fTargetHasPropertyGroups;
    }

    @Override
    public void expand() {
    }

    @Override
    String getGroupName() {
        return null;
    }

    @Override
    void setGroupName(String string) {
    }

    @Override
    public PropertyCell getPropertyCell() {
        return null;
    }

    private static HashMap getGroupName_MatlabThread(UDDObject[] uDDObjectArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        HashMap hashMap = null;
        try {
            Object object = Matlab.mtFeval((String)"inspect", (Object[])new Object[]{"-getInspectorPropertyGrouping", uDDObjectArray}, (int)1);
            if (object instanceof HashMap) {
                hashMap = (HashMap)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    private PropertyGroupNode getGroupNode(String string, HashMap hashMap, HashMap hashMap2) {
        PropertyGroupNode propertyGroupNode = null;
        Object v = hashMap.get(string);
        if (v instanceof String) {
            String string2 = (String)v;
            if ((v = hashMap2.get(string2)) instanceof PropertyGroupNode) {
                propertyGroupNode = (PropertyGroupNode)v;
            } else {
                propertyGroupNode = new PropertyGroupNode(string2);
                hashMap2.put(string2, propertyGroupNode);
                this.fChildrenList.add(propertyGroupNode);
            }
        }
        return propertyGroupNode;
    }

    @Override
    public void refresh() {
        if (PropertyRootNode.isTestingMode()) {
            this.doRefresh();
        } else if (!this.fRefreshTimer.isRunning()) {
            this.fRefreshTimer.start();
        }
    }

    public void doRefresh() {
        Object[] objectArray = null;
        if (Matlab.isMatlabAvailable()) {
            objectArray = PropertyRootNode.castObjectToUDDArray(this.getTarget().getObjects());
            if (objectArray == null || objectArray.length == 0) {
                this.fRegistry.fireItemEvent(null);
                return;
            }
            if (!Arrays.equals(JidePropertyViewTable.filterOutInvalidObjects(objectArray), this.getTarget().getObjects())) {
                this.buildPropertyList_MatlabThread(this.view, this.getRegistry(), objectArray);
                ((JidePropertyTableModel)((Object)this.view.getModel())).postUpdate(objectArray);
                return;
            }
        }
        Map<PropertyItemNode, Object> map = this.getPropertyUpdateMap((UDDObject[])objectArray);
        this.updateProperties(map.keySet().toArray(new PropertyItemNode[1]), map.values().toArray(new Object[1]));
    }

    private void buildPropertyList_MatlabThread(JTable jTable, ObjectRegistry objectRegistry, Object[] objectArray) {
        assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
        boolean bl = false;
        this.fTargetHasPropertyGroups = false;
        boolean bl2 = false;
        boolean bl3 = true;
        Vector<UDDObject> vector = new Vector<UDDObject>();
        this.fRegistry = objectRegistry;
        UDDObject[] uDDObjectArray = PropertyRootNode.castObjectToUDDArray(objectArray);
        HashMap hashMap = null;
        HashMap hashMap2 = new HashMap();
        PropertyTarget propertyTarget = new PropertyTarget(objectArray, jTable, this.getRegistry(), bl);
        this.setTarget(propertyTarget);
        propertyTarget.setNode(this);
        this.removeListeners();
        this.fPropertyHash.clear();
        this.fChildrenList.clear();
        if (uDDObjectArray.length > 0) {
            hashMap = PropertyRootNode.getGroupName_MatlabThread(uDDObjectArray);
        }
        while (propertyTarget.hasMoreProperties()) {
            PropertyGroupNode propertyGroupNode;
            NamedEditor namedEditor = propertyTarget.nextProperty();
            if (namedEditor == null || namedEditor.getEditor() == null || !namedEditor.isEditable() && !bl3) continue;
            PropertyCell propertyCell = PropertyCell.makePropertyCell(jTable, propertyTarget, -1, 0, namedEditor);
            PropertyItemNode propertyItemNode = new PropertyItemNode(0, propertyCell, propertyCell.hasChildren());
            String string = propertyCell.getName();
            this.fChildrenList.add(propertyItemNode);
            this.fPropertyHash.put(string, propertyItemNode);
            if (hashMap != null && (propertyGroupNode = this.getGroupNode(string, hashMap, hashMap2)) != null) {
                propertyItemNode.setGroupName(propertyGroupNode.getName());
                bl2 = true;
            }
            if (uDDObjectArray == null) continue;
            for (int i = 0; i < uDDObjectArray.length; ++i) {
                UDDObject uDDObject;
                if (uDDObjectArray[i] == null || !(uDDObject = uDDObjectArray[i].findProperty(namedEditor.getName())).isValid()) continue;
                vector.add(uDDObjectArray[i].findProperty(namedEditor.getName()));
            }
        }
        if (bl2) {
            this.fTargetHasPropertyGroups = true;
        }
        this.setChildren(PropertyRootNode.castToAbstractTreeTableNode(this.fChildrenList.toArray()));
        this.setQueriedChildren(true);
        this.registerPropertyListeners(uDDObjectArray, vector);
    }

    @Override
    public void registerDestroyListeners(UDDObject[] uDDObjectArray) {
        for (UDDObject uDDObject : uDDObjectArray) {
            DestroyListener destroyListener = new DestroyListener(this, uDDObject, uDDObject, "ObjectBeingDestroyed");
            this.addUDDListener(destroyListener);
        }
    }

    private void addUDDListener(UDDListener uDDListener) {
        this.fUDDListeners.add(uDDListener);
    }

    @Override
    public void registerPropertyListeners(UDDObject[] uDDObjectArray, Vector<UDDObject> vector) {
        super.registerPropertyListeners(uDDObjectArray, vector);
        boolean bl = false;
        if (Matlab.isMatlabAvailable()) {
            try {
                boolean[] blArray = (boolean[])Matlab.mtFeval((String)"feature", (Object[])new Object[]{"HGUsingMatlabClasses"}, (int)1);
                bl = blArray[0];
                if (bl) {
                    boolean[] blArray2 = (boolean[])Matlab.mtFeval((String)"matlab.graphics.internal.SceneViewerListener.isRenderedMCOSGraphic", (Object[])new Object[]{uDDObjectArray}, (int)1);
                    bl = blArray2[0];
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (bl) {
            if (sSceneViewerListener == null) {
                try {
                    sSceneViewerListener = Matlab.mtFeval((String)"matlab.graphics.internal.SceneViewerListener", (Object[])new Object[]{uDDObjectArray}, (int)1);
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            } else {
                try {
                    Matlab.mtFeval((String)"init", (Object[])new Object[]{sSceneViewerListener, uDDObjectArray}, (int)0);
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                }
            }
        }
    }

    public static void setTestingMode(boolean bl) {
        sTestingMode = bl;
    }

    public static boolean isTestingMode() {
        return sTestingMode;
    }

    String getRenderedTextForTesting(String string) {
        PropertyTarget propertyTarget = this.getTarget();
        propertyTarget.resetEnumeration();
        while (propertyTarget.hasMoreProperties()) {
            NamedEditor namedEditor = propertyTarget.nextProperty();
            if (!string.equals(namedEditor.getName())) continue;
            return namedEditor.getEditor().getAsText();
        }
        return null;
    }

    void removeListeners() {
        if (sSceneViewerListener != null) {
            sSceneViewerListener = null;
        }
        if (this.fUDDListeners != null) {
            ListIterator listIterator = this.fUDDListeners.listIterator();
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                if (!(e instanceof UDDListener)) continue;
                ((UDDListener)e).dispose();
            }
            this.fUDDListeners.clear();
        }
    }

    public void setUDDListenersEnabled(boolean bl) {
        boolean bl2 = false;
        for (UDDListener uDDListener : this.fUDDListeners) {
            if (!uDDListener.isEnabled()) {
                bl2 = true;
            }
            uDDListener.setEnabled(bl);
        }
        if (bl && bl2) {
            this.doRefresh();
        }
    }

    @Override
    public void updateProperties(final PropertyItemNode[] propertyItemNodeArray, final Object[] objectArray) {
        MatlabWorker<Map<PropertyCell, IPropertyTreeTableNode[]>> matlabWorker = new MatlabWorker<Map<PropertyCell, IPropertyTreeTableNode[]>>(){

            public Map<PropertyCell, IPropertyTreeTableNode[]> runOnMatlabThread() {
                HashMap<PropertyCell, IPropertyTreeTableNode[]> hashMap = new HashMap<PropertyCell, IPropertyTreeTableNode[]>();
                if (PropertyRootNode.this.getTarget() != null) {
                    for (int i = 0; i < propertyItemNodeArray.length; ++i) {
                        PropertyCell propertyCell = propertyItemNodeArray[i].getPropertyCell();
                        PropertyRootNode.this.getTarget().setPropertyValue(propertyItemNodeArray[i], objectArray[i]);
                        if (propertyCell.getChildTarget() != null) {
                            propertyCell.getChildTarget().pullInPropertyValuesFromMatlab_MatlabThread();
                        }
                        hashMap.put(propertyCell, propertyItemNodeArray[i].getChildren());
                    }
                    return hashMap;
                }
                return null;
            }

            public void runOnAWTEventDispatchThread(Map<PropertyCell, IPropertyTreeTableNode[]> map) {
                for (PropertyCell propertyCell : map.keySet()) {
                    propertyCell.updateComponent_EventThread();
                    IPropertyTreeTableNode[] iPropertyTreeTableNodeArray = map.get(propertyCell);
                    for (int i = 0; iPropertyTreeTableNodeArray != null && i < iPropertyTreeTableNodeArray.length; ++i) {
                        iPropertyTreeTableNodeArray[i].getPropertyCell().updateComponent_EventThread();
                    }
                }
                TableModel tableModel = PropertyRootNode.this.view.getModel();
                assert (tableModel instanceof AbstractTableModel);
                ((AbstractTableModel)tableModel).fireTableDataChanged();
                if (Matlab.isMatlabAvailable()) {
                    ((JidePropertyTableModel)((Object)PropertyRootNode.this.view.getModel())).getUnderlyingModel().fireTreeTableUpdateEvent();
                }
            }
        };
        if (Matlab.isMatlabAvailable()) {
            matlabWorker.start();
        } else {
            Map map;
            try {
                map = (Map)matlabWorker.runOnMatlabThread();
            }
            catch (Exception exception) {
                return;
            }
            matlabWorker.runOnAWTEventDispatchThread((Object)map);
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getName() {
        return "root";
    }

    @Override
    public JComponent getRendererComponent() {
        return null;
    }

    @Override
    public JComponent getEditorComponent() {
        return null;
    }

    private static class DestroyListener
    extends UDDListener {
        protected PropertyRootNode fPropertyRootNode;

        protected DestroyListener(PropertyRootNode propertyRootNode, UDDObject uDDObject, UDDObject uDDObject2, String string) {
            super(uDDObject, uDDObject2, string);
            this.fPropertyRootNode = propertyRootNode;
        }

        public void execute(UDDObject uDDObject, UDDObject uDDObject2) {
            boolean bl = false;
            ObjectRegistry objectRegistry = this.fPropertyRootNode.getRegistry();
            if (objectRegistry != null && uDDObject != null) {
                Object[] objectArray = objectRegistry.getSelectedObjects();
                if (objectArray == null) {
                    return;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (Object object : objectArray) {
                    if (object.equals(uDDObject)) continue;
                    arrayList.add(object);
                }
                Object[] objectArray2 = JidePropertyViewTable.filterOutInvalidObjects(arrayList.toArray(new Object[1]));
                if (objectArray2 != null && objectArray2.length >= 1) {
                    objectRegistry.setSelected(objectArray2, true, true);
                    return;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!uDDObject.equals(objectArray[i])) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    objectRegistry.fireItemEvent(null);
                    this.fPropertyRootNode.getTarget().removePropertyListeners();
                }
            }
        }
    }
}

