/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.NamedEditor;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;

class PropertyCellEnum
extends PropertyCell
implements ActionListener {
    private MJPanel fRendererPanel;
    private MJPanel fPanel;
    private MJLabel fLabel;
    private String fValue;
    private MJPopupMenu fPopupMenu;
    private int fNItems = 0;

    PropertyCellEnum(JComponent jComponent, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        super(jComponent, propertyTarget, n, n2, namedEditor);
    }

    @Override
    MJPanel getRendererComponent() {
        if (this.fRendererPanel == null) {
            this.fRendererPanel = this.createPanel();
        }
        return this.fRendererPanel;
    }

    @Override
    MJPanel getEditorComponent() {
        return this.getRendererComponent();
    }

    @Override
    public void updateComponent_EventThread() {
        this.fValue = this.getEditor().getAsText();
        if (this.fLabel != null) {
            this.fLabel.setText(this.fValue);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        if (this.fLabel != null) {
            this.fLabel.setText(string);
            this.setEnumValue(string);
        }
    }

    private void populatePopupMenu_MatlabThread() {
        assert (NativeMatlab.nativeIsMatlabThread());
        final String[] stringArray = this.getEditor().getTags();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertyCellEnum.this.createMenuItems_EventThread(stringArray);
            }
        });
    }

    private void createMenuItems_EventThread(String[] stringArray) {
        if (this.fPopupMenu != null) {
            this.fNItems = stringArray.length;
            for (int i = 0; i < stringArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                jMenuItem.addActionListener(this);
                this.fPopupMenu.add(jMenuItem);
            }
        }
    }

    private MJPanel createPanel() {
        BorderLayout borderLayout = new BorderLayout();
        this.fPanel = new MJPanel((LayoutManager)borderLayout);
        int n = InspectorUIResources.getIconHorizontalOffset();
        String string = "";
        try {
            string = this.getEditor().getAsText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fLabel = new MJLabel(string);
        this.fLabel.setBorder(BorderFactory.createEmptyBorder(0, n, 0, 0));
        this.fPanel.add((Component)this.fLabel, (Object)"Center");
        Icon icon = InspectorUIResources.getDropDownIcon();
        MJButton mJButton = PropertyCell.createRightSideButton(icon);
        if (PlatformInfo.useWindowsXPAppearance()) {
            mJButton.setUI((ButtonUI)new BasicButtonUI());
        }
        if (this.isEditable()) {
            this.fPopupMenu = new MJPopupMenu();
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    PropertyCellEnum.this.populatePopupMenu_MatlabThread();
                }
            });
            ShowPopup showPopup = new ShowPopup();
            this.fLabel.addMouseListener((MouseListener)showPopup);
            mJButton.addMouseListener((MouseListener)showPopup);
            this.fPanel.add((Component)mJButton, (Object)"East");
        } else {
            this.fLabel.setForeground(InspectorUIResources.VALUE_DISABLED_COLOR);
        }
        this.fPanel.setOpaque(false);
        return this.fPanel;
    }

    void setEnumValue(String string) {
        if (!string.equals(this.getEditor().getAsText())) {
            if (string.equals(" -")) {
                string = "-";
            }
            this.getEditor().setAsText(string);
        }
    }

    private class ShowPopup
    extends MouseAdapter {
        private ShowPopup() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!PropertyCellEnum.this.fPopupMenu.isShowing()) {
                PropertyCellEnum.this.fPopupMenu.setPopupSize(PropertyCellEnum.this.fPanel.getWidth(), ((PropertyCellEnum)PropertyCellEnum.this).fPopupMenu.getPreferredSize().height);
                PropertyCellEnum.this.fPopupMenu.show((Component)PropertyCellEnum.this.fPanel, 0, InspectorUIResources.getCellHeight());
            }
        }
    }
}

