/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.mlwidgets.inspector.InspectorUIResources;
import com.mathworks.mlwidgets.inspector.NamedEditor;
import com.mathworks.mlwidgets.inspector.PropertyCell;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyEditor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class PropertyCellBoolean
extends PropertyCell {
    private MJPanel fRendererPanel;
    private TristateCheckBox fCheckBox;
    private JToggleButton fToggleButton;
    private final ActionListener fActionListener;
    public static final String TRUE = "On";
    public static final String FALSE = "Off";
    private volatile boolean fIgnoreMixedUpdate = false;
    private volatile boolean fLastInteractiveSetState = false;
    private final Border fToggleOnBorder = BorderFactory.createBevelBorder(1, InspectorUIResources.getButtonHighlight(), InspectorUIResources.getButtonShadow());
    private final Border fToggleOffBorder = BorderFactory.createBevelBorder(0, InspectorUIResources.getButtonHighlight(), InspectorUIResources.getButtonShadow());

    public PropertyCellBoolean(JComponent jComponent, PropertyTarget propertyTarget, int n, int n2, NamedEditor namedEditor) {
        super(jComponent, propertyTarget, n, n2, namedEditor);
        this.fActionListener = this.isEditable() ? this.createAction() : null;
    }

    @Override
    void updateComponent_EventThread() {
        if (this.fCheckBox != null) {
            this.updateCheckBox();
            if (this.fToggleButton != null) {
                this.fToggleButton.setSelected((Boolean)this.getEditor().getValue());
                Border border = (Boolean)this.getEditor().getValue() != false ? this.fToggleOnBorder : this.fToggleOffBorder;
                this.fToggleButton.setBorder(border);
                this.fToggleButton.setIcon(this.getIcon());
            }
        }
    }

    private void updateCheckBox() {
        if (!this.fIgnoreMixedUpdate && this.isMixed()) {
            this.fCheckBox.setText(InspectorUIResources.getMixedValueDisplay());
            ((TristateButtonModel)this.fCheckBox.getModel()).setMultiState(true);
            this.fCheckBox.setSelected(true);
        } else {
            ((TristateButtonModel)this.fCheckBox.getModel()).setMultiState(false);
            Object object = this.getEditor().getValue();
            if (object instanceof Boolean) {
                if (!this.isMixed() && this.fLastInteractiveSetState == (Boolean)object) {
                    this.fIgnoreMixedUpdate = false;
                }
                this.fCheckBox.setSelected((Boolean)object);
            }
            this.fCheckBox.setText(this.getEditor().getAsText());
        }
    }

    @Override
    MJPanel getRendererComponent() {
        if (this.fRendererPanel == null) {
            this.fRendererPanel = this.createRendererPanel();
        }
        return this.fRendererPanel;
    }

    @Override
    MJPanel getEditorComponent() {
        return this.getRendererComponent();
    }

    private void updateWidgets(boolean bl) {
        if (this.fTarget.getObjects().length > 1) {
            this.fLastInteractiveSetState = bl;
            this.fIgnoreMixedUpdate = true;
        }
        this.getEditor().setValue(bl);
        if (this.fCheckBox != null && this.fToggleButton != null) {
            this.fCheckBox.setSelected(bl);
            this.fCheckBox.setText(bl ? TRUE : FALSE);
            this.fToggleButton.setSelected(bl);
            this.fToggleButton.setIcon(this.getIcon());
            this.getEditor().setValue(bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private ActionListener createAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JToggleButton) {
                    PropertyCellBoolean.this.updateWidgets(((AbstractButton)object).isSelected());
                }
            }
        };
    }

    private MJPanel createRendererPanel() {
        this.fCheckBox = new TristateCheckBox();
        this.fCheckBox.setOpaque(false);
        if (this.isEditable()) {
            this.fCheckBox.addActionListener(this.fActionListener);
        } else {
            this.fCheckBox.setEnabled(false);
        }
        this.updateCheckBox();
        return this.createMainPanelWithNoIcon(this.getEditor(), (JComponent)((Object)this.fCheckBox));
    }

    @Override
    protected AbstractButton createButton(PropertyEditor propertyEditor) {
        Icon icon = this.getIcon();
        if (icon == null) {
            return null;
        }
        this.fToggleButton = new MJToggleButton();
        this.fToggleButton.setIcon(icon);
        this.fToggleButton.setFocusPainted(false);
        Dimension dimension = new Dimension(icon.getIconWidth() + 6, icon.getIconHeight());
        this.fToggleButton.setOpaque(false);
        this.fToggleButton.setPreferredSize(dimension);
        Object object = this.getEditor().getValue();
        if (object instanceof Boolean) {
            Border border = (Boolean)object != false ? this.fToggleOnBorder : this.fToggleOffBorder;
            this.fToggleButton.setBorder(border);
        }
        if (this.isEditable()) {
            this.fToggleButton.addActionListener(this.fActionListener);
        } else {
            this.fToggleButton.setEnabled(false);
        }
        return this.fToggleButton;
    }

    private static class TristateCheckBox
    extends MJCheckBox {
        private TristateCheckBox() {
            this.setModel(new TristateButtonModel());
            super.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    TristateCheckBox.this.setSelected(!TristateCheckBox.this.isSelected());
                    TristateCheckBox.this.fireActionPerformed(new ActionEvent(this, 1001, TristateCheckBox.this.getText(), System.currentTimeMillis(), 0));
                }
            });
        }
    }

    private static class TristateButtonModel
    extends JToggleButton.ToggleButtonModel {
        private void setMultiState(boolean bl) {
            super.setArmed(bl);
            super.setPressed(bl);
        }

        private TristateButtonModel() {
            this.setEnabled(true);
        }

        @Override
        public void setArmed(boolean bl) {
        }

        @Override
        public void setPressed(boolean bl) {
        }
    }
}

