/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.importtool.AbstractColumnMetaData;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.DateCell;
import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.NonNumericReplacementRule;
import com.mathworks.mlwidgets.importtool.SpreadsheetDataSection;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportUIState;
import com.mathworks.mlwidgets.importtool.SpreadsheetTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.Log;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class WorksheetTableModel
extends AbstractFileTableModel {
    private String fSheetName;
    private String fWorkbookName;
    static final int UNINITIALIZED_CLASS = -1;
    private volatile Object fSpreadsheet;
    private List<String> fDateFormats = null;
    public static int DEFAULT_TEST_ROW_COUNT = 10;
    public static int DEFAULT_TEST_COLUMN_COUNT = 20;

    @Override
    protected Object getParser() {
        return this.fSpreadsheet;
    }

    @Override
    protected synchronized void rebuild(final int n, final int n2) {
        if (this.fColumnMetaData != null) {
            this.fColumnMetaData.setValid(false);
        }
        MatlabWorker<double[]> matlabWorker = new MatlabWorker<double[]>(){

            public double[] runOnMatlabThread() {
                try {
                    return (double[])Matlab.mtFeval((String)"GetSheetDimensions", (Object[])new Object[]{WorksheetTableModel.this.fSpreadsheet, WorksheetTableModel.this.fSheetName}, (int)1);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(double[] dArray) {
                if (dArray == null) {
                    return;
                }
                if (dArray.length != 4) {
                    return;
                }
                int[] nArray = new int[]{(int)dArray[1], (int)dArray[3]};
                int[] nArray2 = new int[]{(int)dArray[0] - 1, (int)dArray[2] - 1};
                if (WorksheetTableModel.this.fDimensions[0] != nArray[0] || WorksheetTableModel.this.fDimensions[1] != nArray[1] || WorksheetTableModel.this.fStartCell[0] != nArray2[0] || WorksheetTableModel.this.fStartCell[1] != nArray2[1]) {
                    WorksheetTableModel.this.fDimensions[0] = 0;
                    WorksheetTableModel.this.fDimensions[1] = 0;
                    WorksheetTableModel.this.fStartCell[0] = 0;
                    WorksheetTableModel.this.fStartCell[1] = 0;
                    WorksheetTableModel.this.fTableStructureInitialized = false;
                    WorksheetTableModel.this.fTemporaryBlockCache = null;
                    WorksheetTableModel.this.fInitialSelection = null;
                } else {
                    WorksheetTableModel.this.fTemporaryBlockCache = WorksheetTableModel.this.getClosestSpreadsheetDataSection(n, n2);
                }
                WorksheetTableModel.this.fCurrentMatlabBlock = null;
                WorksheetTableModel.this.fBlockCache.clear();
                Point point = WorksheetTableModel.this.getPointForIndices(n < 0 ? 0 : n, n2 < 0 ? 0 : n2);
                WorksheetTableModel.this.requestValueFromMatlab(point.x + 1, point.y + 1, WorksheetTableModel.this.ROWBLOCKSIZE, WorksheetTableModel.this.COLUMNBLOCKSIZE);
            }
        };
        matlabWorker.start();
    }

    synchronized SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType getColumnTargetType(int n) {
        if (this.fColumnMetaData == null) {
            return null;
        }
        return ((ColumnMetaData)this.fColumnMetaData).getColumnTargetTypes(this.fTargetType).get(n);
    }

    SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] getSelectedColumnVectorTargetTypes(int[] nArray) {
        ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> arrayList = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getColumnTargetType(nArray[i]));
        }
        return arrayList.toArray(new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[1]);
    }

    private SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] getSelectedColumnVectorTargetTypes(String string) {
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        if (list.isEmpty()) {
            return new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[0];
        }
        int[] nArray = list.get(0);
        ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> arrayList = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>();
        for (int i = nArray[1] - 1; i <= nArray[3] - 1; ++i) {
            arrayList.add(this.getColumnTargetType(i));
        }
        return arrayList.toArray(new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[1]);
    }

    private Object[][] getSelectedColumnTargetTypes(String[][] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Object[][] objectArray = new Object[stringArray.length][stringArray[0].length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] spreadsheetColumnTargetTypeArray;
                objectArray[i][j] = spreadsheetColumnTargetTypeArray = this.getSelectedColumnVectorTargetTypes(stringArray[i][j]);
            }
        }
        return objectArray;
    }

    public List<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> getDefaultColumnTargetTypes() {
        return ((ColumnMetaData)this.fColumnMetaData).getColumnTargetTypes(this.fTargetType);
    }

    public synchronized void setColumnTargetType(int n, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
        if (this.fColumnMetaData == null) {
            return;
        }
        this.reset();
        ((ColumnMetaData)this.fColumnMetaData).setColumnTargetType(n, spreadsheetColumnTargetType);
    }

    @Override
    synchronized boolean isUntreatedAt(int n, int n2) {
        if (this.fColumnMetaData == null) {
            return super.isUntreatedAt(n, n2);
        }
        List<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> list = ((ColumnMetaData)this.fColumnMetaData).getColumnTargetTypes(this.fTargetType);
        if (this.fTargetType.usesColumnTypes() && list.get(n2) == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY) {
            return false;
        }
        if (this.fTargetType.isCellArray()) {
            return false;
        }
        boolean bl = !this.fTargetType.isMatrix() && list.get(n2).isDatetimeArray();
        return super.isUntreatedAt(n, n2, bl);
    }

    @Override
    protected synchronized void requestValueFromMatlab(int n, int n2, int n3, int n4) {
        SpreadsheetDataSection spreadsheetDataSection;
        Point point = this.getPointForIndices(n, n2);
        if (!point.equals(this.fCurrentMatlabBlock) && ((spreadsheetDataSection = (SpreadsheetDataSection)this.fBlockCache.get(point)) == null || spreadsheetDataSection.isRulesDirty())) {
            this.fCurrentMatlabBlock = point;
            this.makeCallToMatlab(new MatlabWorksheetUpdateRequest(this.fSpreadsheet, this.fTargetType, this.fColumnMetaData, this.fSheetName, this.fRules, n, n3, n2, n4));
        }
    }

    protected WorksheetTableModel(Object object, String string, String string2, List<WorksheetRule> list) {
        this.fSpreadsheet = object;
        this.fSheetName = string2;
        this.fRules = list;
        this.fWorkbookName = string;
        this.fBlockCache = new LinkedHashMap<Point, SpreadsheetDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, SpreadsheetDataSection> entry) {
                return this.size() > 10;
            }
        };
        if (Matlab.isMatlabAvailable()) {
            this.requestValueFromMatlab(1, 1, this.ROWBLOCKSIZE, this.COLUMNBLOCKSIZE);
        }
    }

    WorksheetTableModel(SpreadsheetDataSection spreadsheetDataSection, String string, String string2) {
        this.fSheetName = string2;
        this.fBlockCache = new LinkedHashMap<Point, SpreadsheetDataSection>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Point, SpreadsheetDataSection> entry) {
                return this.size() > 10;
            }
        };
        this.fBlockCache.put(new Point(0, 0), spreadsheetDataSection);
        this.fWorkbookName = string;
    }

    String getWorkbookName() {
        return this.fWorkbookName;
    }

    void setWorkbookName(String string) {
        this.fWorkbookName = string;
    }

    void populateSpreadsheetImportUIState(SpreadsheetImportUIState spreadsheetImportUIState, String string, int[] nArray) {
        ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> arrayList = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>();
        for (int n : nArray) {
            arrayList.add(this.getColumnTargetType(n));
        }
        spreadsheetImportUIState.setSelectedColumnTargetTypes(arrayList);
        spreadsheetImportUIState.setFile(new File(this.fWorkbookName));
        spreadsheetImportUIState.setDimensions(this.fDimensions);
        spreadsheetImportUIState.setRules(this.fRules);
        spreadsheetImportUIState.setDateFormats(this.fDateFormats);
        spreadsheetImportUIState.setSheetName(this.fSheetName);
        spreadsheetImportUIState.setIsRangeDefaultSelection(this.isRangeDefaultSelection(string));
    }

    private boolean hasExcelDates() {
        int n = this.getRowCount();
        n = n < DEFAULT_TEST_ROW_COUNT ? n : DEFAULT_TEST_ROW_COUNT;
        int n2 = this.getColumnCount();
        n2 = n2 < DEFAULT_TEST_COLUMN_COUNT ? n2 : DEFAULT_TEST_COLUMN_COUNT;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                Object object = this.getValueAt(i, j);
                if (!(object instanceof DateCell)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<WorksheetRule> getDefaultWorksheetRuleList() {
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        arrayList.add(new NonNumericReplacementRule());
        return arrayList;
    }

    @Override
    Object[] importData(String[] stringArray, String[] stringArray2, String string, String[][] stringArray3, int n, Component component) throws Exception {
        ArrayList<WorksheetRule> arrayList = this.fRules;
        if (n > LARGECELLCOUNT) {
            boolean bl = false;
            for (WorksheetRule worksheetRule : this.fRules) {
                if (!worksheetRule.codeGenUsesDates()) continue;
                bl = true;
                break;
            }
            if (bl) {
                String string2 = ImportToolUtils.getResourceString("messages.largeimport");
                int n2 = MJOptionPane.showConfirmDialog(null, (Object)string2, (String)"Import Tool", (int)1, (int)3);
                if (n2 == 2) {
                    return null;
                }
                if (n2 == 0) {
                    arrayList = new ArrayList<WorksheetRule>();
                    for (WorksheetRule worksheetRule : this.fRules) {
                        if (worksheetRule.codeGenUsesDates()) continue;
                        arrayList.add(worksheetRule);
                    }
                }
            }
        }
        Object[][] objectArray = this.getSelectedColumnTargetTypes(stringArray3);
        return (Object[])Matlab.mtFeval((String)"ImportData", (Object[])new Object[]{this.fSpreadsheet, stringArray, string, this.fSheetName, stringArray3, arrayList.toArray(), objectArray, stringArray2}, (int)2);
    }

    private boolean isRangeDefaultSelection(String string) {
        int[] nArray;
        if (string == null) {
            return false;
        }
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        return list.size() == 1 && (nArray = list.get(0)) != null && this.fInitialSelection != null && nArray.length == 4 && this.fInitialSelection.length == 4 && nArray[0] == this.fInitialSelection[0] + 1 && nArray[1] == this.fInitialSelection[1] + 1 && nArray[2] == this.fInitialSelection[2] + 1 && nArray[3] == this.fInitialSelection[3] + 1;
    }

    void generateMatlabFunctionCommentHeader(String[][] stringArray, String[] stringArray2, String string, GeneratedCode generatedCode) {
        if (stringArray != null && stringArray.length >= 1 && stringArray[0].length >= 1) {
            int n;
            generatedCode.addCode("\n");
            generatedCode.addCode("%   DATA = ");
            generatedCode.addCode(string.toUpperCase());
            generatedCode.addCode("(FILE) ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilearg"));
            generatedCode.addCode("\n%\n");
            generatedCode.addCode("%   DATA = ");
            generatedCode.addCode(string.toUpperCase());
            generatedCode.addCode("(FILE,SHEET) ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilesheetarg"));
            generatedCode.addCode("\n%\n");
            generatedCode.addCode("%   DATA = ");
            generatedCode.addCode(string.toUpperCase());
            generatedCode.addCode("(FILE,SHEET,RANGE) ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilesheetrangearg"));
            if (this.fRules != null && !this.fRules.isEmpty()) {
                generatedCode.addCode("\n%\n");
                for (n = 0; n < this.fRules.size(); ++n) {
                    if (n % 2 == 0) {
                        generatedCode.addCode("%\t");
                    } else {
                        generatedCode.addCode("%   ");
                    }
                    generatedCode.addCode(((WorksheetRule)this.fRules.get(n)).getSummaryComment());
                    generatedCode.addCode("\n");
                }
            }
            n = stringArray.length > 1 || stringArray[0].length > 1 ? (stringArray2.length >= 2 ? 1 : 0) : (stringArray2.length >= 2 && this.isColumnExcludeRules() ? 1 : 0);
            generatedCode.addCode("%\n% ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.example"));
            generatedCode.addCode("\r");
            if (n == 0) {
                if (stringArray2.length > 1) {
                    generatedCode.addCode("%   data = ");
                } else {
                    generatedCode.addCode("%   ");
                    generatedCode.addCode(stringArray2[0]);
                    generatedCode.addCode(" = ");
                }
            } else {
                generatedCode.addCode("%   ");
            }
            generatedCode.addCode(string);
            generatedCode.addCode("('");
            int n2 = this.fWorkbookName.lastIndexOf(File.separator);
            if (n2 >= 0) {
                generatedCode.addCode(this.fWorkbookName.substring(n2 + 1).replaceAll("'", "''"));
            } else {
                generatedCode.addCode(this.fWorkbookName.replaceAll("'", "''"));
            }
            generatedCode.addCode("','");
            generatedCode.addCode(this.fSheetName);
            generatedCode.addCode("','");
            generatedCode.addCode(stringArray[0][0]);
            generatedCode.addCode("');\n");
            if (stringArray2.length > 1 && n == 0) {
                int n3 = stringArray2.length > 7 ? 7 : stringArray2.length;
                for (int i = 0; i < n3; ++i) {
                    if (i % 2 == 0) {
                        generatedCode.addCode("%\t");
                    } else {
                        generatedCode.addCode("%   ");
                    }
                    generatedCode.addCode(stringArray2[i]);
                    generatedCode.addCode(" = data(:,");
                    generatedCode.addCode(Integer.toString(i + 1));
                    generatedCode.addCode(");\n");
                }
                if (n3 < stringArray2.length) {
                    generatedCode.addCode("%    ...\n");
                }
            }
            generatedCode.addCode("%\n%   ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.seealso"));
            generatedCode.addCode("\n");
            generatedCode.addCode(WorksheetTableModel.getTimeStampComment());
            generatedCode.addCode("\n");
        }
    }

    private static String getTimeStampComment() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(ImportToolUtils.getResourceString("codeGen.timestamp"));
        stringBuilder.append(" ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        stringBuilder.append(simpleDateFormat.format(date));
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    @Override
    protected void makeCallToMatlab(AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest) {
        final MatlabWorksheetUpdateRequest matlabWorksheetUpdateRequest = (MatlabWorksheetUpdateRequest)matlabUpdateRequest;
        if (this.fMatlabBusy) {
            this.setQueuedItem(matlabWorksheetUpdateRequest);
        } else {
            this.fMatlabBusy = true;
            this.setQueuedItem(null);
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object[] objectArray;
                        Object object;
                        if (WorksheetTableModel.this.fDimensions[0] == 0 && WorksheetTableModel.this.fDimensions[1] == 0) {
                            object = (double[])Matlab.mtFeval((String)"GetSheetDimensions", (Object[])new Object[]{matlabWorksheetUpdateRequest.iSpreadsheetObject, matlabWorksheetUpdateRequest.iSheetName}, (int)1);
                            if (object != null && ((Object)object).length >= 4) {
                                objectArray = (double[])Matlab.mtFeval((String)"GetInitialSelection", (Object[])new Object[]{matlabWorksheetUpdateRequest.iSpreadsheetObject, matlabWorksheetUpdateRequest.iSheetName}, (int)1);
                                if (objectArray != null && objectArray.length == 4) {
                                    WorksheetTableModel.this.setInitialSelection((int)objectArray[0] - 1, (int)objectArray[1] - 1, (int)objectArray[2] - 1, (int)objectArray[3] - 1);
                                }
                                WorksheetTableModel.this.setSheetDimensions((int)object[1], (int)object[3], (int)object[0] - 1, (int)object[2] - 1);
                            }
                            if (WorksheetTableModel.this.fDimensions[0] == 0 || WorksheetTableModel.this.fDimensions[1] == 0) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        WorksheetTableModel.this.matlabCallback(null);
                                    }
                                });
                                return;
                            }
                        }
                        if (WorksheetTableModel.this.fDimensions[0] < AbstractFileTableModel.NONWINDOWED_SHEETSIZE[0] && WorksheetTableModel.this.fDimensions[1] < AbstractFileTableModel.NONWINDOWED_SHEETSIZE[1]) {
                            matlabWorksheetUpdateRequest.iStartRow = 1;
                            matlabWorksheetUpdateRequest.iStartCol = 1;
                            matlabWorksheetUpdateRequest.iEndCol = WorksheetTableModel.this.fDimensions[1];
                            matlabWorksheetUpdateRequest.iEndRow = WorksheetTableModel.this.fDimensions[0];
                            WorksheetTableModel.this.ROWBLOCKSIZE = WorksheetTableModel.this.fDimensions[0];
                            WorksheetTableModel.this.COLUMNBLOCKSIZE = WorksheetTableModel.this.fDimensions[1];
                        }
                        object = matlabWorksheetUpdateRequest.mtFeval();
                        objectArray = WorksheetTableModel.this;
                        synchronized (WorksheetTableModel.this) {
                            if (WorksheetTableModel.this.fColumnMetaData == null || !WorksheetTableModel.this.fColumnMetaData.isValid()) {
                                WorksheetTableModel.this.setColumnMetaData(matlabWorksheetUpdateRequest.getColumnMetaData());
                            }
                            // ** MonitorExit[var2_3 /* !! */ ] (shouldn't be in output)
                            objectArray = (String[])Matlab.mtFeval((String)"GetColumnDateFormats", (Object[])new Object[]{matlabWorksheetUpdateRequest.iSpreadsheetObject, matlabWorksheetUpdateRequest.iSheetName}, (int)1);
                            if (objectArray != null) {
                                WorksheetTableModel.this.fDateFormats = Arrays.asList(objectArray);
                            }
                            SwingUtilities.invokeLater(new Runnable((SpreadsheetDataSection)object){
                                final /* synthetic */ SpreadsheetDataSection val$spreadsheetDataSection;
                                {
                                    this.val$spreadsheetDataSection = spreadsheetDataSection;
                                }

                                @Override
                                public void run() {
                                    WorksheetTableModel.this.matlabCallback(this.val$spreadsheetDataSection);
                                }
                            });
                        }
                    }
                    catch (Exception exception) {
                        Log.log((String)exception.toString());
                    }
                }
            });
        }
    }

    private boolean isDatetimeOrTimeSeriesColumn(int n) {
        SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType = this.getColumnTargetType(n);
        return !this.fTargetType.isMatrix() && (spreadsheetColumnTargetType == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.DATETIME_ARRAY || spreadsheetColumnTargetType == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.TIME_ARRAY);
    }

    @Override
    Object getParsedValueAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection != null) {
            boolean bl = this.isDatetimeOrTimeSeriesColumn(n2);
            return spreadsheetDataSection.getParsedValueAt(n, n2, bl);
        }
        return null;
    }

    @Override
    Object getReplacedValueAt(int n, int n2) {
        SpreadsheetDataSection spreadsheetDataSection = this.getValueDataSection(n, n2);
        if (spreadsheetDataSection != null) {
            if (this.isDatetimeOrTimeSeriesColumn(n2)) {
                return "NaT";
            }
            return spreadsheetDataSection.getReplacedValueAt(n, n2);
        }
        return null;
    }

    void cleanup() {
        if (this.fBlockCache != null) {
            this.fBlockCache.clear();
        }
    }

    public static class ColumnMetaData
    extends AbstractColumnMetaData {
        private volatile SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] iDefaultColumnTargetTypes;
        protected volatile List<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> iColumnTargetTypes = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>();
        private String iSheetName;

        public ColumnMetaData() {
        }

        public ColumnMetaData(Object object, String string, ImportClient.TargetType targetType) {
            this(object, string, -1, targetType);
        }

        public ColumnMetaData(Object object, String string, int n, ImportClient.TargetType targetType) {
            assert (!Matlab.isMatlabAvailable() || NativeMatlab.nativeIsMatlabThread());
            this.iSheetName = string;
            try {
                int n2;
                boolean[] blArray = (boolean[])Matlab.mtFeval((String)"GetNumericContainerColumns", (Object[])new Object[]{object, string}, (int)1);
                this.iDefaultColumnTargetTypes = new SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[blArray.length];
                for (n2 = 0; n2 < this.iDefaultColumnTargetTypes.length; ++n2) {
                    this.iDefaultColumnTargetTypes[n2] = blArray[n2] ? SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY : SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY;
                }
                this.iColumnTargetTypes = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>(Arrays.asList(this.iDefaultColumnTargetTypes));
                n2 = n;
                if (n < 0) {
                    double[] dArray = (double[])Matlab.mtFeval((String)"GetDefaultHeaderRow", (Object[])new Object[]{object, string}, (int)1);
                    n2 = dArray != null && dArray.length == 1 ? (int)dArray[0] - 1 : 0;
                }
                this.updateDefaultColumnVariableNames(object, n2, targetType);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            this.setValid(true);
        }

        protected Object feval(String string, Object[] objectArray, int n) throws Exception {
            return Matlab.mtFeval((String)string, (Object[])objectArray, (int)n);
        }

        public SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType[] getDefaultColumnTargetTypes() {
            return this.iDefaultColumnTargetTypes;
        }

        @Override
        public String[] updateDefaultColumnVariableNames(Object object, int n, ImportClient.TargetType targetType) {
            this.setHeaderRow(n);
            if (n >= 0) {
                try {
                    this.fDefaultColumnVariableNames = (String[])this.feval("getDefaultColumnNames", new Object[]{object, this.iSheetName, this.getHeaderRow() + 1, targetType.getAvoidShadowLevel()}, 1);
                }
                catch (Exception exception) {
                    this.fDefaultColumnVariableNames = null;
                }
            } else {
                this.fDefaultColumnVariableNames = new String[this.iDefaultColumnTargetTypes.length];
                for (int i = 0; i < this.fDefaultColumnVariableNames.length; ++i) {
                    this.fDefaultColumnVariableNames[i] = "VarName" + Integer.toString(i);
                }
            }
            return this.fDefaultColumnVariableNames;
        }

        public List<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> getColumnTargetTypes(ImportClient.TargetType targetType) {
            ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> arrayList = new ArrayList<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType>(this.iColumnTargetTypes);
            block7: for (int i = 0; i < this.iColumnTargetTypes.size(); ++i) {
                switch (targetType) {
                    case TIMESERIES: {
                        if (arrayList.get(i) == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.TIME_ARRAY) continue block7;
                        arrayList.set(i, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY);
                        continue block7;
                    }
                    case MATRIX: {
                        arrayList.set(i, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY);
                        continue block7;
                    }
                    case CELLARRAY: {
                        arrayList.set(i, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY);
                        continue block7;
                    }
                    case COLUMNVECTORS: {
                        if (arrayList.get(i) != SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.TIME_ARRAY) continue block7;
                        arrayList.set(i, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY);
                        continue block7;
                    }
                    case DATASET: 
                    case TABLE: {
                        if (arrayList.get(i) != SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.TIME_ARRAY) continue block7;
                        arrayList.set(i, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY);
                    }
                }
            }
            return arrayList;
        }

        public void setColumnTargetType(int n, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
            this.iColumnTargetTypes.set(n, spreadsheetColumnTargetType);
        }
    }

    static class MatlabWorksheetUpdateRequest
    extends AbstractFileTableModel.MatlabUpdateRequest {
        private Object iSpreadsheetObject;
        private String iSheetName;
        private ImportClient.TargetType iTarget;

        MatlabWorksheetUpdateRequest(Object object, ImportClient.TargetType targetType, AbstractColumnMetaData abstractColumnMetaData, String string, List<WorksheetRule> list, int n, int n2, int n3, int n4) {
            this.iSpreadsheetObject = object;
            this.iSheetName = string;
            this.iStartRow = n;
            this.iEndRow = n2;
            this.iStartCol = n3;
            this.iEndCol = n4;
            this.iRules = list;
            this.iColumnMetaData = abstractColumnMetaData;
            this.iTarget = targetType;
        }

        @Override
        protected SpreadsheetDataSection mtFeval() {
            Object[] objectArray;
            List<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> list;
            Object[] objectArray2;
            Object[] objectArray3;
            Object[] objectArray4;
            Object[] objectArray5 = new Object[]{this.iSpreadsheetObject, this.iSheetName, ImportToolUtils.toExcelRange(this.iStartRow, this.iEndRow, this.iStartCol, this.iEndCol)};
            try {
                objectArray4 = (Object[])Matlab.mtFeval((String)"Read", (Object[])objectArray5, (int)3);
            }
            catch (Exception exception) {
                return null;
            }
            if (this.iColumnMetaData == null) {
                this.iColumnMetaData = new ColumnMetaData(this.iSpreadsheetObject, this.iSheetName, this.iTarget);
            } else if (!this.iColumnMetaData.isValid()) {
                int n = this.iColumnMetaData.getHeaderRow();
                this.iColumnMetaData = new ColumnMetaData(this.iSpreadsheetObject, this.iSheetName, n, this.iTarget);
            }
            double[] dArray = (double[])objectArray4[0];
            if (objectArray4[1] instanceof String[]) {
                objectArray3 = (String[])objectArray4[1];
                int n = objectArray3.length;
                objectArray2 = new Object[n];
                System.arraycopy(objectArray3, 0, objectArray2, 0, n);
            } else {
                objectArray2 = (Object[])objectArray4[1];
            }
            objectArray3 = (String[])objectArray4[2];
            DateCell.addDateCells(objectArray2, objectArray3);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            if (this.iColumnMetaData != null) {
                list = ((ColumnMetaData)this.iColumnMetaData).getColumnTargetTypes(this.iTarget);
                for (int i = 0; i < list.size(); ++i) {
                    objectArray = list.get(i);
                    if (objectArray == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY) {
                        arrayList.add(i - this.iStartCol + 1);
                    }
                    if (objectArray != SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.DATETIME_ARRAY) continue;
                    arrayList2.add(i - this.iStartCol + 1);
                }
            }
            list = AbstractFileTableModel.getRuleResults(objectArray2, dArray, (String[])objectArray3, this.iRules, this.iEndRow - this.iStartRow + 1, arrayList, arrayList2);
            Class[] classArray = (Class[])list.getFirst();
            objectArray = (Object[])list.getSecond();
            return new SpreadsheetDataSection(this.iStartRow - 1, this.iStartCol - 1, this.iEndRow - 1, this.iEndCol - 1, objectArray2, dArray, (String[])objectArray3, classArray, objectArray);
        }
    }

    static interface WorksheetCachedDataListener {
        public void worksheetCachedDataChanged(EventObject var1);
    }

    static class MatlabRunnable
    implements Runnable {
        private AbstractFileTableModel.MatlabUpdateRequest iQueuedUpdateRequest;
        private WorksheetTableModel iReqester;

        MatlabRunnable(WorksheetTableModel worksheetTableModel, AbstractFileTableModel.MatlabUpdateRequest matlabUpdateRequest) {
            this.iReqester = worksheetTableModel;
            this.iQueuedUpdateRequest = matlabUpdateRequest;
        }

        @Override
        public void run() {
            try {
                final SpreadsheetDataSection spreadsheetDataSection = this.iQueuedUpdateRequest.mtFeval();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MatlabRunnable.this.iReqester.matlabCallback(spreadsheetDataSection);
                    }
                });
            }
            catch (Exception exception) {
                Log.log((String)exception.toString());
            }
        }
    }
}

