/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.WorksheetRuleListener;
import com.mathworks.mlwidgets.importtool.WorksheetRulePanel;
import com.mathworks.mlwidgets.importtool.WorksheetRulePanelComboBox;
import com.mathworks.mwswing.MJComboBox;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;

public abstract class WorksheetRule
implements Cloneable {
    static String AbstractSpreadsheetPath = "internal.matlab.importtool.AbstractSpreadsheet";
    private static Color ROW_EXCLUDE_COLOR = new Color(205, 181, 215, 255);
    private static Color COLUMN_EXCLUDE_COLOR = new Color(205, 181, 215, 255);
    private static Color CONVERT_COLOR = new Color(196, 215, 155, 255);
    private static Color REPLACE_COLOR = new Color(255, 239, 176, 255);
    private static List<Integer> datetimeColumnVectorPositions = new ArrayList<Integer>();
    private static List<Integer> numericColumnVectorPositions = new ArrayList<Integer>();
    private static boolean sOnlyDatetimesSelected = false;

    public static void setColor(String string, int n, int n2, int n3) {
        WorksheetRule.setColor(string, n, n2, n3, 255);
    }

    public static void setColor(String string, int n, int n2, int n3, int n4) {
        WorksheetRule.setColor(string, new Color(n, n2, n3, n4));
    }

    public static void setColor(String string, Color color) {
        String string2 = string.toUpperCase();
        if (string2.equals("ROW_EXCLUDE_COLOR")) {
            ROW_EXCLUDE_COLOR = color;
        }
        if (string2.equals("COLUMN_EXCLUDE_COLOR")) {
            COLUMN_EXCLUDE_COLOR = color;
        }
        if (string2.equals("CONVERT_COLOR")) {
            CONVERT_COLOR = color;
        }
        if (string2.equals("REPLACE_COLOR")) {
            REPLACE_COLOR = color;
        }
    }

    public static Color getColor(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("ROW_EXCLUDE_COLOR")) {
            return ROW_EXCLUDE_COLOR;
        }
        if (string2.equals("COLUMN_EXCLUDE_COLOR")) {
            return COLUMN_EXCLUDE_COLOR;
        }
        if (string2.equals("CONVERT_COLOR")) {
            return CONVERT_COLOR;
        }
        if (string2.equals("REPLACE_COLOR")) {
            return REPLACE_COLOR;
        }
        return null;
    }

    public boolean isRowExcludeType() {
        return this.getType() == RuleType.ROWEXCLUDE;
    }

    public boolean isColumnExcludeType() {
        return this.getType() == RuleType.COLUMNEXCLUDE;
    }

    public boolean isReplaceType() {
        return this.getType() == RuleType.REPLACE;
    }

    public boolean isConvertType() {
        return this.getType() == RuleType.CONVERT || this.getType() == RuleType.CONVERTTEXT;
    }

    public abstract RuleType getType();

    public abstract String getApplyFcn();

    public String getStringApplyFcn() {
        return this.getApplyFcn();
    }

    public abstract String getSummaryComment();

    public abstract void generateMatlabCode(List<WorksheetRule> var1, GeneratedCode var2);

    public boolean codeGenUsesDates() {
        return false;
    }

    public boolean codeGenNeedsNaNConvert() {
        return false;
    }

    Component getEditor() {
        return null;
    }

    static boolean isRuleFollowedByDateRule(List<WorksheetRule> list, WorksheetRule worksheetRule) {
        return !datetimeColumnVectorPositions.isEmpty();
    }

    public static void setColumnVectorPositions(List<Integer> list, List<Integer> list2) {
        datetimeColumnVectorPositions = list;
        numericColumnVectorPositions = list2;
    }

    public static List<Integer> getDatetimeColumnVectorPositions() {
        return datetimeColumnVectorPositions;
    }

    public static List<Integer> getNumericColumnVectorPositions() {
        return numericColumnVectorPositions;
    }

    public static void setOnlyDatetimesSelected(boolean bl) {
        sOnlyDatetimesSelected = bl;
    }

    public static boolean isOnlyDatetimesSelected() {
        return sOnlyDatetimesSelected;
    }

    static boolean rulesNeedNaNConvert(List<WorksheetRule> list) {
        for (WorksheetRule worksheetRule : list) {
            if (!worksheetRule.codeGenNeedsNaNConvert()) continue;
            return true;
        }
        return false;
    }

    public abstract Object clone();

    void addWorksheetRuleListener(WorksheetRuleListener worksheetRuleListener) {
    }

    void removeWorksheetRuleListener(WorksheetRuleListener worksheetRuleListener) {
    }

    static class TargetType {
        private String fString;

        TargetType(String string) {
            this.fString = string;
        }

        public String toString() {
            return this.fString;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TargetType)) {
                return false;
            }
            if (this.fString == null) {
                return object.toString() == null;
            }
            return this.fString.equals(object.toString());
        }
    }

    public static enum RuleType {
        ROWEXCLUDE(ImportToolUtils.getResourceString("RuleType.excluderows"), 0),
        COLUMNEXCLUDE(ImportToolUtils.getResourceString("RuleType.excludecols"), 1),
        REPLACE(ImportToolUtils.getResourceString("RuleType.replacecells"), 2),
        CONVERT(ImportToolUtils.getResourceString("RuleType.convertcells"), 3),
        CONVERTTEXT("Convert Text", 3);

        private final String iTypeIdentifier;
        private final int iIDent;

        private RuleType(String string2, int n2) {
            this.iTypeIdentifier = string2;
            this.iIDent = n2;
        }

        public String toString() {
            return this.iTypeIdentifier;
        }

        public Color getColor() {
            switch (this.iIDent) {
                case 0: {
                    return ROW_EXCLUDE_COLOR;
                }
                case 1: {
                    return COLUMN_EXCLUDE_COLOR;
                }
                case 2: {
                    return REPLACE_COLOR;
                }
                case 3: {
                    return CONVERT_COLOR;
                }
            }
            return new Color(0, 0, 0, 0);
        }

        JComboBox createRuleTargetCombo(List<WorksheetRule> list) {
            WorksheetRulePanelComboBox worksheetRulePanelComboBox;
            switch (this) {
                case REPLACE: {
                    worksheetRulePanelComboBox = new WorksheetRulePanelComboBox();
                    ((JComboBox)((Object)worksheetRulePanelComboBox)).setUI((ComboBoxUI)PlainComboBoxUI.createUI((JComponent)((Object)worksheetRulePanelComboBox)));
                    ((JComponent)((Object)worksheetRulePanelComboBox)).setBorder(null);
                    for (WorksheetRule worksheetRule : list) {
                        if (worksheetRule.toString() == null) continue;
                        ((JComboBox)((Object)worksheetRulePanelComboBox)).addItem(worksheetRule);
                    }
                    break;
                }
                default: {
                    worksheetRulePanelComboBox = new MJComboBox();
                    for (WorksheetRule worksheetRule : list) {
                        ((JComboBox)((Object)worksheetRulePanelComboBox)).addItem(worksheetRule);
                    }
                }
            }
            ((Component)((Object)worksheetRulePanelComboBox)).setName("WorksheetRulePanel:RuleTargetComboBox");
            ((JComboBox)((Object)worksheetRulePanelComboBox)).setUI((ComboBoxUI)WorksheetRulePanel.PlainComboBoxUI.createUI((JComponent)((Object)worksheetRulePanelComboBox)));
            ((JComponent)((Object)worksheetRulePanelComboBox)).setBorder(null);
            return worksheetRulePanelComboBox;
        }

        private static class PlainComboBoxUI
        extends BasicComboBoxUI {
            private PlainComboBoxUI() {
            }

            public static ComponentUI createUI(JComponent jComponent) {
                return new PlainComboBoxUI();
            }
        }
    }
}

