/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportClient;
import com.mathworks.mlwidgets.importtool.TargetTypeDropDownButton;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetTable;
import com.mathworks.mlwidgets.importtool.popuplist.EditablePopupList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTable;

public class SpreadsheetTableHeaderRenderer
extends VariableHeaderRenderer {
    private TargetTypeDropDownButton fTargetTypeViewTSDropDownButton;
    private TargetTypeDropDownButton fTargetTypeEditTSDropDownButton;
    private SpreadsheetImportDataHeader fLastEditedImportDataHeader;
    private int fLastItemListColumn = -1;
    private SpreadsheetColumnTargetType[] fColumnTargetTypes;
    private int fTargetTypeHoverColumn = -1;
    private boolean fShowTargetTypes = true;

    public SpreadsheetTableHeaderRenderer(WorksheetTable worksheetTable) {
        super((JTable)((Object)worksheetTable));
        this.getVarNameLabel().setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.getVarNameEditorTextField().setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.fTargetTypeViewTSDropDownButton = new TargetTypeDropDownButton(worksheetTable.getTableHeader());
        this.fTargetTypeEditTSDropDownButton = new TargetTypeDropDownButton(worksheetTable.getTableHeader());
        this.getPanel().add((Component)((Object)this.fTargetTypeViewTSDropDownButton));
        this.getEditorPanel().add((Component)((Object)this.fTargetTypeEditTSDropDownButton));
    }

    @Override
    protected void updatePanelLayout() {
        super.updatePanelLayout();
        if (this.fShowTargetTypes) {
            this.getPanel().add((Component)((Object)this.fTargetTypeViewTSDropDownButton));
            this.getEditorPanel().add((Component)((Object)this.fTargetTypeEditTSDropDownButton));
            this.getPanel().validate();
            this.getEditorPanel().validate();
        }
    }

    public boolean getShowTargetTypes() {
        return this.fShowTargetTypes;
    }

    public void setShowTargetTypes(ImportClient.TargetType targetType, List<SpreadsheetColumnTargetType> list) {
        this.fShowTargetTypes = targetType.usesColumnTypes();
        for (int i = 0; i < this.getTable().getColumnCount(); ++i) {
            SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetImportDataHeader)this.getTable().getColumnModel().getColumn(i).getHeaderValue();
            if (list != null && i < list.size()) {
                spreadsheetImportDataHeader.setColumnTarget(list.get(i));
                continue;
            }
            spreadsheetImportDataHeader.setColumnTarget(SpreadsheetColumnTargetType.getDefaultColumnTargetType(targetType));
        }
        this.fColumnTargetTypes = SpreadsheetColumnTargetType.getColumnTargetTypes(targetType);
        this.updatePanelLayout();
    }

    public void showListItemPopup(int n) {
        this.updateDataTypeViewTSDropDownButton(n);
        if (this.fColumnTargetTypes == null) {
            this.fColumnTargetTypes = SpreadsheetColumnTargetType.getColumnTargetTypes(((ImportTable)((Object)this.getTable())).getTargetType());
        }
        this.fTargetTypeViewTSDropDownButton.showListItemPopup(n, this.fColumnTargetTypes);
        this.fLastItemListColumn = n;
    }

    private void updateDataTypeViewTSDropDownButton(int n) {
        SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetImportDataHeader)this.getTable().getColumnModel().getColumn(n).getHeaderValue();
        this.fTargetTypeViewTSDropDownButton.removeAllItems();
        this.fTargetTypeViewTSDropDownButton.addItem(spreadsheetImportDataHeader.getColumnTarget().toString());
        this.fTargetTypeViewTSDropDownButton.setText(spreadsheetImportDataHeader.getColumnTarget().toString());
        this.fTargetTypeViewTSDropDownButton.validate();
    }

    public void hideListItemPopup() {
        this.fTargetTypeViewTSDropDownButton.hideListItem();
        this.fLastItemListColumn = -1;
    }

    public int getLastItemListColumn() {
        return this.fLastItemListColumn;
    }

    public boolean clickInListPopup(Point point) {
        EditablePopupList editablePopupList = this.fTargetTypeViewTSDropDownButton.getPopupList();
        if (editablePopupList != null && editablePopupList.isVisible()) {
            return editablePopupList.containsScreenPoint(point);
        }
        return false;
    }

    public Rectangle getTargetTypeDropDownBounds(int n, Object object) {
        if (!this.fShowTargetTypes) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle = this.getTable().getTableHeader().getHeaderRect(n);
        this.getPanel().setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.getTable(), object, false, false, 0, n);
        this.getPanel().getLayout().layoutContainer((Container)this.getPanel());
        return this.fTargetTypeViewTSDropDownButton.getBounds();
    }

    @Override
    public boolean isSelectionArea(Point point, int n, Object object) {
        Rectangle rectangle = this.getTable().getTableHeader().getHeaderRect(n);
        this.getPanel().setSize(new Dimension(rectangle.width, rectangle.height));
        this.getTableCellRendererComponent(this.getTable(), object, false, false, 0, n);
        this.getPanel().getLayout().layoutContainer((Container)this.getPanel());
        Rectangle rectangle2 = this.fTargetTypeViewTSDropDownButton.getBounds();
        Rectangle rectangle3 = this.getVarNameLabel().getBounds();
        return !rectangle3.contains(point) && !rectangle2.contains(point);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof SpreadsheetImportDataHeader) {
            SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetImportDataHeader)object;
            this.fTargetTypeViewTSDropDownButton.removeAllItems();
            this.fTargetTypeViewTSDropDownButton.addItem(spreadsheetImportDataHeader.getColumnTarget().toString());
            this.fTargetTypeViewTSDropDownButton.setText(spreadsheetImportDataHeader.getColumnTarget().toString());
        }
        if (n2 == this.fTargetTypeViewTSDropDownButton.getPopupColumn()) {
            this.fTargetTypeViewTSDropDownButton.listVisibilityChanged(true);
            this.fTargetTypeEditTSDropDownButton.listVisibilityChanged(true);
        } else {
            this.fTargetTypeViewTSDropDownButton.listVisibilityChanged(false);
            this.fTargetTypeEditTSDropDownButton.listVisibilityChanged(false);
        }
        if (this.fTargetTypeHoverColumn == n2) {
            this.fTargetTypeViewTSDropDownButton.setBackground(Color.WHITE);
            this.fTargetTypeViewTSDropDownButton.setBorder(this.fBevelBorder);
        } else {
            this.fTargetTypeViewTSDropDownButton.setBackground(this.getTable().isColumnSelected(n2) ? this.fRowHeaderColorSelected : this.fRowHeaderColorUnselected);
            this.fTargetTypeViewTSDropDownButton.setBorder(null);
        }
        this.getPanel().revalidate();
        return this.getPanel();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        if (object instanceof SpreadsheetImportDataHeader) {
            SpreadsheetImportDataHeader spreadsheetImportDataHeader = (SpreadsheetImportDataHeader)object;
            this.fTargetTypeEditTSDropDownButton.removeAllItems();
            this.fTargetTypeEditTSDropDownButton.addItem(spreadsheetImportDataHeader.getColumnTarget().toString());
            this.fTargetTypeEditTSDropDownButton.setText(spreadsheetImportDataHeader.getColumnTarget().toString());
            this.fLastEditedImportDataHeader = (SpreadsheetImportDataHeader)object;
            return this.getEditorPanel();
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return new SpreadsheetImportDataHeader(this.fLastEditedImportDataHeader.getColumn(), this.getVarNameEditorTextField().getText(), this.fLastEditedImportDataHeader.getColumnTarget());
    }

    @Override
    protected void setLabelState(boolean bl) {
        super.setLabelState(bl);
        if (bl) {
            this.fTargetTypeViewTSDropDownButton.setBackground(this.getPanel().getBackground());
            this.fTargetTypeEditTSDropDownButton.setBackground(this.getPanel().getBackground());
        } else {
            this.fTargetTypeViewTSDropDownButton.setBackground(new Color(250, 250, 250));
            this.fTargetTypeEditTSDropDownButton.setBackground(new Color(250, 250, 250));
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    public void setTargetTypeHoverColumn(int n) {
        this.fTargetTypeHoverColumn = n;
    }

    public int getTargetTypeHoverColumn() {
        return this.fTargetTypeHoverColumn;
    }

    public static SpreadsheetColumnTargetType[] getSupportedColumnTargetTypes() {
        return new SpreadsheetColumnTargetType[]{SpreadsheetColumnTargetType.CELL_ARRAY, SpreadsheetColumnTargetType.NUMERIC_ARRAY, SpreadsheetColumnTargetType.DATETIME_ARRAY, SpreadsheetColumnTargetType.TIME_ARRAY};
    }

    public static class SpreadsheetImportDataHeader
    extends VariableHeaderRenderer.ImportDataHeader {
        SpreadsheetColumnTargetType iColumnTarget = SpreadsheetColumnTargetType.CELL_ARRAY;

        public SpreadsheetImportDataHeader(int n, String string, SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
            super(n, string);
            this.iColumnTarget = spreadsheetColumnTargetType;
        }

        public SpreadsheetColumnTargetType getColumnTarget() {
            return this.iColumnTarget;
        }

        public void setColumnTarget(SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
            this.iColumnTarget = spreadsheetColumnTargetType;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof SpreadsheetImportDataHeader) || !super.equals(object)) {
                return false;
            }
            if (this.iColumnTarget == null) {
                return this.getColumnTarget() == null;
            }
            return this.iColumnTarget.equals((Object)((SpreadsheetImportDataHeader)object).getColumnTarget());
        }

        @Override
        public int hashCode() {
            int n = super.hashCode();
            if (this.iColumnTarget != null) {
                n += 10000 * this.iColumnTarget.hashCode();
            }
            return n;
        }
    }

    public static enum SpreadsheetColumnTargetType {
        CELL_ARRAY("targettype.cellarrays"),
        NUMERIC_ARRAY("targettype.numericarrays"),
        DATETIME_ARRAY("targettype.datetimearrays"),
        TIME_ARRAY("targettype.timearrays");

        private String fName = "";
        private String fDescription = "";
        private String fHeader = "";
        private String fID = "";

        private SpreadsheetColumnTargetType(String string2) {
            this.fID = string2;
            this.fName = ImportToolUtils.getResourceString(this.fID);
            this.fDescription = ImportToolUtils.getResourceString(this.fID + "description");
            this.fHeader = ImportToolUtils.getResourceString(this.fID + "header");
        }

        public String toString() {
            return this.fName;
        }

        public String getID() {
            return this.fID;
        }

        public String getDescription() {
            return this.fDescription;
        }

        public String getHeader() {
            return this.fHeader;
        }

        public boolean isCellArray() {
            return this.equals((Object)CELL_ARRAY);
        }

        public boolean isNumericArray() {
            return this.equals((Object)NUMERIC_ARRAY);
        }

        public boolean isTimeArray() {
            return this.equals((Object)TIME_ARRAY);
        }

        public boolean isDatetimeArray() {
            return this.equals((Object)DATETIME_ARRAY);
        }

        public static SpreadsheetColumnTargetType getDefaultColumnTargetType(ImportClient.TargetType targetType) {
            return NUMERIC_ARRAY;
        }

        public static SpreadsheetColumnTargetType[] getColumnTargetTypes(ImportClient.TargetType targetType) {
            switch (targetType) {
                case COLUMNVECTORS: 
                case DATASET: 
                case TABLE: {
                    if (SpreadsheetImportClient.isBasicMode()) {
                        return new SpreadsheetColumnTargetType[]{NUMERIC_ARRAY, CELL_ARRAY};
                    }
                    return new SpreadsheetColumnTargetType[]{NUMERIC_ARRAY, DATETIME_ARRAY, CELL_ARRAY};
                }
                case TIMESERIES: {
                    return new SpreadsheetColumnTargetType[]{NUMERIC_ARRAY, TIME_ARRAY};
                }
            }
            return new SpreadsheetColumnTargetType[0];
        }
    }
}

