/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportToolGroup;
import com.mathworks.mlwidgets.importtool.TextFileTableModel;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindClientRegistry;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindEvent;
import com.mathworks.widgets.find.FindParentListener;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;

public class ImportToolFind
implements FindClientInterface {
    private int fFindOptions = 0;
    private String fSearchText = "";
    private TextTable fTextTableObj;

    public ImportToolFind(TextTable textTable) {
        this.fTextTableObj = textTable;
    }

    public void addFindParentListener(FindParentListener findParentListener) {
    }

    public void bringForward() {
        Container container;
        Desktop desktop = Desktop.getContainingDesktop((Component)((Object)this.fTextTableObj));
        if (!desktop.isClientShowing((Component)(container = SwingUtilities.getAncestorOfClass(ImportClient.class, (Component)((Object)this.fTextTableObj))))) {
            desktop.setClientSelected((Component)container, true);
        } else if (!desktop.isClientSelected((Component)container)) {
            MJFrame mJFrame = MJFrame.getFrame((Component)container);
            if (mJFrame == null) {
                if (desktop.isGroupShowing(SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME)) {
                    mJFrame = MJFrame.getFrame((Component)desktop.getGroupContainer(SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME));
                    desktop.groupToFront(SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
                } else if (desktop.hasMainFrame()) {
                    mJFrame = desktop.getMainFrame();
                }
            }
            if (desktop.isGroupShowing(SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME)) {
                desktop.groupToFront(SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME);
            }
            if (mJFrame != null && mJFrame.getState() == 1) {
                mJFrame.setState(0);
            }
            if (mJFrame != null && !mJFrame.isVisible()) {
                mJFrame.setVisible(true);
            }
            desktop.toFront((Component)container);
        }
    }

    public void findBack(FindEvent findEvent) {
        this.find(false, findEvent);
    }

    public void findForward(FindEvent findEvent) {
        this.find(true, findEvent);
    }

    public void find(final boolean bl, FindEvent findEvent) {
        int n;
        this.fFindOptions = findEvent.getOptions();
        final boolean bl2 = (this.fFindOptions & 1) != 0;
        final boolean bl3 = (this.fFindOptions & 4) != 0;
        final boolean bl4 = (this.fFindOptions & 2) != 0;
        final boolean bl5 = (this.fFindOptions & 0x10) != 0;
        final int[] nArray = this.fTextTableObj.getSelectedColumns();
        List<int[]> list = this.fTextTableObj.getSelectedRowsAfterRules();
        final int[] nArray2 = new int[list.size() * 2];
        if (!list.isEmpty()) {
            n = 0;
            for (int[] nArray3 : list) {
                nArray2[n] = nArray3[0] + 1;
                nArray2[n + 1] = nArray3[1] + 1;
                n += 2;
            }
        }
        n = 0;
        while (n < nArray.length) {
            int n2 = n++;
            nArray[n2] = nArray[n2] + 1;
        }
        this.fSearchText = findEvent.getFindString();
        final TextFileTableModel textFileTableModel = (TextFileTableModel)this.fTextTableObj.getModel();
        if (this.fSearchText != null) {
            Iterator<Object> iterator = new MatlabWorker<List<double[]>>(){

                public List<double[]> runOnMatlabThread() {
                    return textFileTableModel.find(ImportToolFind.this.fSearchText, bl2, bl3, bl4, bl5, ImportToolFind.this.fTextTableObj.getFocusedRow() + 1, ImportToolFind.this.fTextTableObj.getFocusedCol() + 1, nArray2, nArray, bl);
                }

                public void runOnAWTEventDispatchThread(List<double[]> list) {
                    if (!list.isEmpty()) {
                        double[] dArray = list.get(0);
                        double[] dArray2 = list.get(1);
                        if (dArray[0] >= 0.5 && dArray2[0] >= 0.5) {
                            ImportToolFind.this.fTextTableObj.checkIfScrollingRequired((int)dArray[0] - 1, (int)dArray2[0] - 1, false);
                            ImportToolFind.this.fTextTableObj.setFocusedRow((int)dArray[0] - 1);
                            ImportToolFind.this.fTextTableObj.setFocusedCol((int)dArray2[0] - 1);
                            if (nArray.length <= 1 && nArray2[0] == nArray2[1]) {
                                ImportToolFind.this.fTextTableObj.getSelectionModel().setSelectionInterval(ImportToolFind.this.fTextTableObj.getFocusedRow(), ImportToolFind.this.fTextTableObj.getFocusedRow());
                                ImportToolFind.this.fTextTableObj.getColumnModel().getSelectionModel().setSelectionInterval(ImportToolFind.this.fTextTableObj.getFocusedCol(), ImportToolFind.this.fTextTableObj.getFocusedCol());
                                ImportToolFind.this.fTextTableObj.repaint();
                            } else {
                                ImportToolFind.this.fTextTableObj.repaint();
                            }
                        } else {
                            MJUtilities.beep();
                        }
                    }
                }
            };
            iterator.start();
        }
    }

    public void removeFindParentListener(FindParentListener findParentListener) {
    }

    public void replace(FindEvent findEvent) {
    }

    public void replaceAll(FindEvent findEvent) {
    }

    public Component getInvoker() {
        return this.fTextTableObj;
    }

    void invokeFindDialog() {
        FindDialog.invoke((FindClientInterface)this, (String)this.getSelectedText(), (int)this.fFindOptions);
    }

    String getSelectedText() {
        return this.fSearchText;
    }

    public void registerWithFindDialog() {
        File file = this.fTextTableObj.getTextFileTableModelObj().getFile();
        String string = file.getName();
        String[] stringArray = new String[]{ImportToolUtils.getResourceString("find.LookinName") + " (" + string + ")"};
        FindClientRegistry.register((String)"ImportTool", (FindClientInterface)this, (String[])stringArray, (boolean)false, (boolean)true);
    }

    public static void unregisterClient() {
        Desktop desktop = MatlabDesktopServices.getDesktop();
        if (desktop.getGroupMembers(SpreadsheetImportToolGroup.DEFAULT_GROUP_NAME).length == 0) {
            FindClientRegistry.unregister((String)"ImportTool");
        }
    }
}

