/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.OpenBrowserStrategy;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class MatlabOpenInSystemBrowserStrategy
implements OpenBrowserStrategy {
    @Override
    public void openUrl(Url url) {
        if (Matlab.isMatlabAvailable()) {
            final String string = "web('" + url.toString() + "','-browser')";
            Matlab.whenMatlabReady((Runnable)new Runnable(){

                @Override
                public void run() {
                    MatlabOpenInSystemBrowserStrategy.this.doMatlabEval(string);
                }
            });
        } else {
            URI uRI = (URI)new UriTransformer().transformUrl(url);
            if (uRI != null) {
                try {
                    Desktop.getDesktop().browse(uRI);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized void doMatlabEval(String string) {
        new Matlab().evalConsoleOutput(string);
    }

    private static class UriTransformer
    extends UrlTransformer<URI> {
        private UriTransformer() {
        }

        protected URI transformWebUrl(WebUrl webUrl) {
            try {
                return webUrl.toURL().toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        protected URI transformFileUrl(FileUrl fileUrl) {
            return fileUrl.getFile().toURI();
        }

        protected URI transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
            return null;
        }
    }
}

