/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.services.FontPrefs;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import java.util.Locale;

public enum LanguageLocale {
    ENGLISH("en", false, null),
    JAPANESE("ja_JP", false, "MS UI Gothic"),
    SIMPLIFIED_CHINESE("zh_CN", true, "SimSun"),
    KOREAN("ko_KR", true, "SimSun");

    private String fLocaleString;
    private boolean fRequiresTerritory;
    private String fPreferredFontName;

    private LanguageLocale(String string2, boolean bl, String string3) {
        this.fLocaleString = string2;
        this.fRequiresTerritory = bl;
        this.fPreferredFontName = string3;
    }

    public String getLocaleString() {
        return this.fLocaleString;
    }

    public String getFontFamily(String string) {
        if (PlatformInfo.isWindows() && this.fPreferredFontName != null && string.equals(FontPrefs.DEFAULT_CUSTOM_FONT.getName())) {
            return this.fPreferredFontName;
        }
        return string;
    }

    public String getLanguage() {
        return this.fLocaleString.substring(0, 2);
    }

    public String getTerritory() {
        switch (this) {
            case ENGLISH: {
                return null;
            }
        }
        return this.fLocaleString.substring(3, 5);
    }

    public Locale getLocale() {
        return this.fRequiresTerritory ? new Locale(this.getLanguage(), this.getTerritory()) : new Locale(this.getLanguage());
    }

    public Locale getLocaleForLangLocaleString() {
        return LanguageUtils.createLocaleForLangLocaleString((String)this.fLocaleString);
    }

    public boolean isEnglish() {
        return this.equals((Object)ENGLISH);
    }

    private boolean isSupported(String string, String string2) {
        return this.fRequiresTerritory ? this.getLanguage().equalsIgnoreCase(string) && this.getTerritory().equalsIgnoreCase(string2) : this.getLanguage().equalsIgnoreCase(string);
    }

    public static boolean isSupported(Locale locale) {
        for (LanguageLocale languageLocale : LanguageLocale.values()) {
            if (!languageLocale.isSupported(locale.getLanguage(), locale.getCountry())) continue;
            return true;
        }
        return false;
    }

    public static LanguageLocale getSupportedLanguageLocale(Locale locale) {
        if (locale == null) {
            return ENGLISH;
        }
        for (LanguageLocale languageLocale : LanguageLocale.values()) {
            if (!languageLocale.isSupported(locale.getLanguage(), locale.getCountry())) continue;
            return languageLocale;
        }
        return ENGLISH;
    }

    public static LanguageLocale getSupportedLanguageLocale(String string) {
        return string == null ? ENGLISH : LanguageLocale.getSupportedLanguageLocale(LanguageUtils.createLocaleForLangLocaleString((String)string));
    }

    public static LanguageLocale getSupportedLanguageLocale(String string, String string2) {
        if (string == null || string.length() == 0) {
            return ENGLISH;
        }
        if (string2 == null || string2.length() == 0) {
            return LanguageLocale.getSupportedLanguageLocale(string);
        }
        return LanguageLocale.getSupportedLanguageLocale(new Locale(string, string2));
    }

    public static LanguageLocale fromLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        for (LanguageLocale languageLocale : LanguageLocale.values()) {
            Locale locale2 = languageLocale.getLocaleForLangLocaleString();
            if (!locale2.equals(locale) && !locale2.getLanguage().equals(locale.getLanguage())) continue;
            return languageLocale;
        }
        return null;
    }
}

