/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.BrowserCreationException;
import com.mathworks.html.BrowserSettings;
import com.mathworks.html.DummyHtmlComponent;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumFactory;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.DummyHtmlComponentPanelBuilder;
import com.mathworks.mlwidgets.html.DummyMatlabHtmlActions;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentAdapter;
import com.mathworks.mlwidgets.html.HtmlComponentCreationException;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.Platform;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class HtmlComponentFactory {
    private static final HtmlComponentType DEFAULT_TYPE = HtmlComponentFactory.getDefaultType();
    static final String TYPE_PREF = "HtmlComponent.DefaultType.R2014b";
    private static final String BROWSER_PROPERTIES_PREF = "HtmlComponent.BrowserProperties";
    private static final Pattern RH5_PATTERN = Pattern.compile("\\d+");
    private static final Pattern SUSE_VERSION = Pattern.compile("VERSION\\s*=\\s*(\\d+)");
    private static final Pattern SUSE_PATCH = Pattern.compile("PATCHLEVEL\\s*=\\s*(\\d+)");

    private static HtmlComponentType getDefaultType() {
        return PlatformInfo.isLinux() ? HtmlComponentType.HTMLRENDERER : HtmlComponentType.CHROMIUM;
    }

    private HtmlComponentFactory() {
    }

    public static String[] getClassNames() {
        return new String[0];
    }

    public static HtmlComponent buildHtmlComponent(HtmlComponentType ... htmlComponentTypeArray) {
        try {
            return HtmlComponentFactory.buildHtmlComponent(true, htmlComponentTypeArray);
        }
        catch (HtmlComponentCreationException htmlComponentCreationException) {
            assert (false) : "When requesting a fallback, we should always create a browser.";
            throw new RuntimeException(htmlComponentCreationException);
        }
    }

    public static HtmlComponent buildHtmlComponentWithoutFallback(HtmlComponentType ... htmlComponentTypeArray) throws HtmlComponentCreationException {
        return HtmlComponentFactory.buildHtmlComponent(false, htmlComponentTypeArray);
    }

    private static HtmlComponent buildHtmlComponent(boolean bl, HtmlComponentType[] htmlComponentTypeArray) throws HtmlComponentCreationException {
        List<HtmlComponentType> list = HtmlComponentFactory.getTypesToTry(bl, htmlComponentTypeArray);
        if (list.isEmpty()) {
            throw new HtmlComponentCreationException(HtmlComponentFactory.getUnsupportedTypeMap(Arrays.asList(htmlComponentTypeArray), list));
        }
        try {
            HtmlComponent htmlComponent = HtmlComponentFactory.createBrowserForTypes(list);
            htmlComponent.getComponent().setName("HtmlComponent");
            return htmlComponent;
        }
        catch (HtmlComponentCreationException htmlComponentCreationException) {
            htmlComponentCreationException.addCauses(HtmlComponentFactory.getUnsupportedTypeMap(Arrays.asList(htmlComponentTypeArray), list));
            throw htmlComponentCreationException;
        }
    }

    private static Map<HtmlComponentType, BrowserCreationException> getUnsupportedTypeMap(Collection<HtmlComponentType> collection, Collection<HtmlComponentType> collection2) {
        EnumSet<HtmlComponentType> enumSet = EnumSet.copyOf(collection);
        enumSet.removeAll(collection2);
        enumSet.remove((Object)HtmlComponentType.FOLLOW_PREFERENCE);
        EnumMap<HtmlComponentType, BrowserCreationException> enumMap = new EnumMap<HtmlComponentType, BrowserCreationException>(HtmlComponentType.class);
        for (HtmlComponentType htmlComponentType : enumSet) {
            enumMap.put(htmlComponentType, new BrowserCreationException(BrowserCreationException.Reason.UNSUPPORTED_PLATFORM, null));
        }
        return enumMap;
    }

    private static HtmlComponent createBrowserForTypes(List<HtmlComponentType> list) throws HtmlComponentCreationException {
        EnumMap<HtmlComponentType, BrowserCreationException> enumMap = new EnumMap<HtmlComponentType, BrowserCreationException>(HtmlComponentType.class);
        for (HtmlComponentType htmlComponentType : list) {
            try {
                return HtmlComponentFactory.buildHtmlComponentForType(htmlComponentType);
            }
            catch (BrowserCreationException browserCreationException) {
                enumMap.put(htmlComponentType, browserCreationException);
            }
        }
        throw new HtmlComponentCreationException(enumMap);
    }

    private static List<HtmlComponentType> getTypesToTry(boolean bl, HtmlComponentType ... htmlComponentTypeArray) {
        if (htmlComponentTypeArray == null || htmlComponentTypeArray.length == 0) {
            htmlComponentTypeArray = new HtmlComponentType[]{HtmlComponentType.FOLLOW_PREFERENCE};
        }
        LinkedList<HtmlComponentType> linkedList = new LinkedList<HtmlComponentType>();
        linkedList.addAll(Arrays.asList(htmlComponentTypeArray));
        if (bl) {
            linkedList.addAll(Arrays.asList(DEFAULT_TYPE, HtmlComponentType.HTMLRENDERER));
        }
        LinkedList<HtmlComponentType> linkedList2 = new LinkedList<HtmlComponentType>();
        for (HtmlComponentType htmlComponentType : linkedList) {
            HtmlComponentType htmlComponentType2 = HtmlComponentFactory.resolveType(htmlComponentType);
            if (htmlComponentType2 == null || linkedList2.contains((Object)htmlComponentType2)) continue;
            linkedList2.add(htmlComponentType2);
        }
        if (linkedList2.contains((Object)HtmlComponentType.FOLLOW_PREFERENCE)) {
            assert (false) : "The FOLLOW_PREFERENCE type should be resolved to a valid HtmlComponentType.";
            linkedList2.remove((Object)HtmlComponentType.FOLLOW_PREFERENCE);
        }
        return linkedList2;
    }

    private static HtmlComponentType resolveType(HtmlComponentType htmlComponentType) {
        if (htmlComponentType == HtmlComponentType.FOLLOW_PREFERENCE) {
            return HtmlComponentFactory.getTypeFromPrefs();
        }
        return htmlComponentType.isSupported() ? htmlComponentType : null;
    }

    private static boolean isRedHat5() {
        boolean bl = false;
        try {
            Matcher matcher;
            String string = HtmlComponentFactory.readFile("/etc/redhat-release");
            string = string.toUpperCase();
            if ((string.contains("RED HAT") || string.contains("CENTOS")) && (matcher = RH5_PATTERN.matcher(string)).find() && Integer.parseInt(matcher.group()) == 5) {
                bl = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private static boolean isSuSE11() {
        boolean bl = false;
        try {
            Matcher matcher;
            String string = HtmlComponentFactory.readFile("/etc/SuSE-release");
            string = string.toUpperCase();
            if (string.contains("SUSE") && (matcher = SUSE_VERSION.matcher(string)).find()) {
                int n;
                Matcher matcher2;
                int n2 = Integer.parseInt(matcher.group(1));
                if (n2 < 11) {
                    bl = true;
                } else if (n2 == 11 && (matcher2 = SUSE_PATCH.matcher(string)).find() && (n = Integer.parseInt(matcher2.group(1))) == 0) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private static String readFile(String string) throws IOException {
        return new Scanner(new File(string)).useDelimiter("\\A").next();
    }

    @NotNull
    private static HtmlComponent buildHtmlComponentForType(HtmlComponentType htmlComponentType) throws BrowserCreationException {
        htmlComponentType.beforeBrowserCreation();
        switch (htmlComponentType) {
            case CHROMIUM: {
                return HtmlComponentFactory.buildHtmlPanel(HtmlPanel.BrowserType.CHROMIUM);
            }
            case HTMLPANEL: {
                return HtmlComponentFactory.buildHtmlPanel(HtmlPanel.BrowserType.JXBROWSER);
            }
            case HTMLRENDERER: {
                return HtmlComponentFactory.buildHTMLRenderer(false);
            }
            case ICEBROWSER: {
                return HtmlComponentFactory.buildHTMLRenderer(true);
            }
            case DUMMY: {
                return HtmlComponentFactory.buildDummyComponent();
            }
        }
        throw new BrowserCreationException(BrowserCreationException.Reason.UNSUPPORTED_PLATFORM, null);
    }

    public static HtmlComponentType getExpectedHtmlComponentType(HtmlComponentType ... htmlComponentTypeArray) {
        return HtmlComponentFactory.getTypesToTry(true, htmlComponentTypeArray).get(0);
    }

    private static HtmlComponentType getTypeFromPrefs() {
        String string = Prefs.getStringPref((String)TYPE_PREF);
        try {
            HtmlComponentType htmlComponentType = HtmlComponentType.valueOf(string);
            return htmlComponentType == HtmlComponentType.FOLLOW_PREFERENCE ? null : htmlComponentType;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setDefaultType(String string) {
        HtmlComponentType htmlComponentType = null;
        if (string == null || string.trim().length() == 0) {
            htmlComponentType = null;
        } else {
            try {
                htmlComponentType = HtmlComponentType.valueOf(string.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception exception) {
                System.out.println("Invalid type.  Please enter one of: ");
                EnumSet<HtmlComponentType> enumSet = EnumSet.of(HtmlComponentType.HTMLPANEL, HtmlComponentType.HTMLRENDERER);
                for (HtmlComponentType htmlComponentType2 : enumSet) {
                    System.out.println("\t<strong>" + htmlComponentType2.toString() + "</strong> - uses " + htmlComponentType2.iRenderer + " for HTML rendering");
                }
            }
        }
        HtmlComponentFactory.setDefaultType(htmlComponentType);
    }

    public static void setDefaultType(HtmlComponentType htmlComponentType) {
        if (htmlComponentType == HtmlComponentType.FOLLOW_PREFERENCE) {
            throw new IllegalArgumentException("Cannot specify FOLLOW_PREFERENCE as the HTML component type to use for following the preference.");
        }
        if (htmlComponentType == null) {
            Prefs.remove((String)TYPE_PREF);
        } else {
            Prefs.setStringPref((String)TYPE_PREF, (String)htmlComponentType.toString());
        }
    }

    @NotNull
    private static HtmlComponent buildHtmlPanel(HtmlPanel.BrowserType browserType) throws BrowserCreationException {
        try {
            return MJHtmlPanel.createBrowser(browserType);
        }
        catch (Throwable throwable) {
            throw new BrowserCreationException(BrowserCreationException.Reason.INSTANTIATION_ERROR, throwable);
        }
    }

    @NotNull
    private static HtmlComponent buildHTMLRenderer(boolean bl) {
        HTMLRenderer hTMLRenderer = new HTMLRenderer(bl);
        return new HtmlComponentAdapter(hTMLRenderer);
    }

    @NotNull
    private static HtmlComponent buildDummyComponent() {
        JTextArea jTextArea = new JTextArea();
        Component component = DummyHtmlComponentPanelBuilder.buildDummyPanel(jTextArea);
        DummyHtmlComponent dummyHtmlComponent = new DummyHtmlComponent(component, (JTextComponent)jTextArea);
        dummyHtmlComponent.setActions((HtmlActions)new DummyMatlabHtmlActions());
        return dummyHtmlComponent;
    }

    public static void setBrowserProperty(String string, String string2, boolean bl) {
        if (string2 == null) {
            BrowserSettings.removeProperty((String)string);
        } else {
            BrowserSettings.setProperty((String)string, (String)string2);
        }
        if (bl) {
            HtmlComponentFactory.updateBrowserPropertyPreference(string, string2);
        }
    }

    public static void setBrowserProperty(String string, String string2) {
        HtmlComponentFactory.setBrowserProperty(string, string2, true);
    }

    private static Map<String, String> getBrowserPreferences() {
        String string = Prefs.getStringPref((String)BROWSER_PROPERTIES_PREF);
        return HtmlComponentFactory.convertBrowserPrefToMap(string);
    }

    private static void updateBrowserPropertyPreference(String string, String string2) {
        Map<String, String> map = HtmlComponentFactory.getBrowserPreferences();
        if (string2 != null) {
            map.put(string, string2);
        } else {
            map.remove(string);
        }
        String string3 = HtmlComponentFactory.convertMapToBrowserPref(map);
        Prefs.setStringPref((String)BROWSER_PROPERTIES_PREF, (String)string3);
    }

    private static Map<String, String> convertBrowserPrefToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\\|\\|")) {
                String[] stringArray2 = string2.split("(?<!\\\\)=");
                if (stringArray2.length != 2) continue;
                hashMap.put(HtmlComponentFactory.decodePrefPart(stringArray2[0]), HtmlComponentFactory.decodePrefPart(stringArray2[1]));
            }
        }
        return hashMap;
    }

    private static String convertMapToBrowserPref(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("||");
            }
            stringBuilder.append(HtmlComponentFactory.encodePrefPart(entry.getKey()));
            stringBuilder.append("=");
            stringBuilder.append(HtmlComponentFactory.encodePrefPart(entry.getValue()));
        }
        return stringBuilder.toString();
    }

    private static String decodePrefPart(String string) {
        return string.replaceAll("\\\\([=|\\\\])", "$1");
    }

    private static String encodePrefPart(String string) {
        return string.replaceAll("[=|\\\\]", "\\$1");
    }

    public static HtmlComponentType getTypeByName(String string) {
        try {
            return HtmlComponentType.valueOf(string.toUpperCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        Map<String, String> map = HtmlComponentFactory.getBrowserPreferences();
        try {
            BrowserSettings.setProperties(map, (boolean)false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class HtmlPanelConfig
    implements BrowserTypeConfig {
        private HtmlPanelConfig() {
        }

        @Override
        public void initialize() {
            File file = HtmlPanelConfig.getXulRunnerDir();
            if (file != null) {
                System.setProperty("GRE_HOME", file.getAbsolutePath());
            }
        }

        private static File getXulRunnerDir() {
            Platform platform = Platform.getPlatform();
            String string = HtmlPanelConfig.getXulRunnerPlatformDir(platform);
            if (string != null) {
                File file = new File(Matlab.matlabRoot(), "sys/jxbrowser");
                String string2 = platform.toString().toLowerCase(Locale.ENGLISH);
                String string3 = String.format("%s/xulrunner/%s", string2, string);
                return new File(file, string3);
            }
            return null;
        }

        private static String getXulRunnerPlatformDir(Platform platform) {
            switch (platform) {
                case WIN32: {
                    return "xulrunner15-windows";
                }
                case GLNXA64: {
                    return "xulrunner-linux-64";
                }
                case MACI64: {
                    return "xulrunner15-mac";
                }
                case WIN64: {
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isSupported() {
            return !PlatformInfo.isLinux64() || !HtmlComponentFactory.isRedHat5() && !HtmlComponentFactory.isSuSE11();
        }
    }

    private static class ChromiumConfig
    implements BrowserTypeConfig {
        private ChromiumConfig() {
        }

        @Override
        public void initialize() {
            if (Matlab.isMatlabAvailable()) {
                File file = new File(Matlab.matlabRoot());
                Platform platform = Platform.getPlatform();
                String string = platform.toString().toLowerCase(Locale.ENGLISH);
                String string2 = String.format("sys/jxbrowser-chromium/%s/chromium", string);
                File file2 = new File(file, string2);
                JxBrowserChromiumFactory.setChromiumDirectory((File)file2);
            }
        }

        @Override
        public boolean isSupported() {
            return !PlatformInfo.isLinux();
        }
    }

    private static interface BrowserTypeConfig {
        public void initialize();

        public boolean isSupported();
    }

    public static enum HtmlComponentType {
        CHROMIUM("JxBrowser 4, using Chromium", new ChromiumConfig()),
        HTMLPANEL("JxBrowser", new HtmlPanelConfig()),
        HTMLRENDERER("HTMLRenderer, using ICE browser", null),
        ICEBROWSER("ICE browser", null),
        FOLLOW_PREFERENCE("the browser specified by the HtmlComponent.DefaultType.R2014b preference", null),
        DUMMY("a dummy browser", null);

        private final String iRenderer;
        private final BrowserTypeConfig iConfig;
        private boolean iInitialized = false;

        private HtmlComponentType(String string2, BrowserTypeConfig browserTypeConfig) {
            this.iRenderer = string2;
            this.iConfig = browserTypeConfig;
        }

        public synchronized void beforeBrowserCreation() {
            if (this.iConfig != null && !this.iInitialized) {
                this.iConfig.initialize();
            }
            this.iInitialized = true;
        }

        boolean isSupported() {
            return this.iConfig == null || this.iConfig.isSupported();
        }
    }
}

