/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.html.CharsetDetectionStrategy;
import com.mathworks.mlwidgets.help.search.lucene.DocumentHandlerException;
import com.mathworks.mlwidgets.help.search.lucene.FileDemoHandler;
import com.mathworks.mlwidgets.help.search.lucene.LuceneIndexUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.InputSource;

public class HtmlDemoHandler
extends FileDemoHandler {
    @Override
    public String getDemoSource(String string, String string2) throws DocumentHandlerException {
        CharsetDetectionStrategy charsetDetectionStrategy;
        Charset charset;
        try {
            charset = Charset.forName(string2);
            charsetDetectionStrategy = CharsetDetectionStrategy.getAutoDetectStrategy((Charset)charset);
        }
        catch (Exception exception) {
            charsetDetectionStrategy = CharsetDetectionStrategy.getAutoDetectStrategy();
        }
        charset = charsetDetectionStrategy.getCharset(new File(string));
        if (charset != null) {
            return super.getDemoSource(string, charset.name());
        }
        return super.getDemoSource(string, string2);
    }

    @Override
    public String getDemoSource(InputStreamReader inputStreamReader) throws DocumentHandlerException {
        try {
            NekoHtmlSaxParser nekoHtmlSaxParser = new NekoHtmlSaxParser();
            nekoHtmlSaxParser.parse(new InputSource(inputStreamReader));
            return nekoHtmlSaxParser.getBody();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new DocumentHandlerException("An error occurred while parsing an HTML document", exception);
        }
    }

    private static class NekoHtmlSaxParser
    extends AbstractSAXParser {
        private StringBuilder iBodyContent = new StringBuilder();
        private static final char NBSP = '\u00a0';

        NekoHtmlSaxParser() {
            super((XMLParserConfiguration)new HTMLConfiguration());
        }

        public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
            String string = xMLString.toString().replace('\u00a0', ' ');
            if (string.length() == 0) {
                return;
            }
            this.iBodyContent.append(string);
        }

        public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
            this.appendWhiteSpaceForTag(qName.rawname);
        }

        public void endElement(QName qName, Augmentations augmentations) throws XNIException {
            this.appendWhiteSpaceForTag(qName.rawname);
        }

        private void appendWhiteSpaceForTag(String string) {
            if (LuceneIndexUtils.isSentenceBreakTag(string)) {
                this.iBodyContent.append('\n');
            } else if (LuceneIndexUtils.isWordBreakTag(string)) {
                this.iBodyContent.append(' ');
            }
        }

        private String getBody() {
            String string = this.iBodyContent.toString().trim();
            string = string.replaceAll("(\\s*\\n+\\s*)+", "\n");
            string = string.replaceAll("\\s{2,}", " ");
            return string;
        }
    }
}

