/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.util.FileUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Synonyms {
    private static final Pattern WORD_PATTERN = Pattern.compile("[^\\W_]+");
    private static final ActionListener DOCROOT_CHANGED_LISTENER;
    private static SynonymDependencyProvider sDependencyProvider;
    private static Map<String, String> sAllSynonyms;

    private Synonyms() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createSynonymMap() {
        Synonyms.setAllSynonymsMap(null);
        List<Reader> list = Synonyms.getDependencyProvider().getSynonymFiles();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Reader iOException : list) {
                Map<String, String> map = Synonyms.readSynonymFile(iOException);
                hashMap.putAll(map);
            }
            Synonyms.setAllSynonymsMap(hashMap);
        }
        catch (IOException iOException) {
            Synonyms.setAllSynonymsMap(null);
        }
        finally {
            for (Reader reader : list) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (Reader reader : list) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readSynonymFile(Reader reader) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            Object object = bufferedReader.readLine();
            while (object != null) {
                String string;
                String[] stringArray = ((String)object).split(":");
                if (stringArray.length == 2 && (string = stringArray[0].trim()).trim().length() > 0) {
                    String[] stringArray2;
                    for (String string2 : stringArray2 = stringArray[1].split(",")) {
                        if (string2.trim().length() <= 0) continue;
                        hashMap.put(string2.trim(), string);
                    }
                }
                object = bufferedReader.readLine();
            }
            object = hashMap;
            return object;
        }
    }

    private static synchronized void setAllSynonymsMap(Map<String, String> map) {
        sAllSynonyms = map == null ? Collections.emptyMap() : map;
    }

    private static synchronized String getSynonym(String string) {
        return sAllSynonyms.get(string);
    }

    public static synchronized String getAlternateSearchString(String string) {
        Matcher matcher = WORD_PATTERN.matcher(string);
        HashSet<String> hashSet = new HashSet<String>();
        while (matcher.find()) {
            hashSet.add(matcher.group());
        }
        StringBuffer stringBuffer = new StringBuffer();
        matcher.reset();
        while (matcher.find()) {
            String string2 = matcher.group();
            matcher.appendReplacement(stringBuffer, Synonyms.getReplacementForWord(string2, hashSet));
        }
        matcher.appendTail(stringBuffer);
        if (stringBuffer.toString().equals(string)) {
            return null;
        }
        return stringBuffer.toString();
    }

    private static String getReplacementForWord(String string, Set<String> set) {
        String string2 = Synonyms.getSynonym(string);
        if (string2 != null && !set.contains(string2)) {
            return string2;
        }
        return string;
    }

    public static synchronized void setDependencyProvider(SynonymDependencyProvider synonymDependencyProvider) {
        if (sDependencyProvider != null) {
            sDependencyProvider.removeHelpInfoListener(DOCROOT_CHANGED_LISTENER);
        }
        sDependencyProvider = synonymDependencyProvider;
        sDependencyProvider.addHelpInfoListener(DOCROOT_CHANGED_LISTENER);
        Synonyms.createSynonymMap();
    }

    public static synchronized SynonymDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    static {
        sDependencyProvider = null;
        sAllSynonyms = null;
        DOCROOT_CHANGED_LISTENER = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Synonyms.createSynonymMap();
            }
        };
        Synonyms.setDependencyProvider(new DefaultDependencyProvider());
    }

    private static class DefaultDependencyProvider
    implements SynonymDependencyProvider {
        private DefaultDependencyProvider() {
        }

        @Override
        public List<Reader> getSynonymFiles() {
            ArrayList<Reader> arrayList = new ArrayList<Reader>();
            String string = MLHelpServices.getDocRoot();
            File file = new File(string, "synonyms.txt");
            String string2 = HelpUtils.getAlternateLanguagePath(file.getAbsolutePath());
            if (!string2.equals(file.getAbsolutePath())) {
                DefaultDependencyProvider.addFileReader(arrayList, new File(string2));
            }
            DefaultDependencyProvider.addFileReader(arrayList, file);
            return arrayList;
        }

        private static void addFileReader(List<Reader> list, File file) {
            if (FileUtils.fileExists((File)file)) {
                try {
                    list.add(new FileReader(file));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void addHelpInfoListener(ActionListener actionListener) {
            HelpInfo.addHelpInfoChangedListener(actionListener);
        }

        @Override
        public void removeHelpInfoListener(ActionListener actionListener) {
            HelpInfo.removeHelpInfoChangedListener(actionListener);
        }
    }

    public static interface SynonymDependencyProvider {
        public List<Reader> getSynonymFiles();

        public void addHelpInfoListener(ActionListener var1);

        public void removeHelpInfoListener(ActionListener var1);
    }
}

