/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.SearchUnavailableException;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchStringParseException;

public class SearchExceptionMessageUtils {
    public static String getMapPath() {
        return MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env_csh");
    }

    public static String getErrorMessage(SearchException searchException) {
        String string = "search.general_error";
        if (searchException instanceof SearchStringParseException) {
            SearchStringParseException.Type type = ((SearchStringParseException)((Object)searchException)).getType();
            switch (type) {
                case MISMATCHED_QUOTES: {
                    string = "search.error_mismatched_quotes";
                    break;
                }
                case TOO_FEW_CHARS: {
                    string = "search.error_too_few_chars";
                    break;
                }
                case TOO_FEW_NONWILDCARD_CHARS: {
                    string = "search.error_too_few_nonwildcard_chars";
                    break;
                }
                case WILDCARD_IN_EXACT_PHRASE: {
                    string = "search.error_wildcard_in_exact_phrase";
                    break;
                }
                case STARTS_WITH_WILDCARD: {
                    string = "search.error_starts_with_wildcard";
                    break;
                }
            }
        } else if (searchException instanceof SearchUnavailableException) {
            SearchUnavailableException.Type type = ((SearchUnavailableException)searchException).getType();
            switch (type) {
                case NO_SEARCH_DB: {
                    string = "search.no_db_found";
                    break;
                }
            }
        }
        return HelpUtils.getLocalizedString(string);
    }

    public static String getTopicKey(SearchException searchException) {
        String string = "matlab_env_helpsearch_unknown_error";
        if (searchException instanceof SearchStringParseException) {
            SearchStringParseException.Type type = ((SearchStringParseException)((Object)searchException)).getType();
            switch (type) {
                case MISMATCHED_QUOTES: {
                    string = "matlab_env_helpsearch_unmatched_quote";
                    break;
                }
                case TOO_FEW_CHARS: {
                    string = "matlab_env_helpsearch_invalid_term";
                    break;
                }
                case TOO_FEW_NONWILDCARD_CHARS: {
                    string = "matlab_env_helpsearch_wildcard_error";
                    break;
                }
                case WILDCARD_IN_EXACT_PHRASE: {
                    string = "matlab_env_helpsearch_wildcards_exact";
                    break;
                }
                case STARTS_WITH_WILDCARD: {
                    string = "matlab_env_helpsearch_wildcard_initialerror";
                }
            }
        } else if (searchException instanceof SearchUnavailableException) {
            SearchUnavailableException.Type type = ((SearchUnavailableException)searchException).getType();
            switch (type) {
                case NO_SEARCH_DB: {
                    string = "matlab_env_helpsearch_missing_database";
                    break;
                }
            }
        }
        return string;
    }
}

