/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.addon;

import com.mathworks.help.helpui.DocSetItemProperties;
import com.mathworks.mlwidgets.help.addon.InstalledSupportPackage;
import com.mathworks.mlwidgets.help.addon.SupportPackageInspectorProvider;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class InstalledPackageAccessor {
    private static final String DOCCENTER_PROPERTIES_FILE_NAME = "doccenter.properties";
    private static final String INSTALLED_PACKAGES_METHOD = "getInstalledPackages";
    private static final String LEGAL_NAME_METHOD = "getLegalName";
    private static final String HELP_ROOT_METHOD = "getSupportPackageHelpRoot";
    private static InstalledPackageAccessor sInstance = null;

    private InstalledPackageAccessor() {
    }

    public static synchronized InstalledPackageAccessor getInstance() {
        if (sInstance == null) {
            sInstance = new InstalledPackageAccessor();
        }
        return sInstance;
    }

    public static synchronized void invalidateCache() {
        sInstance = null;
    }

    public Collection<InstalledSupportPackage> getInstalledSupportPackages() {
        return Collections.unmodifiableCollection(this.findInstalledSupportPackages());
    }

    private Collection<InstalledSupportPackage> findInstalledSupportPackages() {
        try {
            return this.getInstalledPackages();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return Collections.emptyList();
        }
    }

    public Collection<InstalledSupportPackage> getInstalledPackages() throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        return InstalledPackageAccessor.getInstalledPackages(new DefaultSupportPackageInspectorProvider());
    }

    private static Collection<InstalledSupportPackage> getInstalledPackages(SupportPackageInspectorProvider supportPackageInspectorProvider) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object obj = Class.forName(supportPackageInspectorProvider.getInstalledPackageInspectorClassName()).newInstance();
        Method method = obj.getClass().getMethod(INSTALLED_PACKAGES_METHOD, new Class[0]);
        Object object = method.invoke(obj, new Object[0]);
        ArrayList<InstalledSupportPackage> arrayList = new ArrayList<InstalledSupportPackage>();
        if (object instanceof Object[]) {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])object) {
                InstalledSupportPackage installedSupportPackage;
                Method method2 = object2.getClass().getMethod(LEGAL_NAME_METHOD, new Class[0]);
                Object object3 = method2.invoke(object2, new Object[0]);
                Method method3 = object2.getClass().getMethod(HELP_ROOT_METHOD, new Class[0]);
                Object object4 = method3.invoke(object2, new Object[0]);
                if (object4 == null || object4.toString().isEmpty() || (installedSupportPackage = InstalledPackageAccessor.createSupportPackage(object4.toString(), object3.toString())) == null) continue;
                arrayList.add(installedSupportPackage);
            }
        }
        return arrayList;
    }

    private static InstalledSupportPackage createSupportPackage(String string, String string2) {
        File file = new File(new File(string), DOCCENTER_PROPERTIES_FILE_NAME);
        try {
            return InstalledPackageAccessor.createSupportPackageFromFile(file, string2);
        }
        catch (IOException | IllegalStateException exception) {
            System.err.println("Exception creating support package: " + exception.getMessage());
            return null;
        }
    }

    private static InstalledSupportPackage createSupportPackageFromFile(File file, String string) throws IOException, IllegalStateException {
        DocSetItemProperties docSetItemProperties = new DocSetItemProperties(file);
        docSetItemProperties.setProperty(DocSetItemProperties.Property.LEGAL_NAME, string);
        String string2 = docSetItemProperties.getBaseProductShortName();
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalStateException(file.getAbsolutePath() + " does not contain the baseshortname entry.");
        }
        return InstalledSupportPackage.buildSupportPackage(docSetItemProperties, file.getParent());
    }

    private static class DefaultSupportPackageInspectorProvider
    implements SupportPackageInspectorProvider {
        private DefaultSupportPackageInspectorProvider() {
        }

        @Override
        public String getInstalledPackageInspectorClassName() {
            return "com.mathworks.toolbox.shared.hwconnectinstaller.util.registry.InstalledPackageInspector";
        }
    }
}

