/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.html.DefaultWebReachableStrategy;
import com.mathworks.mlwidgets.html.WebReachableStrategy;
import java.util.HashMap;
import java.util.Map;

public class WebConnectivityStatus {
    private static WebReachableStrategy sWebReachableStrategy = null;
    private static final Map<String, WebReachableCheck> CACHE = new HashMap<String, WebReachableCheck>();

    private WebConnectivityStatus() {
    }

    public static boolean isOffline(String string) {
        return WebConnectivityStatus.isOffline(string, true);
    }

    public static boolean isOffline(String string, boolean bl) {
        WebReachableCheck webReachableCheck = WebConnectivityStatus.getRecentCheck(string);
        if (bl && webReachableCheck != null) {
            return webReachableCheck.iResult;
        }
        WebReachableStrategy webReachableStrategy = WebConnectivityStatus.getWebReachableStrategy();
        webReachableStrategy.setEndpoint(string);
        boolean bl2 = webReachableStrategy.isOffline();
        WebConnectivityStatus.cacheResult(string, bl2);
        return bl2;
    }

    private static synchronized WebReachableCheck getRecentCheck(String string) {
        WebReachableCheck webReachableCheck = CACHE.get(string);
        if (webReachableCheck != null && webReachableCheck.isRecent()) {
            return webReachableCheck;
        }
        return null;
    }

    private static synchronized void cacheResult(String string, boolean bl) {
        CACHE.put(string, new WebReachableCheck(bl));
    }

    public static void setWebReachableStrategy(WebReachableStrategy webReachableStrategy) {
        sWebReachableStrategy = webReachableStrategy;
    }

    public static WebReachableStrategy getWebReachableStrategy() {
        return sWebReachableStrategy == null ? new DefaultWebReachableStrategy() : sWebReachableStrategy;
    }

    private static class WebReachableCheck {
        private static final long CACHE_EXPIRATION = 60000L;
        private final long iWhen = System.currentTimeMillis();
        private final boolean iResult;

        private WebReachableCheck(boolean bl) {
            this.iResult = bl;
        }

        private boolean isRecent() {
            return System.currentTimeMillis() - this.iWhen < 60000L;
        }
    }
}

