/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TopicMapLocator {
    private static final String LOCATOR_FILE_NAME = "topicmaps.loc";
    private static final TopicMapLocator sTheLocator = new TopicMapLocator();
    private LocatorMapCache fLocatorMapCache = new LocatorMapCache();
    private static HelpDependencyProvider sDependencyProvider = new DefaultDependencyProvider();

    private TopicMapLocator() {
    }

    private LocatorMapCache getLocatorMapCache() {
        return this.fLocatorMapCache;
    }

    public static String getMapPath(String string) {
        return TopicMapLocator.getLocatorMap().get(string);
    }

    public static String[] getMapKeys() {
        Set<String> set = TopicMapLocator.getLocatorMap().keySet();
        return set.toArray(new String[set.size()]);
    }

    public static String[] getMapPaths() {
        Collection<String> collection = TopicMapLocator.getLocatorMap().values();
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] getMapKeysStartingWith(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : TopicMapLocator.getLocatorMap().keySet()) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void addTestCase(String string, String string2) {
        TopicMapLocator.getLocatorMap().put(string, string2);
    }

    private static Map<String, String> getLocatorMap() {
        return TopicMapLocator.sTheLocator.getLocatorMapCache().getLocatorMap(false);
    }

    public static void rebuild() {
        sTheLocator.getLocatorMapCache().rebuild();
    }

    private static synchronized void setDependencyProvider(HelpDependencyProvider helpDependencyProvider) {
        sDependencyProvider = helpDependencyProvider;
    }

    private static synchronized HelpDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    private static class DefaultDependencyProvider
    implements HelpDependencyProvider {
        private DefaultDependencyProvider() {
        }

        @Override
        public DocumentationSet getDocumentationSet() {
            return DocCenterDocConfig.getInstance().getDocumentationSet();
        }

        @Override
        public String getDocroot() {
            String string = HelpUtils.getDependencyProvider().getDocRoot();
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            return string;
        }
    }

    public static interface HelpDependencyProvider {
        public DocumentationSet getDocumentationSet();

        public String getDocroot();
    }

    private static class LocatorMapCache {
        private Map<String, String> fMap;
        private PrefListener fDocrootChangeListener;

        private LocatorMapCache() {
        }

        private synchronized Map<String, String> getLocatorMap(boolean bl) {
            if (this.fMap == null || bl) {
                this.fMap = this.buildMap();
            }
            return this.fMap;
        }

        private Map<String, String> buildMap() {
            if (this.fDocrootChangeListener == null) {
                this.fDocrootChangeListener = new PrefListener(){

                    public void prefChanged(PrefEvent prefEvent) {
                        LocatorMapCache.this.rebuild();
                    }
                };
                HelpPrefs.addPrefsListeners(this.fDocrootChangeListener, "HelpDocRoot");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            DocumentationSet documentationSet = TopicMapLocator.getDependencyProvider().getDocumentationSet();
            List list = documentationSet.getAllProducts();
            String string = TopicMapLocator.getDependencyProvider().getDocroot();
            for (DocProduct docProduct : list) {
                String string2 = string + docProduct.getHelpLocation();
                LocatorMapCache.readTopicMapFile(string2 + "/" + TopicMapLocator.LOCATOR_FILE_NAME, hashMap, string2);
            }
            return hashMap;
        }

        private static void readTopicMapFile(String string, Map<String, String> map, String string2) {
            try {
                LocatorMapCache.doReadTopicMapFile(string, map, string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void doReadTopicMapFile(String string, Map<String, String> map, String string2) throws IOException {
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
                while (bufferedReader.ready()) {
                    LocatorMapCache.readMapLine(bufferedReader, map, string2);
                }
            }
        }

        private static void readMapLine(BufferedReader bufferedReader, Map<String, String> map, String string) {
            try {
                String string2 = bufferedReader.readLine();
                String[] stringArray = string2.split("\\s+");
                if (stringArray.length > 1 && !map.containsKey(stringArray[0])) {
                    map.put(stringArray[0], string + "/" + stringArray[1]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void rebuild() {
            this.getLocatorMap(true);
        }
    }
}

