/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocConfig;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.help.helpui.json.JsonArray;
import com.mathworks.help.helpui.json.JsonEntity;
import com.mathworks.help.helpui.json.JsonObject;
import com.mathworks.helpsearch.HelpLocation;
import com.mathworks.helpsearch.product.DocAddOn;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.ProductFilter;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolRequestHandler;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ProductFilterRequestHandler
extends CustomProtocolRequestHandler {
    private final HtmlComponent fHtmlComponent;
    private final ProductFilter fProductFilter;
    private final DocRoot<? extends Url> fDocUrlBuilder;
    private final Collection<DocAddOn> fSelectedAddOns;
    private static final String URL_PREFIX = "productfilter";

    public ProductFilterRequestHandler(HtmlComponent htmlComponent, DocConfig<FileUrl> docConfig) {
        super(URL_PREFIX, new String[0]);
        this.fHtmlComponent = htmlComponent;
        this.fProductFilter = docConfig.getProductFilter();
        this.fDocUrlBuilder = docConfig.getDocRoot();
        this.fSelectedAddOns = ProductFilterRequestHandler.getSelectedAddOns(this.fProductFilter);
    }

    private static Collection<DocAddOn> getSelectedAddOns(ProductFilter productFilter) {
        Set set = productFilter.getSelectedProducts();
        if (set == null || set.isEmpty()) {
            return null;
        }
        HashSet<DocAddOn> hashSet = new HashSet<DocAddOn>();
        for (DocProduct docProduct : set) {
            Collection collection = docProduct.getDocAddOns();
            if (collection == null || collection.isEmpty()) continue;
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    protected void handleMatchedRequest(BrowserRequest browserRequest, final CustomProtocolUrl customProtocolUrl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String string = ProductFilterRequestHandler.this.getShortNameJsonArray();
                String string2 = ProductFilterRequestHandler.this.getAddOnJsonArray();
                String[] stringArray = customProtocolUrl.getCommand().split("\\|");
                ProductFilterRequestHandler.this.fHtmlComponent.executeScript(String.format("%s(%s);", stringArray[0], string));
                if (stringArray.length > 1) {
                    ProductFilterRequestHandler.this.fHtmlComponent.executeScript(String.format("%s(%s);", stringArray[1], string2));
                }
            }
        };
        new Thread(runnable).start();
    }

    private String getShortNameJsonArray() {
        JsonArray jsonArray = new JsonArray();
        Set set = this.fProductFilter.getSelectedProducts();
        for (DocProduct docProduct : set) {
            jsonArray.addString(docProduct.getShortName());
        }
        if (DocCenterUtils.hasClassicDoc()) {
            jsonArray.addString("3p");
        }
        return jsonArray.getJsonString();
    }

    private String getAddOnJsonArray() {
        JsonArray jsonArray = new JsonArray();
        if (!this.fSelectedAddOns.isEmpty()) {
            for (DocAddOn docAddOn : this.fSelectedAddOns) {
                JsonEntity jsonEntity = this.getAddOnJson((DocSetItem)docAddOn);
                jsonArray.addEntity(jsonEntity);
            }
        }
        return jsonArray.getJsonString();
    }

    private JsonEntity getAddOnJson(DocSetItem docSetItem) {
        String string = docSetItem.getDisplayName();
        String string2 = this.getLocation(docSetItem.getHelpLocation());
        JsonObject jsonObject = new JsonObject();
        jsonObject.addStringProperty("displayname", string);
        jsonObject.addStringProperty("helplocation", string2);
        return jsonObject;
    }

    private String getLocation(HelpLocation helpLocation) {
        Url url = this.fDocUrlBuilder.buildHelpLocationUrl(helpLocation);
        return url.toUrlBuilder().append(new String[]{"index.html"}).toString();
    }
}

