/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.ContentsData;
import com.mathworks.mlwidgets.help.FunctionCategoryXMLParser;
import com.mathworks.mlwidgets.help.HelpIcon;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeItemVisitor;
import com.mathworks.mlwidgets.help.ReferenceContainerItem;
import com.mathworks.mlwidgets.help.ReferenceItem;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import com.mathworks.mwswing.TreeUtils;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringEscapeUtils;

public class HelpTreeUtils {
    private static Map<String, Icon> sIconMap = new HashMap<String, Icon>();

    private HelpTreeUtils() {
    }

    public static Icon getIcon(String string) {
        if (string != null) {
            if (!sIconMap.containsKey(string)) {
                Icon icon = HelpTreeUtils.getActualIcon(string);
                sIconMap.put(string, icon);
                return icon;
            }
            return sIconMap.get(string);
        }
        return null;
    }

    private static Icon getActualIcon(String string) {
        if (string.startsWith("HelpIcon.")) {
            String string2 = string.substring("HelpIcon.".length());
            try {
                return HelpIcon.valueOf(string2).getIcon();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new ImageIcon(ProductInfoUtils.getToolboxDirectory(string));
    }

    public static boolean isValidTreeNode(TreeNode treeNode) {
        TreePath treePath = TreeUtils.nodeToPath((TreeNode)treeNode);
        return treePath.getPathComponent(0).equals(ContentsData.getRootNode());
    }

    public static HelpTreeItem getItemForTreeNode(TreeNode treeNode) {
        if (treeNode instanceof HelpTreeItem) {
            return (HelpTreeItem)((Object)treeNode);
        }
        if (treeNode instanceof FunctionCategoryXMLParser.Category) {
            return HelpTreeUtils.createReferenceItem((FunctionCategoryXMLParser.Category)treeNode);
        }
        if (treeNode instanceof FunctionCategoryXMLParser.FunctionItem) {
            return HelpTreeUtils.createReferenceItem((FunctionCategoryXMLParser.FunctionItem)treeNode);
        }
        return null;
    }

    private static ReferenceItem createReferenceItem(final FunctionCategoryXMLParser.Category category) {
        final ReferenceContainerItem referenceContainerItem = HelpTreeUtils.getContainerAncestor(category);
        return new ReferenceItem(){

            @Override
            public String getFilename() {
                return category.getRefPagePath();
            }

            @Override
            public String getLabel() {
                return category.getUserObject().toString();
            }

            @Override
            public String getShortLabel() {
                return this.getLabel();
            }

            @Override
            public Icon getIcon() {
                return null;
            }

            @Override
            public String getProduct() {
                return referenceContainerItem.getProduct();
            }

            @Override
            public TreeNode getTreeNode() {
                return category;
            }

            @Override
            public void addChild(TreeNode treeNode) {
            }

            @Override
            public void accept(HelpTreeItemVisitor helpTreeItemVisitor) {
                helpTreeItemVisitor.visit(this);
            }

            public String toString() {
                return this.getLabel();
            }
        };
    }

    private static ReferenceItem createReferenceItem(final FunctionCategoryXMLParser.FunctionItem functionItem) {
        final ReferenceContainerItem referenceContainerItem = HelpTreeUtils.getContainerAncestor(functionItem);
        return new ReferenceItem(){

            @Override
            public String getFilename() {
                return functionItem.getRefPagePath();
            }

            @Override
            public String getLabel() {
                String string = functionItem.getUserObject().toString();
                string = string == null ? "" : StringEscapeUtils.escapeHtml((String)string);
                String string2 = functionItem.getH1Line();
                string2 = string2 == null ? "" : StringEscapeUtils.escapeHtml((String)string2);
                return "<html>" + string + " - <i><font color=\"gray\">" + string2 + "</font></i></html>";
            }

            @Override
            public String getShortLabel() {
                return functionItem.getUserObject().toString();
            }

            @Override
            public Icon getIcon() {
                return referenceContainerItem.getIcon();
            }

            @Override
            public String getProduct() {
                return referenceContainerItem.getProduct();
            }

            @Override
            public TreeNode getTreeNode() {
                return functionItem;
            }

            @Override
            public void addChild(TreeNode treeNode) {
            }

            @Override
            public void accept(HelpTreeItemVisitor helpTreeItemVisitor) {
                helpTreeItemVisitor.visit(this);
            }

            public String toString() {
                return this.getLabel();
            }
        };
    }

    private static ReferenceContainerItem getContainerAncestor(TreeNode treeNode) {
        TreeNode treeNode2;
        for (treeNode2 = treeNode; treeNode2 != null && !(treeNode2 instanceof ReferenceContainerItem); treeNode2 = treeNode2.getParent()) {
        }
        return (ReferenceContainerItem)treeNode2;
    }
}

