/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocPage;
import com.mathworks.help.helpui.DocRoot;
import com.mathworks.helpsearch.SeeAlsoLink;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.HelpTopic;
import com.mathworks.mlwidgets.help.HelpUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;

class HelpTextBuilder {
    private static final int LINE_WIDTH = 80;
    private static final String INDENT = "    ";
    private static final String LINK_DELIMITER = ", ";
    private static final MessageFormat REF_PAGE_MESSAGE = new MessageFormat(HelpUtils.getLocalizedString("helpcmd.refpage.message"));
    private static final String SEE_ALSO_MESSAGE = HelpUtils.getLocalizedString("helpcmd.seealso.message") + " ";
    private static final MessageFormat OVERLOADS_MESSAGE = new MessageFormat(HelpUtils.getLocalizedString("helpcmd.overloads.message"));
    private final String fHelpTopic;
    private final String fDocCommandArg;
    private final ReferenceData fItem;
    private final List<ReferenceData> fOverloads = new ArrayList<ReferenceData>();
    private final DocRoot<? extends Url> fDocRoot = DocCenterDocConfig.getInstance().getDocRoot();
    private final boolean fHotLink;

    HelpTextBuilder(HelpTopic helpTopic, boolean bl) {
        this.fHelpTopic = helpTopic.getTopic();
        this.fDocCommandArg = helpTopic.getDocCommandArgument();
        this.fHotLink = bl;
        List<ReferenceData> list = helpTopic.getReferenceData();
        if (list.isEmpty()) {
            this.fItem = null;
        } else {
            this.fItem = list.get(0);
            if (list.size() > 1) {
                this.fOverloads.addAll(list.subList(1, list.size()));
            }
        }
    }

    public String getHelpText() {
        if (this.fItem == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHeader(stringBuilder);
        this.appendSyntaxLines(stringBuilder);
        if (this.fHotLink) {
            String string = this.highlightTopic(stringBuilder.toString());
            stringBuilder = new StringBuilder(string);
            this.appendRefPageLink(stringBuilder);
        }
        this.appendSeeAlsos(stringBuilder);
        this.appendOverloads(stringBuilder);
        return stringBuilder.toString();
    }

    private void appendHeader(StringBuilder stringBuilder) {
        stringBuilder.append(this.fHelpTopic).append(" - ").append(this.fItem.getPurposeLine());
        stringBuilder.append("\n\n");
        String string = WordUtils.wrap((String)this.fItem.getDescription(), (int)80, (String)"\n    ", (boolean)false);
        stringBuilder.append(INDENT).append(string).append('\n');
    }

    private void appendSyntaxLines(StringBuilder stringBuilder) {
        List list = this.fItem.getSyntaxLines();
        if (!list.isEmpty()) {
            for (String string : list) {
                stringBuilder.append('\n').append(INDENT).append(string);
            }
            stringBuilder.append('\n');
        }
    }

    private String highlightTopic(String string) {
        return string.replaceAll(Pattern.quote(this.fHelpTopic), "<strong>$0</strong>");
    }

    private void appendRefPageLink(StringBuilder stringBuilder) {
        String string = REF_PAGE_MESSAGE.format(new Object[]{this.fDocCommandArg});
        String string2 = String.format("<a href=\"matlab:doc %s\">%s</a>", this.fDocCommandArg, string);
        stringBuilder.append('\n').append(INDENT).append(string2).append('\n');
    }

    private void appendSeeAlsos(StringBuilder stringBuilder) {
        List list = this.fItem.getSeeAlsoLinks();
        if (!list.isEmpty()) {
            Map<DocPage, String> map = HelpTextBuilder.createSeeAlsoLinkMap(list);
            stringBuilder.append(this.wrapLinks(map, "\n    " + SEE_ALSO_MESSAGE, "        "));
            stringBuilder.append('\n');
        }
    }

    private static Map<DocPage, String> createSeeAlsoLinkMap(List<SeeAlsoLink> list) {
        LinkedHashMap<DocPage, String> linkedHashMap = new LinkedHashMap<DocPage, String>();
        for (SeeAlsoLink seeAlsoLink : list) {
            DocPage docPage = new DocPage((DocSetItem)seeAlsoLink.getProduct(), seeAlsoLink.getRelativePath());
            linkedHashMap.put(docPage, seeAlsoLink.getLabel());
        }
        return linkedHashMap;
    }

    private void appendOverloads(StringBuilder stringBuilder) {
        if (!this.fOverloads.isEmpty()) {
            String string = OVERLOADS_MESSAGE.format(new Object[]{this.fHelpTopic});
            stringBuilder.append('\n').append(INDENT).append(string);
            Map<DocPage, String> map = this.createOverloadsMap();
            stringBuilder.append(this.wrapLinks(map, "\n        ", "        "));
            stringBuilder.append('\n');
        }
    }

    private Map<DocPage, String> createOverloadsMap() {
        LinkedHashMap<DocPage, String> linkedHashMap = new LinkedHashMap<DocPage, String>();
        for (ReferenceData referenceData : this.fOverloads) {
            DocPage docPage = new DocPage(referenceData.getDocSetItem(), referenceData.getRelativePath());
            String string = referenceData.getDocSetItem().getShortName() + '/' + referenceData.getTopic();
            linkedHashMap.put(docPage, string);
        }
        return linkedHashMap;
    }

    private String wrapLinks(Map<DocPage, String> map, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 80 - string.length();
        for (Map.Entry<DocPage, String> entry : map.entrySet()) {
            String string3 = entry.getValue();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(LINK_DELIMITER);
                n -= LINK_DELIMITER.length();
            }
            if (string3.length() > n) {
                stringBuilder.append('\n').append(string2);
                n = 80 - string2.length();
            }
            Url url = this.fDocRoot.buildDocPageUrl(entry.getKey());
            stringBuilder.append(this.createHyperlink(url, string3));
            n -= string3.length();
        }
        stringBuilder.insert(0, string);
        return stringBuilder.toString();
    }

    private String createHyperlink(Url url, String string) {
        if (this.fHotLink) {
            return String.format("<a href=\"%s\">%s</a>", url.toString(), string);
        }
        return string;
    }
}

